/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class TFSBootstrapper
implements Bootstrapper {
    private static final Logger LOG = Logger.getLogger(TFSBootstrapper.class);
    private String itemSpec;
    private String username;
    private String password;
    private String tfPath = "tf";
    private String options;
    private boolean recursive = false;
    private boolean force = false;

    public void bootstrap() throws CruiseControlException {
        this.buildGetCommand().executeAndWait(LOG);
    }

    protected Commandline buildGetCommand() throws CruiseControlException {
        Commandline command = new Commandline();
        command.setExecutable(this.tfPath);
        command.createArgument().setValue("get");
        command.createArgument().setValue("-noprompt");
        command.createArgument().setValue(this.itemSpec);
        if (this.recursive) {
            command.createArgument().setValue("-recursive");
        }
        if (this.force) {
            command.createArgument().setValue("-force");
        }
        if (this.username != null && this.password != null) {
            command.createArgument().setValue("-login:" + this.username + "," + this.password + "");
        }
        if (this.options != null) {
            command.createArgument().setValue(this.options);
        }
        LOG.debug((Object)("Executing command: " + command));
        return command;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.itemSpec, "itemSpec", this.getClass());
    }

    public void setItemSpec(String itemSpec) {
        this.itemSpec = itemSpec;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTfPath(String tfPath) {
        this.tfPath = tfPath;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setOptions(String options) {
        this.options = options;
    }
}

