/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.io.File;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.bootstrappers.SVNBootstrapper;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class MercurialBootstrapper
implements Bootstrapper {
    private static final Logger LOG = Logger.getLogger(SVNBootstrapper.class);
    private String localWorkingCopy;

    public void setLocalWorkingCopy(String localWorkingCopy) {
        this.localWorkingCopy = localWorkingCopy;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.localWorkingCopy != null, "'localWorkingCopy' is a required attribute on the Mercurial bootstrapper task");
        if (this.localWorkingCopy != null) {
            File workingDir = new File(this.localWorkingCopy);
            ValidationHelper.assertTrue(workingDir.exists() && workingDir.isDirectory(), "'localWorkingCopy' must be an existing directory. Was" + workingDir.getAbsolutePath());
        }
    }

    public void bootstrap() throws CruiseControlException {
        this.buildPullUpdateCommand().executeAndWait(LOG);
    }

    Commandline buildPullUpdateCommand() throws CruiseControlException {
        Commandline command = new Commandline();
        command.setExecutable("hg");
        if (this.localWorkingCopy != null) {
            command.setWorkingDirectory(this.localWorkingCopy);
        }
        command.createArgument("pull");
        command.createArgument("-u");
        LOG.debug((Object)("Executing command = " + command));
        return command;
    }
}

