/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.AbstractFTPClass;
import net.sourceforge.cruisecontrol.util.CurrentBuildFileWriter;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class CurrentBuildStatusFTPBootstrapper
extends AbstractFTPClass
implements Bootstrapper {
    private static final Logger LOG = Logger.getLogger(CurrentBuildStatusFTPBootstrapper.class);
    private String fileName;
    private String destdir;

    public CurrentBuildStatusFTPBootstrapper() {
        LOG.warn((Object)"CurrentBuildStatusFTPBootstrapper was obsoleted by CurrentBuildStatusFTPListener");
    }

    public void setFile(String fileName) {
        this.fileName = fileName;
    }

    public void setDestDir(String dir) {
        this.destdir = dir;
    }

    public void bootstrap() throws CruiseControlException {
        String out = this.makeFile();
        String fname = this.destdir + File.separator + this.fileName;
        this.sendFileToFTPPath(out, fname);
    }

    protected String makeFile() throws CruiseControlException {
        CurrentBuildFileWriter.writefile("Current Build Started At:\n", new Date(), this.fileName);
        try {
            return Util.readFileToString(this.fileName);
        }
        catch (IOException ioe) {
            throw new CruiseControlException(ioe.getMessage());
        }
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.fileName, "file", this.getClass());
        ValidationHelper.assertIsSet((Object)this.destdir, "destdir", this.getClass());
        super.validate();
    }
}

