/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class ClearCaseViewstrapper
implements Bootstrapper {
    private static final Logger LOG = Logger.getLogger(ClearCaseViewstrapper.class);
    private String viewpath;
    private String voblist;

    public void setViewpath(String path) {
        this.viewpath = path;
    }

    public void setVoblist(String list) {
        this.voblist = list;
    }

    public void bootstrap() throws CruiseControlException {
        this.buildStartViewCommand().executeAndWait(LOG);
        if (this.voblist != null) {
            String[] vobs = this.getVobsFromList(this.voblist);
            for (int i = 0; i < vobs.length; ++i) {
                try {
                    LOG.debug((Object)("mount vob=" + vobs[i]));
                    this.buildMountVOBCommand(vobs[i]).executeAndWait(LOG);
                    continue;
                }
                catch (CruiseControlException cceMount) {
                    LOG.warn((Object)("mount exception=" + cceMount));
                }
            }
            try {
                LOG.debug((Object)("ls viewpath=" + this.viewpath));
                this.buildListVOBCommand(this.viewpath).executeAndWait(LOG);
            }
            catch (CruiseControlException cceList) {
                LOG.error((Object)("ls exception=" + cceList));
            }
        }
    }

    private String[] getVobsFromList(String voblist) {
        return voblist.split(",");
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.viewpath, "viewpath", this.getClass());
    }

    protected Commandline buildStartViewCommand() {
        Commandline commandLine = new Commandline();
        commandLine.setExecutable("cleartool");
        commandLine.createArguments("startview", this.getViewName());
        return commandLine;
    }

    protected Commandline buildMountVOBCommand(String vob) {
        Commandline commandLine = new Commandline();
        commandLine.setExecutable("cleartool");
        commandLine.createArguments("mount", vob);
        return commandLine;
    }

    protected Commandline buildListVOBCommand(String f) {
        Commandline commandLine = new Commandline();
        commandLine.setExecutable("cleartool");
        commandLine.createArguments("ls", f);
        return commandLine;
    }

    private String getViewName() {
        String viewname = this.isWindows() ? this.getWindowsViewname(this.viewpath) : this.getUnixViewname(this.viewpath);
        return viewname;
    }

    private String getUnixViewname(String viewpath) {
        String[] details = viewpath.split("/", 4);
        return details.length < 3 ? null : details[2];
    }

    private String getWindowsViewname(String viewpath) {
        String[] details = viewpath.split("\\\\", 3);
        return details.length < 2 ? null : details[1];
    }

    protected boolean isWindows() {
        return Util.isWindows();
    }
}

