/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.io.File;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class CVSBootstrapper
implements Bootstrapper {
    private static final Logger LOG = Logger.getLogger(CVSBootstrapper.class);
    private String localWorkingCopy;
    private String filename;
    private String cvsroot;
    private boolean resetStickyTags = false;
    private boolean overwriteChanges = false;
    private String compression;

    public void setCvsroot(String cvsroot) {
        this.cvsroot = cvsroot;
    }

    public void setFile(String filename) {
        this.filename = filename;
    }

    public void setLocalWorkingCopy(String local) {
        this.localWorkingCopy = local;
    }

    public void bootstrap() throws CruiseControlException {
        this.buildUpdateCommand().executeAndWait(LOG);
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.filename != null || this.cvsroot != null || this.localWorkingCopy != null, "at least one of 'file', 'cvsroot' or 'localworkingcopy' is required as an attribute for CVSBootstrapper");
        if (this.localWorkingCopy != null) {
            File workingDir = new File(this.localWorkingCopy);
            ValidationHelper.assertTrue(workingDir.exists(), "'localWorkingCopy' must be an existing directory. Was <" + this.localWorkingCopy + ">");
            ValidationHelper.assertTrue(workingDir.isDirectory(), "'localWorkingCopy' must be an existing directory, not a file. Was <" + this.localWorkingCopy + ">");
        }
        if (this.compression != null) {
            ValidationHelper.assertIntegerInRange(this.compression, 0, 9, "'compression' must be an integer between 0 and 9, inclusive.");
        }
    }

    protected Commandline buildUpdateCommand() throws CruiseControlException {
        Commandline commandLine = new Commandline();
        if (this.localWorkingCopy != null) {
            commandLine.setWorkingDirectory(this.localWorkingCopy);
        }
        commandLine.setExecutable("cvs");
        if (this.compression != null) {
            commandLine.createArgument("-z" + this.compression);
        }
        if (this.cvsroot != null) {
            commandLine.createArguments("-d", this.cvsroot);
        }
        commandLine.createArgument("update");
        StringBuffer flags = new StringBuffer("-dP");
        if (this.resetStickyTags) {
            flags.append("A");
        }
        if (this.overwriteChanges) {
            flags.append("C");
        }
        commandLine.createArgument(flags.toString());
        if (this.filename != null) {
            commandLine.createArgument(this.filename);
        }
        return commandLine;
    }

    public void setResetStickyTags(boolean reset) {
        this.resetStickyTags = reset;
    }

    public void setOverwriteChanges(boolean overwrite) {
        this.overwriteChanges = overwrite;
    }

    public void setCompression(String level) {
        this.compression = level;
    }
}

