/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.io.File;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.sourcecontrols.CMSynergy;
import net.sourceforge.cruisecontrol.util.ManagedCommandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class CMSynergyBootstrapper
implements Bootstrapper {
    private String ccmExe;
    private String projectSpec;
    private boolean recurse = true;
    private File sessionFile;
    private String sessionName;
    private static final Logger LOG = Logger.getLogger(CMSynergyBootstrapper.class);

    public void setCcmExe(String ccmExe) {
        this.ccmExe = ccmExe;
    }

    public void setProject(String projectSpec) {
        this.projectSpec = projectSpec;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public void setSessionFile(String sessionFile) {
        this.sessionFile = new File(sessionFile);
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void bootstrap() throws CruiseControlException {
        LOG.info((Object)("Reconfiguring project \"" + this.projectSpec + "\"."));
        ManagedCommandline cmd = CMSynergy.createCcmCommand(this.ccmExe, this.sessionName, this.sessionFile);
        cmd.createArgument("reconfigure");
        cmd.createArguments("-project", this.projectSpec);
        if (this.recurse) {
            cmd.createArgument("-recurse");
        }
        try {
            cmd.execute();
            cmd.assertExitCode(0);
        }
        catch (Exception e) {
            throw new CruiseControlException("Could not reconfigure the project \"" + this.projectSpec + "\".", e);
        }
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.projectSpec, "project", this.getClass());
    }
}

