/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.io.File;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.bootstrappers.CMSynergyBootstrapper;
import net.sourceforge.cruisecontrol.publishers.CMSynergyBaselinePublisher;
import net.sourceforge.cruisecontrol.sourcecontrols.CMSynergy;
import net.sourceforge.cruisecontrol.util.ManagedCommandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class CMSynergyBaselineBootstrapper
extends CMSynergyBaselinePublisher
implements Bootstrapper {
    private String ccmExe;
    private String projectSpec;
    private File sessionFile;
    private String sessionName;
    private String name;
    private String purpose = "Integration Testing";
    private String description;
    private String state = "published_baseline";
    private String build;
    private static final Logger LOG = Logger.getLogger(CMSynergyBootstrapper.class);

    public void setCcmExe(String ccmExe) {
        this.ccmExe = ccmExe;
    }

    public void setProject(String projectSpec) {
        this.projectSpec = projectSpec;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void setBaselineName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setSessionFile(String sessionFile) {
        this.sessionFile = new File(sessionFile);
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void bootstrap() throws CruiseControlException {
        LOG.info((Object)("Creating baseline \"" + this.name + "\"."));
        ManagedCommandline cmd = CMSynergy.createCcmCommand(this.ccmExe, this.sessionName, this.sessionFile);
        cmd.createArgument("baseline");
        cmd.createArgument("-create");
        if (this.name != null) {
            cmd.createArgument(this.name);
        }
        if (this.description != null) {
            cmd.createArguments("-description", this.description);
        }
        cmd.createArguments("-release", this.getProjectRelease(this.projectSpec, this.sessionName));
        cmd.createArguments("-purpose", this.purpose);
        cmd.createArguments("-project", this.projectSpec);
        cmd.createArgument("-subprojects");
        double version = this.getVersion();
        if (version >= 6.4 & !this.build.equals(null)) {
            cmd.createArguments("-build", this.build);
        }
        if (version >= 6.4) {
            cmd.createArguments("-state", this.state);
        }
        try {
            LOG.info((Object)"Creating Synergy baseline...");
            cmd.execute();
            cmd.assertExitCode(0);
        }
        catch (Exception e) {
            StringBuffer error = new StringBuffer("Failed to create intermediate baseline for project \"");
            error.append(this.getProject());
            error.append("\".");
            throw new CruiseControlException(error.toString(), e);
        }
        StringBuffer message = new StringBuffer("Created baseline");
        if (this.name != null) {
            message.append(" ").append(this.name);
        }
        message.append(".");
        LOG.info((Object)message.toString());
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.projectSpec, "project", this.getClass());
    }
}

