/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.io.IOException;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.sourcecontrols.AlienBrainCore;
import net.sourceforge.cruisecontrol.util.ManagedCommandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;

public class AlienBrainBootstrapper
extends AlienBrainCore
implements Bootstrapper {
    private String localPath;
    private boolean forceFileUpdate;
    private String overwriteWritable = "skip";

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void setForceFileUpdate(boolean forceFileUpdate) {
        this.forceFileUpdate = forceFileUpdate;
    }

    public void setOverwriteWritable(String policy) {
        this.overwriteWritable = policy.toLowerCase();
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.getPath(), "path", this.getClass());
        ValidationHelper.assertTrue("skip".equals(this.overwriteWritable) || "replace".equals(this.overwriteWritable), "overwritewritable must be one of 'skip' or 'replace' in AlienBrainBootstrapper");
    }

    public void bootstrap() throws CruiseControlException {
        try {
            if (this.getBranch() != null) {
                this.setActiveBranch(this.getBranch());
            }
            ManagedCommandline cmdLine = this.buildBootstrapCommand();
            cmdLine.execute();
        }
        catch (IOException e) {
            throw new CruiseControlException("Error executing AlienBrain bootstrap", e);
        }
    }

    public ManagedCommandline buildBootstrapCommand() {
        ManagedCommandline cmdLine = this.buildCommonCommand();
        cmdLine.createArguments("getlatest", this.getPath());
        this.addArgumentIfSet(cmdLine, this.localPath, "-localpath");
        this.addFlagIfSet(cmdLine, this.forceFileUpdate, "-forcefileupdate");
        this.addArgumentIfSet(cmdLine, this.overwriteWritable, "-overwritewritable");
        return cmdLine;
    }
}

