/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.AccurevCommand;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.AccurevCommandline;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.Runner;

public class AccurevBootstrapper
implements Bootstrapper {
    private boolean verbose;
    private boolean keep;
    private boolean synctime;
    private String workspace;
    private Runner runner;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public void setSynctime(boolean synctime) {
        this.synctime = synctime;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    private void runAccurev(AccurevCommandline cmd) throws CruiseControlException {
        if (this.runner != null) {
            cmd.setRunner(this.runner);
        }
        cmd.setWorkspaceLocalPath(this.workspace);
        cmd.setVerbose(this.verbose);
        cmd.run();
        cmd.assertSuccess();
    }

    public void bootstrap() throws CruiseControlException {
        if (this.synctime) {
            this.runAccurev(AccurevCommand.SYNCTIME.create());
        }
        if (this.keep) {
            AccurevCommandline cmdKeep = AccurevCommand.KEEP.create();
            cmdKeep.selectModified();
            cmdKeep.setComment("CruiseControl automatic keep");
            this.runAccurev(cmdKeep);
        }
        this.runAccurev(AccurevCommand.UPDATE.create());
    }

    public void setRunner(Runner runner) {
        this.runner = runner;
    }

    public void validate() throws CruiseControlException {
    }
}

