/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.File;
import net.sourceforge.cruisecontrol.util.Util;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class ServerXMLHelper {
    private static final Logger LOG = Logger.getLogger(ServerXMLHelper.class);
    private int numThreads = 1;

    public ServerXMLHelper(File configFile) {
        try {
            Element configLogElement = Util.loadRootElement(configFile);
            Element systemElement = configLogElement.getChild("system");
            if (systemElement == null) {
                LOG.debug((Object)"no system element found in config.xml");
                return;
            }
            Element configurationElement = systemElement.getChild("configuration");
            if (configurationElement == null) {
                LOG.debug((Object)"no configuraiton element found in config.xml");
                return;
            }
            Element threadElement = configurationElement.getChild("threads");
            if (threadElement == null) {
                LOG.debug((Object)"no threads element found in config.xml");
                return;
            }
            Attribute threadCount = threadElement.getAttribute("count");
            LOG.debug((Object)("count attribute on threads is " + threadCount.toString()));
            try {
                this.numThreads = threadCount.getIntValue();
            }
            catch (DataConversionException dce) {
                LOG.error((Object)("Expected a numeric value for system-configuration-threads-count in config.xml but found " + threadCount.toString()), (Throwable)dce);
                this.numThreads = 1;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"error parsing thread count from config file; defaulting to 1 thread.", (Throwable)e);
            this.numThreads = 1;
        }
    }

    public int getNumThreads() {
        return this.numThreads;
    }
}

