/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlController;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.PluginRegistry;
import net.sourceforge.cruisecontrol.PluginXMLHelper;
import net.sourceforge.cruisecontrol.ProjectHelper;
import net.sourceforge.cruisecontrol.config.DefaultPropertiesPlugin;
import net.sourceforge.cruisecontrol.config.PropertiesPlugin;
import net.sourceforge.cruisecontrol.util.Util;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectXMLHelper
implements ProjectHelper {
    private static final Logger LOG = Logger.getLogger(ProjectXMLHelper.class);
    private final Map<String, String> projectProperties;
    private final PluginRegistry projectPlugins;
    private final CruiseControlController controller;

    public ProjectXMLHelper() {
        this(new HashMap<String, String>(), PluginRegistry.createRegistry(PluginRegistry.loadDefaultPluginRegistry()), null);
    }

    public ProjectXMLHelper(Map<String, String> projectProperties, PluginRegistry projectPlugins) {
        this(projectProperties, projectPlugins, null);
    }

    public ProjectXMLHelper(Map<String, String> projectProperties, PluginRegistry projectPlugins, CruiseControlController controller) {
        this.projectProperties = projectProperties;
        this.projectPlugins = projectPlugins;
        this.controller = controller;
    }

    @Override
    public Object configurePlugin(Element pluginElement, boolean skipChildElements) throws CruiseControlException {
        String name = pluginElement.getName();
        PluginXMLHelper pluginHelper = new PluginXMLHelper(this, this.controller);
        String pluginName = pluginElement.getName();
        LOG.debug((Object)("configuring plugin " + pluginElement.getName() + " skip " + skipChildElements));
        if (this.projectPlugins.isPluginRegistered(pluginName)) {
            Object pluginInstance = this.getConfiguredPlugin(pluginHelper, pluginElement.getName());
            if (pluginInstance != null) {
                return pluginHelper.configure(pluginElement, pluginInstance, skipChildElements);
            }
            return pluginHelper.configure(pluginElement, this.projectPlugins.getPluginClass(pluginName), skipChildElements);
        }
        throw new CruiseControlException("Unknown plugin for: <" + name + ">");
    }

    private Object getConfiguredPlugin(PluginXMLHelper pluginHelper, String pluginName) throws CruiseControlException {
        Class pluginClass = this.projectPlugins.getPluginClass(pluginName);
        if (pluginClass == null) {
            return null;
        }
        Object configuredPlugin = null;
        Element pluginElement = this.projectPlugins.getPluginConfig(pluginName);
        if (pluginElement != null) {
            this.parsePropertiesInElement(pluginElement);
            configuredPlugin = pluginHelper.configure(pluginElement, pluginClass, false);
        }
        return configuredPlugin;
    }

    private void parsePropertiesInElement(Element element) throws CruiseControlException {
        ProjectXMLHelper.parsePropertiesInElement(element, this.projectProperties, false);
    }

    public static DefaultPropertiesPlugin registerProperty(Map<String, String> props, Element propertyElement, boolean failIfMissing) throws CruiseControlException {
        ProjectXMLHelper.parsePropertiesInElement(propertyElement, props, failIfMissing);
        Object o = new ProjectXMLHelper().configurePlugin(propertyElement, false);
        if (!(o instanceof DefaultPropertiesPlugin)) {
            throw new CruiseControlException("Properties element does not extend DefaultPropertiesPlugin interface. Check your CC global plugin configuration.");
        }
        DefaultPropertiesPlugin propertiesObject = (DefaultPropertiesPlugin)o;
        propertiesObject.loadProperties(props, failIfMissing);
        return propertiesObject;
    }

    public static PropertiesPlugin registerCustomProperty(Map<String, String> props, Element propertyElement, boolean failIfMissing, PluginRegistry registry) throws CruiseControlException {
        ProjectXMLHelper.parsePropertiesInElement(propertyElement, props, failIfMissing);
        Object o = new ProjectXMLHelper(props, registry, null).configurePlugin(propertyElement, false);
        if (!(o instanceof PropertiesPlugin)) {
            throw new CruiseControlException("Element " + propertyElement.getName() + " does not implement PropertiesPlugin interface." + " Check your CC global plugin configuration.");
        }
        PropertiesPlugin propertiesObject = (PropertiesPlugin)o;
        propertiesObject.loadProperties(props, failIfMissing);
        return propertiesObject;
    }

    public static void parsePropertiesInElement(Element element, Map<String, String> props, boolean failIfMissing) throws CruiseControlException {
        Iterator children = element.getChildren().iterator();
        while (children.hasNext()) {
            ProjectXMLHelper.parsePropertiesInElement((Element)children.next(), props, failIfMissing);
        }
        for (Attribute attribute : element.getAttributes()) {
            attribute.setValue(Util.parsePropertiesInString(props, attribute.getValue(), failIfMissing));
        }
        String text = element.getTextTrim();
        if (text.length() > 0) {
            element.setText(Util.parsePropertiesInString(props, text, failIfMissing));
        }
    }

    public static void setProperty(Map<String, String> props, String name, String parsedValue) {
        LOG.debug((Object)("Setting property \"" + name + "\" to \"" + parsedValue + "\"."));
        props.put(name, parsedValue);
    }
}

