/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import net.sourceforge.cruisecontrol.ProjectInterface;
import net.sourceforge.cruisecontrol.util.threadpool.WorkerThread;
import org.apache.log4j.Logger;

public class ProjectWrapper
implements WorkerThread {
    private final ProjectInterface myProject;
    private static final Logger LOG = Logger.getLogger(ProjectWrapper.class);
    private boolean doneBuilding;
    private final Object doneBuildingMutex = new Object();

    public ProjectWrapper(ProjectInterface thisProject) {
        if (thisProject == null) {
            throw new IllegalArgumentException("null thisProject");
        }
        LOG.debug((Object)("Project " + thisProject.getName() + " is being wrapped"));
        this.myProject = thisProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.debug((Object)("executing project " + this.myProject.getName()));
        try {
            this.myProject.execute();
        }
        finally {
            this.setDoneBuilding();
        }
    }

    public Object getResult() {
        if (this.doneBuilding()) {
            return "finished";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDoneBuilding() {
        Object object = this.doneBuildingMutex;
        synchronized (object) {
            this.doneBuilding = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doneBuilding() {
        Object object = this.doneBuildingMutex;
        synchronized (object) {
            return this.doneBuilding;
        }
    }

    public String getName() {
        return this.myProject.getName();
    }
}

