/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServer;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.BuildQueue;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.LabelIncrementer;
import net.sourceforge.cruisecontrol.Listener;
import net.sourceforge.cruisecontrol.Log;
import net.sourceforge.cruisecontrol.ModificationSet;
import net.sourceforge.cruisecontrol.Project;
import net.sourceforge.cruisecontrol.ProjectInterface;
import net.sourceforge.cruisecontrol.ProjectState;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.Schedule;
import net.sourceforge.cruisecontrol.config.DefaultPropertiesPlugin;
import net.sourceforge.cruisecontrol.config.PluginPlugin;
import net.sourceforge.cruisecontrol.labelincrementers.DefaultLabelIncrementer;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConfig
implements ProjectInterface {
    private static final long serialVersionUID = -893779421250033198L;
    private static final Logger LOG = Logger.getLogger(ProjectConfig.class);
    private String name;
    private boolean buildAfterFailed = true;
    private boolean forceOnly = false;
    private boolean requiremodification = true;
    private boolean forceBuildNewProject = true;
    private transient Bootstrappers bootstrappers;
    private transient LabelIncrementer labelIncrementer;
    private transient Listeners listeners;
    private transient Log log;
    private transient ModificationSet modificationSet;
    private transient Publishers publishers;
    private transient Schedule schedule;
    private Project project;

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.schedule != null, "project requires a schedule");
        if (this.labelIncrementer == null) {
            this.labelIncrementer = new DefaultLabelIncrementer();
        }
        if (this.bootstrappers != null) {
            this.bootstrappers.validate();
        }
        if (this.listeners != null) {
            this.listeners.validate();
        }
        if (this.log == null) {
            this.log = new Log();
        }
        this.log.setProjectName(this.name);
        this.log.validate();
        if (this.modificationSet != null) {
            this.modificationSet.validate();
        }
        if (this.schedule != null) {
            this.schedule.validate();
        }
        if (this.publishers != null) {
            this.publishers.validate();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBuildAfterFailed(boolean buildAfterFailed) {
        this.buildAfterFailed = buildAfterFailed;
    }

    public void setForceBuildNewProject(boolean forceBuildNewProject) {
        this.forceBuildNewProject = forceBuildNewProject;
    }

    public void add(DefaultPropertiesPlugin plugin) {
    }

    public void add(PluginPlugin plugin) {
    }

    public void add(LabelIncrementer labelIncrementer) {
        if (this.labelIncrementer != null) {
            LOG.warn((Object)("replacing existing label incrememnter [" + this.labelIncrementer.toString() + "] with new one [" + labelIncrementer.toString() + "]"));
        }
        this.labelIncrementer = labelIncrementer;
    }

    public void add(Listeners listeners) {
        this.listeners = listeners;
    }

    public void add(ModificationSet modificationSet) {
        this.modificationSet = modificationSet;
    }

    public void add(Bootstrappers bootstrappers) {
        this.bootstrappers = bootstrappers;
    }

    public void add(Publishers publishers) {
        this.publishers = publishers;
    }

    public void add(Schedule schedule) {
        this.schedule = schedule;
    }

    public void add(Log log) {
        this.log = log;
    }

    public boolean shouldBuildAfterFailed() {
        return this.buildAfterFailed;
    }

    public Log getLog() {
        return this.log;
    }

    public List<Bootstrapper> getBootstrappers() {
        return this.bootstrappers == null ? Collections.emptyList() : this.bootstrappers.getBootstrappers();
    }

    public List<Listener> getListeners() {
        return this.listeners == null ? Collections.emptyList() : this.listeners.getListeners();
    }

    public List<Publisher> getPublishers() {
        return this.publishers == null ? Collections.emptyList() : this.publishers.getPublishers();
    }

    public ModificationSet getModificationSet() {
        return this.modificationSet;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public LabelIncrementer getLabelIncrementer() {
        return this.labelIncrementer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setForceOnly(boolean forceOnly) {
        this.forceOnly = forceOnly;
    }

    public boolean isForceOnly() {
        return this.forceOnly;
    }

    public boolean isRequiremodification() {
        return this.requiremodification;
    }

    public void setRequiremodification(boolean requiremodification) {
        this.requiremodification = requiremodification;
    }

    @Override
    public void configureProject() throws CruiseControlException {
        Project myProject = this.readProject(this.name);
        myProject.setName(this.name);
        myProject.setProjectConfig(this);
        myProject.init();
        this.project = myProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Project readProject(String projectName) {
        Project project;
        File serializedProjectFile = new File(projectName + ".ser");
        LOG.debug((Object)("Reading serialized project from: " + serializedProjectFile.getAbsolutePath()));
        if (!serializedProjectFile.exists() || !serializedProjectFile.canRead()) {
            serializedProjectFile = ProjectConfig.tryOldSerializedFileName(projectName);
        }
        if (!serializedProjectFile.exists() || !serializedProjectFile.canRead() || serializedProjectFile.isDirectory()) {
            Project newProject = new Project();
            newProject.setName(projectName);
            if (this.forceBuildNewProject) {
                LOG.warn((Object)("No previously serialized project found [" + serializedProjectFile.getAbsolutePath() + ".ser], forcing a build."));
                newProject.setBuildForced(true);
            } else {
                LOG.warn((Object)("No previously serialized project found  [" + serializedProjectFile.getAbsolutePath() + ".ser], Not forcing build, forceBuildNewProject = false."));
            }
            return newProject;
        }
        ObjectInputStream s = new ObjectInputStream(new FileInputStream(serializedProjectFile));
        try {
            project = (Project)s.readObject();
        }
        catch (Throwable throwable) {
            try {
                s.close();
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn((Object)("Error deserializing project file from " + serializedProjectFile.getAbsolutePath()), (Throwable)e);
                return new Project();
            }
        }
        s.close();
        return project;
    }

    private static File tryOldSerializedFileName(String projectName) {
        File serializedProjectFile = new File(projectName);
        LOG.debug((Object)(projectName + ".ser not found, looking for serialized project file " + serializedProjectFile.getAbsolutePath()));
        return serializedProjectFile;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass().getName().equals(this.getClass().getName())) {
            ProjectConfig thatProject = (ProjectConfig)arg0;
            return thatProject.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (this.project != null) {
            return this.project.toString();
        }
        return super.toString();
    }

    @Override
    public void getStateFromOldProject(ProjectInterface oldProject) throws CruiseControlException {
        ProjectConfig oldProjectConfig = (ProjectConfig)oldProject;
        this.project = oldProjectConfig.project;
        this.project.setProjectConfig(this);
        this.project.init();
    }

    @Override
    public void execute() {
        this.project.execute();
    }

    @Override
    public void register(MBeanServer server) throws JMException {
        this.project.register(server);
    }

    @Override
    public void setBuildQueue(BuildQueue buildQueue) {
        this.project.setBuildQueue(buildQueue);
    }

    @Override
    public void start() {
        this.project.start();
    }

    @Override
    public void stop() {
        this.project.stop();
    }

    Project getProject() {
        return this.project;
    }

    public String getStatus() {
        return this.project.getStatus();
    }

    public String getBuildStartTime() {
        return this.project.getBuildStartTime();
    }

    public boolean isPaused() {
        return this.project.isPaused();
    }

    public List getModifications() {
        if (this.getModificationSet() != null) {
            return this.getModificationSet().getCurrentModifications();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isInState(ProjectState state) {
        return this.project.getState().equals(state);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Publishers
    implements Serializable {
        private static final long serialVersionUID = -410933401108345152L;
        private final List<Publisher> publishers = new ArrayList<Publisher>();

        public void add(Publisher publisher) {
            this.publishers.add(publisher);
        }

        public List<Publisher> getPublishers() {
            return this.publishers;
        }

        public void validate() throws CruiseControlException {
            for (Publisher nextPublisher : this.publishers) {
                nextPublisher.validate();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Listeners
    implements Serializable {
        private static final long serialVersionUID = -3816080104514876038L;
        private final List<Listener> listeners = new ArrayList<Listener>();

        public void add(Listener listener) {
            this.listeners.add(listener);
        }

        public List<Listener> getListeners() {
            return this.listeners;
        }

        public void validate() throws CruiseControlException {
            for (Listener nextListener : this.listeners) {
                nextListener.validate();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Bootstrappers
    implements Serializable {
        private static final long serialVersionUID = 7428779281399848035L;
        private final List<Bootstrapper> bootstrappers = new ArrayList<Bootstrapper>();

        public void add(Bootstrapper bootstrapper) {
            this.bootstrappers.add(bootstrapper);
        }

        public List<Bootstrapper> getBootstrappers() {
            return this.bootstrappers;
        }

        public void validate() throws CruiseControlException {
            for (Bootstrapper nextBootstrapper : this.bootstrappers) {
                nextBootstrapper.validate();
            }
        }
    }
}

