/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.BuildQueue;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.LabelIncrementer;
import net.sourceforge.cruisecontrol.Listener;
import net.sourceforge.cruisecontrol.Log;
import net.sourceforge.cruisecontrol.ModificationSet;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.ProgressImpl;
import net.sourceforge.cruisecontrol.ProjectConfig;
import net.sourceforge.cruisecontrol.ProjectEvent;
import net.sourceforge.cruisecontrol.ProjectState;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.Schedule;
import net.sourceforge.cruisecontrol.events.BuildProgressEvent;
import net.sourceforge.cruisecontrol.events.BuildProgressListener;
import net.sourceforge.cruisecontrol.events.BuildResultEvent;
import net.sourceforge.cruisecontrol.events.BuildResultListener;
import net.sourceforge.cruisecontrol.jmx.ProjectController;
import net.sourceforge.cruisecontrol.listeners.ProjectStateChangedEvent;
import net.sourceforge.cruisecontrol.util.CVSDateUtil;
import net.sourceforge.cruisecontrol.util.DateUtil;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
implements Serializable,
Runnable {
    static final long serialVersionUID = 2656877748476842326L;
    private static final Logger LOG = Logger.getLogger(Project.class);
    private transient ProjectState state;
    private transient ProjectConfig projectConfig;
    private transient LabelIncrementer labelIncrementer;
    private transient Long overrideBuildInterval;
    private transient Date buildStartTime;
    private transient Object pausedMutex;
    private transient Object scheduleMutex;
    private transient Object waitMutex;
    private transient BuildQueue queue;
    private transient List<BuildProgressListener> progressListeners;
    private transient List<BuildResultListener> resultListeners;
    private transient Progress progress;
    private int buildCounter = 0;
    private Date lastBuild;
    private Date lastSuccessfulBuild = this.lastBuild = DateUtil.getMidnight();
    private boolean wasLastBuildSuccessful = true;
    private String label;
    private String name;
    private transient boolean buildForced = false;
    private String buildTarget = null;
    private boolean isPaused = false;
    private boolean buildAfterFailed = true;
    private boolean stopped = true;
    private boolean forceOnly = false;
    private boolean requiremodification = true;

    public Project() {
        this.initializeTransientFields();
    }

    private void initializeTransientFields() {
        this.state = ProjectState.STOPPED;
        this.pausedMutex = new Object();
        this.scheduleMutex = new Object();
        this.waitMutex = new Object();
        this.progressListeners = new ArrayList<BuildProgressListener>();
        this.resultListeners = new ArrayList<BuildResultListener>();
        this.progress = new ProgressImpl(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initializeTransientFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.stopped) {
            LOG.warn((Object)("not building project " + this.name + " because project has been stopped."));
            this.buildFinished();
            return;
        }
        Object object = this.pausedMutex;
        synchronized (object) {
            if (this.isPaused) {
                LOG.info((Object)("not building project " + this.name + " because project has been paused."));
                this.buildFinished();
                return;
            }
        }
        try {
            this.init();
            this.build();
        }
        catch (CruiseControlException e) {
            LOG.error((Object)("exception attempting build in project " + this.name), (Throwable)e);
        }
        finally {
            this.buildFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void build() throws CruiseControlException {
        if (this.projectConfig == null) {
            throw new IllegalStateException("projectConfig must be set on project before calling build()");
        }
        if (this.stopped) {
            LOG.warn((Object)("not building project " + this.name + " because project has been stopped."));
            return;
        }
        if (this.forceOnly && !this.buildForced && (this.wasLastBuildSuccessful || !this.buildAfterFailed)) {
            this.info("not building because project is forceOnly and build not forced.");
            return;
        }
        boolean buildWasForced = this.buildForced;
        try {
            this.setBuildStartTime(new Date());
            Schedule schedule = this.projectConfig.getSchedule();
            if (schedule == null) {
                throw new IllegalStateException("project must have a schedule");
            }
            if (schedule.isPaused(this.buildStartTime)) {
                return;
            }
            this.bootstrap();
            String target = this.useAndResetBuildTargetIfBuildWasForced(buildWasForced);
            Element modifications = this.getModifications(buildWasForced);
            if (modifications == null) {
                return;
            }
            Log buildLog = this.projectConfig.getLog();
            buildLog.addContent((Content)modifications);
            Date now = this.projectConfig.getModificationSet() != null && this.projectConfig.getModificationSet().getTimeOfCheck() != null ? this.projectConfig.getModificationSet().getTimeOfCheck() : new Date();
            if (this.getLabelIncrementer().isPreBuildIncrementer()) {
                this.label = this.getLabelIncrementer().incrementLabel(this.label, buildLog.getContent());
            }
            buildLog.addContent((Content)this.getProjectPropertiesElement(now));
            this.setState(ProjectState.BUILDING);
            Element builderLog = schedule.build(this.buildCounter, this.lastBuild, now, this.getProjectPropertiesMap(now), target, this.progress);
            buildLog.addContent(builderLog.detach());
            boolean buildSuccessful = buildLog.wasBuildSuccessful();
            this.fireResultEvent(new BuildResultEvent(this, buildSuccessful));
            if (!this.getLabelIncrementer().isPreBuildIncrementer() && buildSuccessful) {
                this.label = this.getLabelIncrementer().incrementLabel(this.label, buildLog.getContent());
            }
            this.setState(ProjectState.MERGING_LOGS);
            buildLog.writeLogFile(now);
            if (!this.buildAfterFailed) {
                this.lastBuild = now;
            }
            if (buildSuccessful) {
                this.lastBuild = now;
                this.lastSuccessfulBuild = now;
                this.info("build successful");
            } else {
                this.info("build failed");
            }
            ++this.buildCounter;
            this.setWasLastBuildSuccessful(buildSuccessful);
            this.serializeProject();
            this.publish(buildLog);
            buildLog.reset();
        }
        finally {
            this.resetBuildForcedOnlyIfBuildWasForced(buildWasForced);
            this.setState(ProjectState.IDLE);
        }
    }

    private String useAndResetBuildTargetIfBuildWasForced(boolean buildWasForced) {
        String target = null;
        if (buildWasForced) {
            target = this.buildTarget;
            this.buildTarget = null;
        }
        return target;
    }

    private void resetBuildForcedOnlyIfBuildWasForced(boolean buildWasForced) {
        if (buildWasForced) {
            this.buildForced = false;
        }
    }

    void setBuildStartTime(Date date) {
        this.buildStartTime = date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            LOG.info((Object)("Project " + this.name + " started"));
            while (true) {
                if (this.stopped) break block10;
                try {
                    this.waitIfPaused();
                    if (!this.stopped) {
                        this.waitForNextBuild();
                    }
                    if (this.stopped) continue;
                    this.setState(ProjectState.QUEUED);
                    Object object = this.scheduleMutex;
                    synchronized (object) {
                        this.queue.requestBuild(this.projectConfig);
                        this.waitForBuildToFinish();
                    }
                }
                catch (InterruptedException e) {
                    String message = "Project " + this.name + ".run() interrupted";
                    LOG.error((Object)message, (Throwable)e);
                    throw new RuntimeException(message);
                }
            }
            finally {
                this.stopped = true;
                LOG.info((Object)("Project " + this.name + " stopped"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitIfPaused() throws InterruptedException {
        Object object = this.pausedMutex;
        synchronized (object) {
            while (this.isPaused) {
                this.setState(ProjectState.PAUSED);
                this.pausedMutex.wait(600000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForNextBuild() throws InterruptedException {
        long waitTime = this.getTimeToNextBuild(new Date());
        if (Project.needToWaitForNextBuild(waitTime) && !this.buildForced) {
            String msg = "next build in " + DateUtil.formatTime(waitTime);
            this.info(msg);
            Object object = this.waitMutex;
            synchronized (object) {
                this.setState(ProjectState.WAITING);
                this.progress.setValue(msg);
                this.waitMutex.wait(waitTime);
            }
        }
    }

    long getTimeToNextBuild(Date now) {
        long millisSinceLastBuild;
        long waitTime = this.projectConfig.getSchedule().getTimeToNextBuild(now, this.getBuildInterval());
        if (waitTime == 0L && this.buildStartTime != null && (millisSinceLastBuild = now.getTime() - this.buildStartTime.getTime()) < 60000L) {
            this.debug("build finished within a minute, getting new time to next build");
            Date oneMinuteInFuture = new Date(now.getTime() + 60000L);
            waitTime = this.projectConfig.getSchedule().getTimeToNextBuild(oneMinuteInFuture, this.getBuildInterval());
            waitTime += 60000L;
        }
        return waitTime;
    }

    static boolean needToWaitForNextBuild(long waitTime) {
        return waitTime > 0L;
    }

    boolean isBuildForced() {
        return this.buildForced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceBuild() {
        Object object = this.waitMutex;
        synchronized (object) {
            this.waitMutex.notify();
        }
    }

    public void forceBuildWithTarget(String buildTarget) {
        this.buildTarget = buildTarget;
        this.setBuildForced(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForBuildToFinish() throws InterruptedException {
        Object object = this.scheduleMutex;
        synchronized (object) {
            this.debug("waiting for build to finish");
            this.scheduleMutex.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildFinished() {
        Object object = this.scheduleMutex;
        synchronized (object) {
            this.debug("build finished");
            this.scheduleMutex.notify();
        }
    }

    Element getModifications(boolean buildWasForced) {
        Element modifications;
        this.setState(ProjectState.MODIFICATIONSET);
        ModificationSet modificationSet = this.projectConfig.getModificationSet();
        if (modificationSet == null) {
            this.debug("no modification set, nothing to detect.");
            if (buildWasForced) {
                this.info("no modification set but build was forced");
                return new Element("modifications");
            }
            if (!this.requiremodification) {
                this.info("no modification set but no modifications required");
                return new Element("modifications");
            }
            return null;
        }
        boolean checkNewChangesFirst = this.checkOnlySinceLastBuild();
        if (checkNewChangesFirst) {
            this.debug("getting changes since last build");
            modifications = modificationSet.retrieveModificationsAsElement(this.lastBuild, this.progress);
        } else {
            this.debug("getting changes since last successful build");
            modifications = modificationSet.retrieveModificationsAsElement(this.lastSuccessfulBuild, this.progress);
        }
        if (!modificationSet.isModified()) {
            this.info("No modifications found, build not necessary.");
            if (this.buildAfterFailed && !this.wasLastBuildSuccessful) {
                this.info("Building anyway, since buildAfterFailed is true and last build failed.");
            } else if (!this.requiremodification) {
                this.info("Building anyway, since modifications not required");
            } else if (buildWasForced) {
                this.info("Building anyway, since build was explicitly forced.");
            } else {
                return null;
            }
        }
        if (checkNewChangesFirst) {
            this.debug("new changes found; now getting complete set");
            modifications = modificationSet.retrieveModificationsAsElement(this.lastSuccessfulBuild, this.progress);
        }
        return modifications;
    }

    boolean checkOnlySinceLastBuild() {
        if (this.lastBuild == null || this.lastSuccessfulBuild == null) {
            return false;
        }
        long lastBuildLong = this.lastBuild.getTime();
        long timeDifference = lastBuildLong - this.lastSuccessfulBuild.getTime();
        boolean moreThanASecond = timeDifference > 1000L;
        return !this.buildAfterFailed && moreThanASecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeProject() {
        try {
            ObjectOutputStream s = new ObjectOutputStream(new FileOutputStream(this.name + ".ser"));
            try {
                s.writeObject(this);
                s.flush();
                this.debug("Serializing project to [" + this.name + ".ser]");
            }
            finally {
                s.close();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Error serializing project to [" + this.name + ".ser]: " + e.getMessage()), (Throwable)e);
        }
    }

    public void setLabelIncrementer(LabelIncrementer incrementer) throws CruiseControlException {
        if (incrementer == null) {
            throw new IllegalArgumentException("label incrementer can't be null");
        }
        this.labelIncrementer = incrementer;
        if (this.label == null) {
            this.label = this.labelIncrementer.getDefaultLabel();
        }
        this.validateLabel(this.label, this.labelIncrementer);
    }

    public LabelIncrementer getLabelIncrementer() {
        return this.labelIncrementer;
    }

    public void setName(String projectName) {
        this.name = projectName;
    }

    public String getName() {
        return this.name;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLastBuild(String newLastBuild) throws CruiseControlException {
        this.lastBuild = DateUtil.parseFormattedTime(newLastBuild, "lastBuild");
    }

    public void setLastSuccessfulBuild(String newLastSuccessfulBuild) throws CruiseControlException {
        this.lastSuccessfulBuild = DateUtil.parseFormattedTime(newLastSuccessfulBuild, "lastSuccessfulBuild");
    }

    public String getLastBuild() {
        if (this.lastBuild == null) {
            return null;
        }
        return DateUtil.getFormattedTime(this.lastBuild);
    }

    public boolean getBuildForced() {
        return this.buildForced;
    }

    public void setBuildForced(boolean forceNewBuildNow) {
        this.buildForced = forceNewBuildNow;
        if (forceNewBuildNow) {
            this.forceBuild();
        }
    }

    public String getLastSuccessfulBuild() {
        if (this.lastSuccessfulBuild == null) {
            return null;
        }
        return DateUtil.getFormattedTime(this.lastSuccessfulBuild);
    }

    public String getLogDir() {
        return this.projectConfig.getLog().getLogDir();
    }

    public long getBuildInterval() {
        if (this.overrideBuildInterval == null) {
            return this.projectConfig.getSchedule().getInterval();
        }
        return this.overrideBuildInterval;
    }

    public void overrideBuildInterval(long sleepMillis) {
        this.overrideBuildInterval = sleepMillis;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean paused) {
        Object object = this.pausedMutex;
        synchronized (object) {
            if (this.isPaused && !paused) {
                this.pausedMutex.notifyAll();
            }
            this.isPaused = paused;
        }
    }

    public void setBuildAfterFailed(boolean rebuildEvenWithNoNewModifications) {
        this.buildAfterFailed = rebuildEvenWithNoNewModifications;
    }

    public String getStatus() {
        return this.getState().getDescription();
    }

    public String getStatusWithQueuePosition() {
        if (ProjectState.QUEUED.equals(this.getState())) {
            return this.getState().getDescription() + " - " + this.queue.findPosition(this.projectConfig);
        }
        return this.getState().getDescription();
    }

    public ProjectState getState() {
        return this.state;
    }

    private void setState(ProjectState newState) {
        this.state = newState;
        this.info(this.getStatus());
        this.notifyListeners(new ProjectStateChangedEvent(this.name, this.getState()));
        this.fireProgressEvent(new BuildProgressEvent(this, this.getState()));
    }

    public void setBuildQueue(BuildQueue buildQueue) {
        this.queue = buildQueue;
    }

    public String getBuildStartTime() {
        return DateUtil.getFormattedTime(this.buildStartTime);
    }

    public Log getLog() {
        return this.projectConfig.getLog();
    }

    protected void init() {
        if (this.projectConfig == null) {
            throw new IllegalStateException("projectConfig must be set on project before calling init()");
        }
        this.buildAfterFailed = this.projectConfig.shouldBuildAfterFailed();
        this.forceOnly = this.projectConfig.isForceOnly();
        this.requiremodification = this.projectConfig.isRequiremodification();
        if (this.lastBuild == null) {
            this.lastBuild = DateUtil.getMidnight();
        }
        if (this.lastSuccessfulBuild == null) {
            this.lastSuccessfulBuild = this.lastBuild;
        }
        if (LOG.isDebugEnabled()) {
            this.debug("buildInterval          = [" + this.getBuildInterval() + "]");
            this.debug("buildForced            = [" + this.buildForced + "]");
            this.debug("buildAfterFailed       = [" + this.buildAfterFailed + "]");
            this.debug("requireModifcation     = [" + this.requiremodification + "]");
            this.debug("forceOnly              = [" + this.forceOnly + "]");
            this.debug("buildCounter           = [" + this.buildCounter + "]");
            this.debug("isPaused               = [" + this.isPaused + "]");
            this.debug("label                  = [" + this.label + "]");
            this.debug("lastBuild              = [" + DateUtil.getFormattedTime(this.lastBuild) + "]");
            this.debug("lastSuccessfulBuild    = [" + DateUtil.getFormattedTime(this.lastSuccessfulBuild) + "]");
            this.debug("logDir                 = [" + this.projectConfig.getLog().getLogDir() + "]");
            this.debug("logXmlEncoding         = [" + this.projectConfig.getLog().getLogXmlEncoding() + "]");
            this.debug("wasLastBuildSuccessful = [" + this.wasLastBuildSuccessful + "]");
        }
    }

    protected Element getProjectPropertiesElement(Date now) {
        Element infoElement = new Element("info");
        this.addProperty(infoElement, "projectname", this.name);
        String lastBuildString = DateUtil.getFormattedTime(this.lastBuild == null ? now : this.lastBuild);
        this.addProperty(infoElement, "lastbuild", lastBuildString);
        String lastSuccessfulBuildString = DateUtil.getFormattedTime(this.lastSuccessfulBuild == null ? now : this.lastSuccessfulBuild);
        this.addProperty(infoElement, "lastsuccessfulbuild", lastSuccessfulBuildString);
        this.addProperty(infoElement, "builddate", DateUtil.formatIso8601(now));
        this.addProperty(infoElement, "cctimestamp", DateUtil.getFormattedTime(now));
        this.addProperty(infoElement, "label", this.label);
        this.addProperty(infoElement, "interval", Long.toString(this.getBuildInterval() / 1000L));
        this.addProperty(infoElement, "lastbuildsuccessful", String.valueOf(this.wasLastBuildSuccessful));
        return infoElement;
    }

    private void addProperty(Element parent, String key, String value) {
        Element propertyElement = new Element("property");
        propertyElement.setAttribute("name", key);
        propertyElement.setAttribute("value", value);
        parent.addContent((Content)propertyElement);
    }

    protected Map<String, String> getProjectPropertiesMap(Date now) {
        HashMap<String, String> buildProperties = new HashMap<String, String>();
        buildProperties.put("projectname", this.name);
        buildProperties.put("label", this.label);
        buildProperties.put("cvstimestamp", CVSDateUtil.formatCVSDate(now));
        buildProperties.put("cctimestamp", DateUtil.getFormattedTime(now));
        buildProperties.put("cclastgoodbuildtimestamp", this.getLastSuccessfulBuild());
        buildProperties.put("cclastbuildtimestamp", this.getLastBuild());
        buildProperties.put("lastbuildsuccessful", String.valueOf(this.isLastBuildSuccessful()));
        buildProperties.put("buildforced", String.valueOf(this.getBuildForced()));
        if (this.projectConfig.getModificationSet() != null) {
            buildProperties.putAll(this.projectConfig.getModificationSet().getProperties());
        }
        return buildProperties;
    }

    protected void publish(Log buildLog) throws CruiseControlException {
        this.setState(ProjectState.PUBLISHING);
        for (Publisher publisher : this.projectConfig.getPublishers()) {
            try {
                publisher.publish(buildLog.getContent());
            }
            catch (Throwable t) {
                StringBuilder message = new StringBuilder("exception publishing results");
                message.append(" with ").append(publisher.getClass().getName());
                message.append(" for project ").append(this.name);
                LOG.error((Object)message.toString(), t);
            }
        }
    }

    protected void bootstrap() throws CruiseControlException {
        this.setState(ProjectState.BOOTSTRAPPING);
        for (Bootstrapper bootstrapper : this.projectConfig.getBootstrappers()) {
            bootstrapper.bootstrap();
        }
    }

    protected void validateLabel(String oldLabel, LabelIncrementer incrementer) throws CruiseControlException {
        if (!incrementer.isValidLabel(oldLabel)) {
            String message = oldLabel + " is not a valid label for labelIncrementer " + incrementer.getClass().getName();
            this.debug(message);
            throw new CruiseControlException(message);
        }
    }

    public boolean isLastBuildSuccessful() {
        return this.wasLastBuildSuccessful;
    }

    void setWasLastBuildSuccessful(boolean buildSuccessful) {
        this.wasLastBuildSuccessful = buildSuccessful;
    }

    private void info(String message) {
        LOG.info((Object)("Project " + this.name + ":  " + message));
    }

    private void debug(String message) {
        LOG.debug((Object)("Project " + this.name + ":  " + message));
    }

    public void start() {
        if (this.stopped || this.getState() == ProjectState.STOPPED) {
            this.stopped = false;
            LOG.info((Object)("Project " + this.name + " starting"));
            this.setState(ProjectState.IDLE);
            this.createNewSchedulingThread();
        }
    }

    protected void createNewSchedulingThread() {
        Thread projectSchedulingThread = new Thread((Runnable)this, "Project " + this.getName() + " thread");
        projectSchedulingThread.start();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)"interrupted while waiting for scheduling thread to start", (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOG.info((Object)("Project " + this.name + " stopping"));
        this.stopped = true;
        this.setState(ProjectState.STOPPED);
        Object object = this.pausedMutex;
        synchronized (object) {
            this.pausedMutex.notifyAll();
        }
        object = this.waitMutex;
        synchronized (object) {
            this.waitMutex.notifyAll();
        }
        object = this.scheduleMutex;
        synchronized (object) {
            this.scheduleMutex.notifyAll();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Project ");
        sb.append(this.getName());
        sb.append(": ");
        sb.append(this.getStatus());
        if (this.isPaused) {
            sb.append(" (paused)");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuildProgressListener(BuildProgressListener listener) {
        List<BuildProgressListener> list = this.progressListeners;
        synchronized (list) {
            this.progressListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProgressEvent(BuildProgressEvent event) {
        List<BuildProgressListener> list = this.progressListeners;
        synchronized (list) {
            for (BuildProgressListener listener : this.progressListeners) {
                listener.handleBuildProgress(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuildResultListener(BuildResultListener listener) {
        List<BuildResultListener> list = this.resultListeners;
        synchronized (list) {
            this.resultListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireResultEvent(BuildResultEvent event) {
        List<BuildResultListener> list = this.resultListeners;
        synchronized (list) {
            for (BuildResultListener listener : this.resultListeners) {
                listener.handleBuildResult(event);
            }
        }
    }

    List<Listener> getListeners() {
        return this.projectConfig.getListeners();
    }

    public void setProjectConfig(ProjectConfig projectConfig) throws CruiseControlException {
        if (projectConfig == null) {
            throw new IllegalArgumentException("project config can't be null");
        }
        this.projectConfig = projectConfig;
        this.setLabelIncrementer(projectConfig.getLabelIncrementer());
    }

    void notifyListeners(ProjectEvent event) {
        if (this.projectConfig == null) {
            throw new IllegalStateException("projectConfig is null");
        }
        for (Listener listener : this.projectConfig.getListeners()) {
            try {
                listener.handleEvent(event);
            }
            catch (CruiseControlException e) {
                StringBuilder message = new StringBuilder("exception notifying listener ");
                message.append(listener.getClass().getName());
                message.append(" for project ").append(this.name);
                LOG.error((Object)message.toString(), (Throwable)e);
            }
        }
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass().getName().equals(this.getClass().getName())) {
            Project thatProject = (Project)arg0;
            return thatProject.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void register(MBeanServer server) throws JMException {
        LOG.debug((Object)"Registering project mbean");
        ProjectController projectController = new ProjectController(this);
        projectController.register(server);
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public Date getLastBuildDate() {
        return this.lastBuild;
    }

    public Progress getProgress() {
        return this.progress;
    }
}

