/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.Builder;
import net.sourceforge.cruisecontrol.CruiseControlConfig;
import net.sourceforge.cruisecontrol.LabelIncrementer;
import net.sourceforge.cruisecontrol.Listener;
import net.sourceforge.cruisecontrol.Log;
import net.sourceforge.cruisecontrol.Manipulator;
import net.sourceforge.cruisecontrol.ModificationSet;
import net.sourceforge.cruisecontrol.PauseBuilder;
import net.sourceforge.cruisecontrol.ProjectConfig;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.Schedule;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.buildloggers.MergeLogger;
import net.sourceforge.cruisecontrol.config.ConfigurationPlugin;
import net.sourceforge.cruisecontrol.config.DashboardConfigurationPlugin;
import net.sourceforge.cruisecontrol.config.DefaultPropertiesPlugin;
import net.sourceforge.cruisecontrol.config.IncludeProjectsPlugin;
import net.sourceforge.cruisecontrol.config.PluginPlugin;
import net.sourceforge.cruisecontrol.config.SystemPlugin;
import net.sourceforge.cruisecontrol.config.ThreadsPlugin;
import net.sourceforge.cruisecontrol.publishers.email.EmailMapper;
import net.sourceforge.cruisecontrol.publishers.email.EmailMapping;

public final class PluginType
implements Serializable {
    public static final PluginType BOOTSTRAPPER = new PluginType("bootstrapper", "bootstrappers");
    public static final PluginType BOOTSTRAPPERS = new PluginType("bootstrappers", "project");
    public static final PluginType BUILDER = new PluginType("builder", "schedule");
    public static final PluginType CONFIGURATION = new PluginType("configuration", "system");
    public static final PluginType CRUISECONTROL = new PluginType("cruisecontrol", "");
    public static final PluginType DATE_FORMAT = new PluginType("dateformat", "project");
    public static final PluginType INCLUDE_PROJECTS = new PluginType("include.projects", "cruisecontrol");
    public static final PluginType DASHBOARD_CONFIGURATION = new PluginType("dashboard", "cruisecontrol");
    public static final PluginType LABEL_INCREMENTER = new PluginType("labelincrementer", "project");
    public static final PluginType LISTENER = new PluginType("listener", "listeners");
    public static final PluginType LISTENERS = new PluginType("listeners", "project");
    public static final PluginType LOG = new PluginType("log", "project");
    public static final PluginType MAP = new PluginType("map", "email");
    public static final PluginType MERGE_LOGGER = new PluginType("logger", "log");
    public static final PluginType MANIPULATORS = new PluginType("manipulators", "log");
    public static final PluginType MODIFICATION_SET = new PluginType("modificationset", "project");
    public static final PluginType PROJECT = new PluginType("project", "cruisecontrol");
    public static final PluginType PLUGIN = new PluginType("plugin", "cruisecontrol");
    public static final PluginType EMAIL_MAPPER = new PluginType("propertiesmapper", "email");
    public static final PluginType PAUSE = new PluginType("pause", "schedule");
    public static final PluginType PROPERTIES = new PluginType("property", "cruisecontrol");
    public static final PluginType PUBLISHER = new PluginType("publisher", "publishers");
    public static final PluginType PUBLISHERS = new PluginType("publishers", "project");
    public static final PluginType SCHEDULE = new PluginType("schedule", "project");
    public static final PluginType SOURCE_CONTROL = new PluginType("sourcecontrol", "modificationset");
    public static final PluginType SYSTEM = new PluginType("system", "cruisecontrol");
    public static final PluginType THREADS = new PluginType("threads", "configuration");
    private static final Map PLUGIN_TYPES = new HashMap(){
        {
            this.put(Bootstrapper.class, BOOTSTRAPPER);
            this.put(ProjectConfig.Bootstrappers.class, BOOTSTRAPPERS);
            this.put(Builder.class, BUILDER);
            this.put(ConfigurationPlugin.class, CONFIGURATION);
            this.put(CruiseControlConfig.class, CRUISECONTROL);
            this.put(LabelIncrementer.class, LABEL_INCREMENTER);
            this.put(IncludeProjectsPlugin.class, INCLUDE_PROJECTS);
            this.put(Listener.class, LISTENER);
            this.put(ProjectConfig.Listeners.class, LISTENERS);
            this.put(Log.class, LOG);
            this.put(EmailMapping.class, MAP);
            this.put(MergeLogger.class, MERGE_LOGGER);
            this.put(Manipulator.class, MANIPULATORS);
            this.put(ModificationSet.class, MODIFICATION_SET);
            this.put(ProjectConfig.class, PROJECT);
            this.put(PluginPlugin.class, PLUGIN);
            this.put(EmailMapper.class, EMAIL_MAPPER);
            this.put(ProjectConfig.Publishers.class, PUBLISHERS);
            this.put(PauseBuilder.class, PAUSE);
            this.put(DefaultPropertiesPlugin.class, PROPERTIES);
            this.put(Publisher.class, PUBLISHER);
            this.put(Schedule.class, SCHEDULE);
            this.put(SourceControl.class, SOURCE_CONTROL);
            this.put(SystemPlugin.class, SYSTEM);
            this.put(ThreadsPlugin.class, THREADS);
            this.put(DashboardConfigurationPlugin.class, DASHBOARD_CONFIGURATION);
        }
    };
    private final String name;
    private final String parentElementName;

    private PluginType(String type, String parentElementName) {
        this.name = type;
        this.parentElementName = parentElementName;
    }

    public static PluginType find(Class pluginClass) {
        if (pluginClass != null) {
            for (Map.Entry element : PLUGIN_TYPES.entrySet()) {
                if (!((Class)element.getKey()).isAssignableFrom(pluginClass)) continue;
                return (PluginType)element.getValue();
            }
        }
        throw new IllegalArgumentException(pluginClass + " is not a CruiseControl plugin.");
    }

    public static PluginType[] getTypes() {
        HashSet uniqueValues = new HashSet(PLUGIN_TYPES.values());
        return uniqueValues.toArray(new PluginType[uniqueValues.size()]);
    }

    public static PluginType find(String name) {
        if (name != null) {
            for (Map.Entry element : PLUGIN_TYPES.entrySet()) {
                PluginType nextType = (PluginType)element.getValue();
                if (!nextType.getName().equals(name)) continue;
                return nextType;
            }
        }
        throw new IllegalArgumentException(name + " is not a CruiseControl plugin.");
    }

    public String getName() {
        return this.name;
    }

    public String getParentElementName() {
        return this.parentElementName;
    }

    public String toString() {
        return this.getName();
    }

    private Object readResolve() {
        return PluginType.find(this.name);
    }
}

