/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.GenericPluginDetail;
import net.sourceforge.cruisecontrol.PluginDetail;
import net.sourceforge.cruisecontrol.PluginType;
import net.sourceforge.cruisecontrol.ProjectXMLHelper;
import net.sourceforge.cruisecontrol.config.PluginPlugin;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public final class PluginRegistry
implements Serializable {
    private static final Logger LOG = Logger.getLogger(PluginRegistry.class);
    private static final PluginRegistry ROOTREGISTRY = PluginRegistry.loadDefaultPluginRegistry();
    private final PluginRegistry parentRegistry;
    private final Map<String, String> plugins = new HashMap<String, String>();
    private final Map<String, Element> pluginConfigs = new HashMap<String, Element>();

    public static PluginRegistry createRegistry() {
        return PluginRegistry.createRegistry(ROOTREGISTRY);
    }

    public static PluginRegistry createRegistry(PluginRegistry parent) {
        return new PluginRegistry(parent);
    }

    private PluginRegistry(PluginRegistry parentRegistry) {
        this.parentRegistry = parentRegistry;
    }

    public void register(String pluginName, String pluginClassname) {
        this.plugins.put(pluginName.toLowerCase(), pluginClassname);
    }

    public void register(PluginPlugin plugin) throws CruiseControlException {
        String pluginName = plugin.getName();
        String pluginClassName = plugin.getClassname();
        Element transformedElement = plugin.getTransformedElement();
        if (pluginClassName != null) {
            this.register(pluginName, pluginClassName);
        } else if (!this.isPluginRegistered(pluginName)) {
            throw new CruiseControlException("Unknown plugin '" + pluginName + "'; maybe you forgot to specify a classname?");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("storing plugin configuration " + pluginName));
        }
        this.pluginConfigs.put(pluginName, transformedElement);
    }

    public void register(Element pluginElement) throws CruiseControlException {
        PluginPlugin plugin = (PluginPlugin)new ProjectXMLHelper().configurePlugin(pluginElement, false);
        this.register(plugin);
    }

    static void registerToRoot(Element pluginElement) throws CruiseControlException {
        ROOTREGISTRY.register(pluginElement);
    }

    static void resetRootRegistry() {
        PluginRegistry.ROOTREGISTRY.pluginConfigs.clear();
        PluginRegistry.ROOTREGISTRY.plugins.clear();
        PluginRegistry.ROOTREGISTRY.plugins.putAll(PluginRegistry.loadDefaultPluginRegistry().plugins);
    }

    public String getPluginClassname(String pluginName) {
        String className = this.internalGetPluginClassname(pluginName = pluginName.toLowerCase());
        if (className == null && this.parentRegistry != null) {
            className = this.parentRegistry.getPluginClassname(pluginName);
        }
        return className;
    }

    private String internalGetPluginClassname(String pluginName) {
        return this.plugins.get(pluginName);
    }

    public Class getPluginClass(String pluginName) throws CruiseControlException {
        if (!this.isPluginRegistered(pluginName)) {
            return null;
        }
        String pluginClassname = this.getPluginClassname(pluginName);
        return this.instanciatePluginClass(pluginClassname, pluginName);
    }

    public Class instanciatePluginClass(String pluginClassname, String pluginName) throws CruiseControlException {
        try {
            return Class.forName(pluginClassname);
        }
        catch (ClassNotFoundException e) {
            String msg = "Attemping to load plugin named [" + pluginName + "], but couldn't load corresponding class [" + pluginClassname + "].";
            throw new CruiseControlException(msg);
        }
    }

    public String getPluginName(Class pluginClass) {
        String pluginName = null;
        if (this.parentRegistry != null) {
            pluginName = this.parentRegistry.getPluginName(pluginClass);
        }
        if (pluginName == null) {
            for (Map.Entry<String, String> entry : this.plugins.entrySet()) {
                String value = entry.getValue();
                if (!value.equals(pluginClass.getName())) continue;
                pluginName = entry.getKey();
                break;
            }
        }
        return pluginName;
    }

    public PluginDetail[] getPluginDetails() throws CruiseControlException {
        LinkedList<PluginDetail> availablePlugins = new LinkedList<PluginDetail>();
        if (this.parentRegistry != null) {
            availablePlugins.addAll(Arrays.asList(this.parentRegistry.getPluginDetails()));
        }
        for (String pluginName : this.plugins.keySet()) {
            try {
                Class pluginClass = this.getPluginClass(pluginName);
                availablePlugins.add(new GenericPluginDetail(pluginName, pluginClass));
            }
            catch (CruiseControlException e) {
                String message = e.getMessage();
                if (message.indexOf("starteam") != -1 || message.indexOf("harvest") != -1) continue;
                throw e;
            }
        }
        return availablePlugins.toArray(new PluginDetail[availablePlugins.size()]);
    }

    public PluginType[] getPluginTypes() {
        return PluginType.getTypes();
    }

    public boolean isPluginRegistered(String pluginName) {
        boolean isRegistered = this.plugins.containsKey(pluginName.toLowerCase());
        if (!isRegistered && this.parentRegistry != null) {
            isRegistered = this.parentRegistry.isPluginRegistered(pluginName);
        }
        return isRegistered;
    }

    static PluginRegistry loadDefaultPluginRegistry() {
        PluginRegistry rootRegistry = new PluginRegistry(null);
        Properties pluginDefinitions = new Properties();
        try {
            pluginDefinitions.load(PluginRegistry.class.getResourceAsStream("default-plugins.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load plugin-definitions from default-plugins.properties: " + e);
        }
        for (Map.Entry<Object, Object> entry : pluginDefinitions.entrySet()) {
            rootRegistry.register((String)entry.getKey(), (String)entry.getValue());
        }
        return rootRegistry;
    }

    public Element getPluginConfig(String pluginName) {
        pluginName = pluginName.toLowerCase();
        String className = this.getPluginClassname(pluginName);
        return this.overridePluginConfig(pluginName, className, null);
    }

    private Element overridePluginConfig(String pluginName, String pluginClass, Element pluginConfig) {
        Element pluginElement = this.pluginConfigs.get(pluginName);
        if (pluginElement != null && pluginConfig == null) {
            pluginElement = (Element)pluginElement.clone();
        }
        if (pluginConfig == null) {
            pluginConfig = pluginElement;
        } else if (pluginElement != null && pluginClass.equals(this.internalGetPluginClassname(pluginName))) {
            List attributes = pluginElement.getAttributes();
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute attribute = (Attribute)attributes.get(i);
                String name = attribute.getName();
                if (pluginConfig.getAttribute(name) != null) continue;
                pluginConfig.setAttribute(name, attribute.getValue());
            }
            List children = pluginElement.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Element child = (Element)children.get(i);
                pluginConfig.addContent((Content)((Element)child.clone()));
            }
        }
        if (this.parentRegistry != null) {
            pluginConfig = this.parentRegistry.overridePluginConfig(pluginName, pluginClass, pluginConfig);
        }
        return pluginConfig;
    }
}

