/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.util.Calendar;
import java.util.Date;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.PerDayScheduleItem;
import net.sourceforge.cruisecontrol.util.ValidationHelper;

public class PauseBuilder
extends PerDayScheduleItem {
    private static final long serialVersionUID = 866530246895228766L;
    private int startTime = -1;
    private int endTime = -1;

    public void validate() throws CruiseControlException {
        ValidationHelper.assertFalse(this.startTime < 0, "'starttime' is a required attribute on PauseBuilder");
        ValidationHelper.assertFalse(this.endTime < 0, "'endtime' is a required attribute on PauseBuilder");
        ValidationHelper.assertFalse(this.getDay() == -2, "setDay attribute on PauseBuilder requires english name for day of week (case insensitive)");
    }

    public void setStartTime(int time) {
        this.startTime = time;
    }

    public void setEndTime(int time) {
        this.endTime = time;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public boolean isPaused(Date date) {
        boolean isValidDay;
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        int currentDay = now.get(7);
        int currentTime = DateUtil.getTimeFromDate(date);
        int builderDay = this.getDay();
        boolean bl = isValidDay = builderDay < 0 || builderDay == currentDay;
        if (this.startTime < this.endTime) {
            return this.startTime <= currentTime && currentTime <= this.endTime && isValidDay;
        }
        return this.startTime <= currentTime && (builderDay < 0 || builderDay == currentDay) || currentTime <= this.endTime && (builderDay < 0 || builderDay == currentDay - 1);
    }
}

