/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import net.sourceforge.cruisecontrol.Attribute;
import net.sourceforge.cruisecontrol.PluginDetail;
import net.sourceforge.cruisecontrol.PluginType;

public class GenericPluginDetail
implements PluginDetail {
    private final String name;
    private final PluginType type;
    private final Attribute[] requiredAttributes;

    public GenericPluginDetail(String name, Class plugin) {
        this.name = name;
        this.requiredAttributes = GenericPluginDetail.lookupRequiredAttributes(plugin);
        this.type = PluginType.find(plugin);
    }

    public String getName() {
        return this.name;
    }

    public PluginType getType() {
        return this.type;
    }

    public Attribute[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public int compareTo(Object other) {
        return this.getName().compareTo(((PluginDetail)other).getName());
    }

    public String toString() {
        return this.type + ":" + this.name;
    }

    private static Attribute[] lookupRequiredAttributes(Class plugin) {
        Method[] methods;
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (Method method : methods = plugin.getMethods()) {
            if (!GenericPluginDetail.isRequiredAttribute(method)) continue;
            String methodName = method.getName();
            String attributeName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            attrs.add(new Attribute(attributeName, method.getParameterTypes()[0]));
        }
        return attrs.toArray(new Attribute[attrs.size()]);
    }

    private static boolean isRequiredAttribute(Method method) {
        return method.getName().startsWith("set") && Modifier.isPublic(method.getModifiers());
    }
}

