/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.cruisecontrol.CruiseControlController;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.PluginRegistry;
import net.sourceforge.cruisecontrol.ProjectInterface;
import net.sourceforge.cruisecontrol.ProjectXMLHelper;
import net.sourceforge.cruisecontrol.config.DashboardConfigurationPlugin;
import net.sourceforge.cruisecontrol.config.IncludeProjectsPlugin;
import net.sourceforge.cruisecontrol.config.PluginPlugin;
import net.sourceforge.cruisecontrol.config.PropertiesPlugin;
import net.sourceforge.cruisecontrol.config.SystemPlugin;
import net.sourceforge.cruisecontrol.config.XmlResolver;
import net.sourceforge.cruisecontrol.util.Util;
import org.apache.log4j.Logger;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CruiseControlConfig {
    private static final Logger LOG = Logger.getLogger(CruiseControlConfig.class);
    public static final String LABEL_INCREMENTER = "labelincrementer";
    public static final boolean FAIL_UPON_MISSING_PROPERTY = false;
    private static final Set<String> KNOWN_ROOT_CHILD_NAMES = new HashSet<String>();
    private Map<String, String> rootProperties = new HashMap<String, String>();
    private Map<String, List> templatePluginProperties = new HashMap<String, List>();
    private PluginRegistry rootPlugins = PluginRegistry.createRegistry();
    private final Map<String, ProjectInterface> projects = new LinkedHashMap<String, ProjectInterface>();
    private final Map<String, PluginRegistry> projectPluginRegistries = new TreeMap<String, PluginRegistry>();
    private final XmlResolver xmlResolver;
    private SystemPlugin system;
    private final CruiseControlController controller;
    private final Set<String> customPropertiesPlugins = new HashSet<String>();

    public int getMaxNbThreads() {
        if (this.system != null && this.system.getConfig() != null && this.system.getConfig().getThreads() != null) {
            return this.system.getConfig().getThreads().getCount();
        }
        return 1;
    }

    public CruiseControlConfig(Element ccElement) throws CruiseControlException {
        this(ccElement, null, null);
    }

    public CruiseControlConfig(Element ccElement, CruiseControlController controller) throws CruiseControlException {
        this(ccElement, null, controller);
    }

    public CruiseControlConfig(Element ccElement, XmlResolver xmlResolver) throws CruiseControlException {
        this(ccElement, xmlResolver, null);
    }

    public CruiseControlConfig(Element ccElement, XmlResolver xmlResolver, CruiseControlController controller) throws CruiseControlException {
        this.xmlResolver = xmlResolver;
        this.controller = controller;
        this.parse(ccElement);
    }

    private void parse(Element ccElement) throws CruiseControlException {
        String nodeName;
        Iterator i = ccElement.getChildren("property").iterator();
        while (i.hasNext()) {
            this.handleRootProperty((Element)i.next());
        }
        i = ccElement.getChildren("plugin").iterator();
        while (i.hasNext()) {
            this.handleRootPlugin((Element)i.next());
        }
        for (Element childElement : ccElement.getChildren()) {
            nodeName = childElement.getName();
            if (KNOWN_ROOT_CHILD_NAMES.contains(nodeName) || "system".equals(nodeName) || this.isProject(nodeName) || !this.isCustomPropertiesPlugin(nodeName)) continue;
            this.handleCustomRootProperty(childElement);
        }
        i = ccElement.getChildren("include.projects").iterator();
        while (i.hasNext()) {
            this.handleIncludedProjects((Element)i.next());
        }
        i = ccElement.getChildren("dashboard").iterator();
        while (i.hasNext()) {
            this.handleDashboard((Element)i.next());
        }
        for (Element childElement : ccElement.getChildren()) {
            nodeName = childElement.getName();
            if (this.isProject(nodeName)) {
                this.handleProject(childElement);
                continue;
            }
            if ("system".equals(nodeName)) {
                this.add((SystemPlugin)new ProjectXMLHelper().configurePlugin(childElement, false));
                continue;
            }
            if (KNOWN_ROOT_CHILD_NAMES.contains(nodeName) || this.customPropertiesPlugins.contains(nodeName)) continue;
            throw new CruiseControlException("cannot handle child of <" + nodeName + ">");
        }
    }

    private CruiseControlConfig(Element includedElement, CruiseControlConfig parent) throws CruiseControlException {
        this.controller = parent.controller;
        this.xmlResolver = parent.xmlResolver;
        this.rootPlugins = PluginRegistry.createRegistry(parent.rootPlugins);
        this.rootProperties = new HashMap<String, String>(parent.rootProperties);
        this.templatePluginProperties = new HashMap<String, List>(parent.templatePluginProperties);
        this.parse(includedElement);
    }

    private void handleIncludedProjects(Element includeElement) {
        String path = includeElement.getAttributeValue("file");
        if (path == null) {
            LOG.warn((Object)"include.projects element missing file attribute. Skipping.");
        }
        if (this.xmlResolver == null) {
            LOG.debug((Object)"xmlResolver not available; skipping include.projects element. ok if validating config.");
            return;
        }
        try {
            IncludeProjectsPlugin includeProjects = (IncludeProjectsPlugin)new ProjectXMLHelper(this.rootProperties, this.getRootPlugins()).configurePlugin(includeElement, false);
            this.add(includeProjects);
        }
        catch (CruiseControlException e) {
            LOG.error((Object)("Exception including file " + path), (Throwable)e);
        }
    }

    private void handleDashboard(Element dashboardElement) throws CruiseControlException {
        DashboardConfigurationPlugin dashboard = (DashboardConfigurationPlugin)new ProjectXMLHelper(this.rootProperties, this.getRootPlugins()).configurePlugin(dashboardElement, false);
        dashboard.setController(this.controller);
        dashboard.validate();
        dashboard.startPostingToDashboard();
    }

    private boolean isCustomPropertiesPlugin(String nodeName) throws CruiseControlException {
        boolean isPropetiesPlugin;
        if (this.customPropertiesPlugins.contains(nodeName)) {
            return true;
        }
        boolean bl = isPropetiesPlugin = this.rootPlugins.isPluginRegistered(nodeName) && PropertiesPlugin.class.isAssignableFrom(this.rootPlugins.getPluginClass(nodeName));
        if (isPropetiesPlugin) {
            this.customPropertiesPlugins.add(nodeName);
        }
        return isPropetiesPlugin;
    }

    private boolean isProject(String nodeName) throws CruiseControlException {
        return this.rootPlugins.isPluginRegistered(nodeName) && ProjectInterface.class.isAssignableFrom(this.rootPlugins.getPluginClass(nodeName));
    }

    private boolean isProjectTemplate(Element pluginElement) {
        String pluginName = pluginElement.getAttributeValue("name");
        String pluginClassName = pluginElement.getAttributeValue("classname");
        if (pluginClassName == null) {
            pluginClassName = this.rootPlugins.getPluginClassname(pluginName);
        }
        try {
            Class pluginClass = this.rootPlugins.instanciatePluginClass(pluginClassName, pluginName);
            return ProjectInterface.class.isAssignableFrom(pluginClass);
        }
        catch (CruiseControlException e) {
            LOG.warn((Object)("Couldn't check if the plugin " + pluginName + " is an instance of ProjectInterface"), (Throwable)e);
            return false;
        }
    }

    private void handleRootPlugin(Element pluginElement) throws CruiseControlException {
        String pluginName = pluginElement.getAttributeValue("name");
        if (pluginName == null) {
            LOG.warn((Object)"Config contains plugin without a name-attribute, ignoring it");
            return;
        }
        if (this.isProjectTemplate(pluginElement)) {
            this.handleNodeProperties(pluginElement, pluginName);
        }
        this.rootPlugins.register(pluginElement);
    }

    private void handleNodeProperties(Element pluginElement, String pluginName) {
        ArrayList properties = new ArrayList();
        Iterator i = pluginElement.getChildren("property").iterator();
        while (i.hasNext()) {
            properties.add(i.next());
        }
        if (properties.size() > 0) {
            this.templatePluginProperties.put(pluginName, properties);
        }
        pluginElement.removeChildren("property");
    }

    private void handleRootProperty(Element childElement) throws CruiseControlException {
        ProjectXMLHelper.registerProperty(this.rootProperties, childElement, false);
    }

    private void handleCustomRootProperty(Element childElement) throws CruiseControlException {
        ProjectXMLHelper.registerCustomProperty(this.rootProperties, childElement, false, PluginRegistry.createRegistry(this.rootPlugins));
    }

    public void add(IncludeProjectsPlugin project) throws CruiseControlException {
        String file = project.getFile();
        String path = Util.parsePropertiesInString(this.rootProperties, file, false);
        LOG.debug((Object)("getting included projects from " + path));
        Element includedElement = this.xmlResolver.getElement(path);
        CruiseControlConfig includedConfig = new CruiseControlConfig(includedElement, this);
        Set<String> includedProjectNames = includedConfig.getProjectNames();
        for (String name : includedProjectNames) {
            if (this.projects.containsKey(name)) {
                String message = "Project " + name + " included from " + path + " is a duplicate name. Omitting.";
                LOG.error((Object)message);
            }
            this.projects.put(name, includedConfig.getProject(name));
        }
    }

    public void add(SystemPlugin system) {
        this.system = system;
    }

    public void add(PluginPlugin plugin) {
    }

    public void add(ProjectInterface project) {
    }

    private void handleProject(Element projectElement) throws CruiseControlException {
        ProjectInterface project;
        String projectName = this.getProjectName(projectElement);
        if (this.projects.containsKey(projectName)) {
            String duplicateEntriesMessage = "Duplicate entries in config file for project name " + projectName;
            throw new CruiseControlException(duplicateEntriesMessage);
        }
        MapWithParent nonFullyResolvedProjectProperties = new MapWithParent(this.rootProperties);
        LOG.debug((Object)("Setting property \"project.name\" to \"" + projectName + "\"."));
        nonFullyResolvedProjectProperties.put("project.name", projectName);
        List projectTemplateProperties = this.templatePluginProperties.get(projectElement.getName());
        if (projectTemplateProperties != null) {
            for (int i = 0; i < projectTemplateProperties.size(); ++i) {
                Element element = (Element)projectTemplateProperties.get(i);
                ProjectXMLHelper.registerProperty(nonFullyResolvedProjectProperties, element, false);
            }
        }
        for (Element propertyElement : projectElement.getChildren("property")) {
            ProjectXMLHelper.registerProperty(nonFullyResolvedProjectProperties, propertyElement, false);
        }
        Map thisProperties = nonFullyResolvedProjectProperties.thisMap;
        for (String key : this.rootProperties.keySet()) {
            if (thisProperties.containsKey(key)) continue;
            String value = this.rootProperties.get(key);
            thisProperties.put(key, Util.parsePropertiesInString(thisProperties, value, false));
        }
        ProjectXMLHelper.parsePropertiesInElement(projectElement, thisProperties, false);
        PluginRegistry projectPlugins = PluginRegistry.createRegistry(this.rootPlugins);
        for (Element element : projectElement.getChildren("plugin")) {
            new ProjectXMLHelper().configurePlugin(element, false);
            projectPlugins.register(element);
        }
        projectElement.removeChildren("property");
        projectElement.removeChildren("plugin");
        LOG.debug((Object)("**************** configuring project " + projectName + " *******************"));
        ProjectXMLHelper projectHelper = new ProjectXMLHelper(thisProperties, projectPlugins, this.controller);
        try {
            project = (ProjectInterface)projectHelper.configurePlugin(projectElement, false);
        }
        catch (CruiseControlException e) {
            throw new CruiseControlException("error configuring project " + projectName, e);
        }
        this.add(project);
        project.validate();
        LOG.debug((Object)("**************** end configuring project " + projectName + " *******************"));
        this.projects.put(projectName, project);
        this.projectPluginRegistries.put(projectName, projectPlugins);
    }

    private String getProjectName(Element childElement) throws CruiseControlException {
        if (!this.isProject(childElement.getName())) {
            throw new IllegalStateException("Invalid Node <" + childElement.getName() + "> (not a project)");
        }
        String rawName = childElement.getAttribute("name").getValue();
        return Util.parsePropertiesInString(this.rootProperties, rawName, false);
    }

    public ProjectInterface getProject(String name) {
        return this.projects.get(name);
    }

    public Set<String> getProjectNames() {
        return Collections.unmodifiableSet(this.projects.keySet());
    }

    PluginRegistry getRootPlugins() {
        return this.rootPlugins;
    }

    PluginRegistry getProjectPlugins(String name) {
        return this.projectPluginRegistries.get(name);
    }

    static {
        KNOWN_ROOT_CHILD_NAMES.add("include.projects");
        KNOWN_ROOT_CHILD_NAMES.add("property");
        KNOWN_ROOT_CHILD_NAMES.add("plugin");
        KNOWN_ROOT_CHILD_NAMES.add("system");
        KNOWN_ROOT_CHILD_NAMES.add("dashboard");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapWithParent
    implements Map<String, String> {
        private final Map<String, String> parent;
        private final Map<String, String> thisMap;

        MapWithParent(Map<String, String> parent) {
            this.parent = parent;
            this.thisMap = new HashMap<String, String>();
        }

        @Override
        public int size() {
            int size = this.thisMap.size();
            if (this.parent != null) {
                Set<String> keys = this.parent.keySet();
                for (String key : keys) {
                    if (this.thisMap.containsKey(key)) continue;
                    ++size;
                }
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            boolean parentIsEmpty = this.parent == null || this.parent.isEmpty();
            return parentIsEmpty && this.thisMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.thisMap.containsKey(key) || this.parent != null && this.parent.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.thisMap.containsValue(value) || this.parent != null && this.parent.containsValue(value);
        }

        @Override
        public String get(Object key) {
            String value = this.thisMap.get(key);
            if (value == null && this.parent != null) {
                value = this.parent.get(key);
            }
            return value;
        }

        @Override
        public String put(String o, String o1) {
            return this.thisMap.put(o, o1);
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException("'remove' not supported on MapWithParent");
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map) {
            this.thisMap.putAll(map);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("'clear' not supported on MapWithParent");
        }

        @Override
        public Set<String> keySet() {
            HashSet<String> keys = new HashSet<String>(this.thisMap.keySet());
            if (this.parent != null) {
                keys.addAll(this.parent.keySet());
            }
            return keys;
        }

        @Override
        public Collection<String> values() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>(this.thisMap.entrySet());
            if (this.parent != null) {
                entries.addAll(this.parent.entrySet());
            }
            return entries;
        }
    }
}

