/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.util.Date;
import java.util.List;
import net.sourceforge.cruisecontrol.BuildLoopInformation;
import net.sourceforge.cruisecontrol.CruiseControlController;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.ProjectConfig;
import net.sourceforge.cruisecontrol.ProjectInterface;
import net.sourceforge.cruisecontrol.ProjectState;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.ServerNameSingleton;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.DateUtils;

public class BuildLoopInformationBuilder {
    private final CruiseControlController controller;

    public BuildLoopInformationBuilder(CruiseControlController controller) {
        this.controller = controller;
    }

    public BuildLoopInformation buildBuildLoopInformation() {
        String serverName = ServerNameSingleton.getServerName();
        return new BuildLoopInformation(this.getProjects(), this.getJmxInfo(), serverName, this.getTimestamp());
    }

    private BuildLoopInformation.ProjectInfo[] getProjects() {
        List<ProjectInterface> projectConfigs = this.controller.getProjects();
        BuildLoopInformation.ProjectInfo[] projects = new BuildLoopInformation.ProjectInfo[projectConfigs.size()];
        for (int i = 0; i < projectConfigs.size(); ++i) {
            ProjectConfig projectConfig = (ProjectConfig)projectConfigs.get(i);
            projects[i] = new BuildLoopInformation.ProjectInfo(projectConfig.getName(), projectConfig.getStatus(), this.getStartTime(projectConfig));
            if (!projectConfig.isInState(ProjectState.BUILDING)) continue;
            projects[i].setModifications(projectConfig.getModifications());
        }
        return projects;
    }

    private String getStartTime(ProjectConfig projectConfig) {
        try {
            String timeOnBuildLoop = projectConfig.getBuildStartTime();
            if (timeOnBuildLoop != null && timeOnBuildLoop.trim().length() != 0) {
                return DateUtil.formatIso8601(DateUtil.parseFormattedTime(timeOnBuildLoop, "BuildStartTime"));
            }
        }
        catch (CruiseControlException e) {
            Logger.getLogger(BuildLoopInformation.class).error((Object)e);
        }
        return "";
    }

    private String getTimestamp() {
        return DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss");
    }

    private BuildLoopInformation.JmxInfo getJmxInfo() {
        return new BuildLoopInformation.JmxInfo(ServerNameSingleton.getServerName());
    }
}

