/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.attachment.wsdl11;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.AbstractDescriptionElement;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.DescriptionInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.Extensible;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.PolicyProvider;
import org.apache.cxf.ws.policy.attachment.AbstractPolicyProvider;
import org.apache.cxf.ws.policy.attachment.reference.LocalServiceModelReferenceResolver;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;

public class Wsdl11AttachmentPolicyProvider
extends AbstractPolicyProvider
implements PolicyProvider {
    public Wsdl11AttachmentPolicyProvider() {
        this(null);
    }

    public Wsdl11AttachmentPolicyProvider(Bus bus) {
        super(bus);
    }

    public Policy getEffectivePolicy(ServiceInfo si) {
        return this.getElementPolicy(si);
    }

    private Policy mergePolicies(Policy p1, Policy p2) {
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        return p1.merge(p2);
    }

    public Policy getEffectivePolicy(EndpointInfo ei) {
        Policy p = this.getElementPolicy(ei);
        p = this.mergePolicies(p, this.getElementPolicy(ei.getBinding()));
        p = this.mergePolicies(p, this.getElementPolicy(ei.getInterface(), true));
        return p;
    }

    public Policy getEffectivePolicy(BindingOperationInfo bi) {
        DescriptionInfo di = bi.getBinding().getDescription();
        Policy p = this.getElementPolicy(bi, false, di);
        p = this.mergePolicies(p, this.getElementPolicy(bi.getOperationInfo(), false, di));
        return p;
    }

    public Policy getEffectivePolicy(BindingMessageInfo bmi) {
        ServiceInfo si = bmi.getBindingOperation().getBinding().getService();
        DescriptionInfo di = si.getDescription();
        Policy p = this.getElementPolicy(bmi, false, di);
        MessageInfo mi = bmi.getMessageInfo();
        p = this.mergePolicies(p, this.getElementPolicy(mi, true, di));
        Extensible ex = this.getMessageTypeInfo(mi.getName(), di);
        p = this.mergePolicies(p, this.getElementPolicy(ex, false, di));
        return p;
    }

    public Policy getEffectivePolicy(BindingFaultInfo bfi) {
        ServiceInfo si = bfi.getBindingOperation().getBinding().getService();
        DescriptionInfo di = si.getDescription();
        Policy p = this.getElementPolicy(bfi, false, di);
        FaultInfo fi = bfi.getFaultInfo();
        p = this.mergePolicies(p, this.getElementPolicy(fi, true, di));
        Extensible ex = this.getMessageTypeInfo(fi.getName(), di);
        p = this.mergePolicies(p, this.getElementPolicy(ex, false, di));
        return p;
    }

    Policy getElementPolicy(AbstractDescriptionElement adh) {
        return this.getElementPolicy(adh, false);
    }

    Policy getElementPolicy(AbstractDescriptionElement adh, boolean includeAttributes) {
        if (adh == null) {
            return null;
        }
        return this.getElementPolicy(adh, includeAttributes, adh.getDescription());
    }

    Policy getElementPolicy(Extensible ex, boolean includeAttributes, DescriptionInfo di) {
        if (null == ex || null == di) {
            return null;
        }
        Policy elementPolicy = null;
        List<UnknownExtensibilityElement> extensions = ex.getExtensors(UnknownExtensibilityElement.class);
        if (null != extensions) {
            for (UnknownExtensibilityElement unknownExtensibilityElement : extensions) {
                PolicyReference ref;
                Policy p = null;
                if (PolicyConstants.isPolicyElem(unknownExtensibilityElement.getElementType())) {
                    p = this.builder.getPolicy(unknownExtensibilityElement.getElement());
                } else if (PolicyConstants.isPolicyRefElem(unknownExtensibilityElement.getElementType()) && null != (ref = this.builder.getPolicyReference(unknownExtensibilityElement.getElement()))) {
                    p = this.resolveReference(ref, di);
                }
                if (null == p) continue;
                if (elementPolicy == null) {
                    elementPolicy = new Policy();
                }
                elementPolicy = elementPolicy.merge(p);
            }
        }
        if (includeAttributes && ex.getExtensionAttributes() != null) {
            for (Map.Entry entry : ex.getExtensionAttributes().entrySet()) {
                if (!PolicyConstants.isPolicyURIsAttr((QName)entry.getKey())) continue;
                Object attr = entry.getValue();
                String uris = null;
                if (attr instanceof QName) {
                    uris = ((QName)attr).getLocalPart();
                } else if (attr instanceof String) {
                    uris = (String)attr;
                }
                if (null == uris) continue;
                StringTokenizer st = new StringTokenizer(uris);
                while (st.hasMoreTokens()) {
                    String uri = st.nextToken();
                    PolicyReference ref = new PolicyReference();
                    ref.setURI(uri);
                    Policy p = this.resolveReference(ref, di);
                    if (null == p) continue;
                    elementPolicy = elementPolicy == null ? new Policy().merge(p) : elementPolicy.merge(p);
                }
            }
        }
        return elementPolicy;
    }

    Policy resolveReference(PolicyReference ref, DescriptionInfo di) {
        Policy p = null;
        p = this.isExternal(ref) ? this.resolveExternal(ref, di.getBaseURI()) : this.resolveLocal(ref, di);
        this.checkResolved(ref, p);
        return p;
    }

    Policy resolveLocal(PolicyReference ref, DescriptionInfo di) {
        String uri = ref.getURI().substring(1);
        String absoluteURI = di.getBaseURI() + ref.getURI();
        Policy resolved = this.registry.lookup(absoluteURI);
        if (null != resolved) {
            return resolved;
        }
        LocalServiceModelReferenceResolver resolver = new LocalServiceModelReferenceResolver(di, this.builder);
        resolved = resolver.resolveReference(uri);
        if (null != resolved) {
            ref.setURI(absoluteURI);
            this.registry.register(absoluteURI, resolved);
        }
        return resolved;
    }

    private Extensible getMessageTypeInfo(QName name, DescriptionInfo di) {
        List<ExtensibilityElement> extensors;
        if (null == di) {
            return null;
        }
        Definition def = (Definition)di.getProperty(WSDLServiceBuilder.WSDL_DEFINITION);
        if (null == def) {
            return null;
        }
        Message m = def.getMessage(name);
        if (null != m && null != (extensors = CastUtils.cast(m.getExtensibilityElements(), ExtensibilityElement.class))) {
            return new ExtensibleInfo(extensors);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtensibleInfo
    implements Extensible {
        private List<ExtensibilityElement> extensors;

        ExtensibleInfo(List<ExtensibilityElement> e) {
            this.extensors = e;
        }

        @Override
        public <T> T getExtensor(Class<T> cls) {
            for (ExtensibilityElement e : this.extensors) {
                if (!cls.isInstance(e)) continue;
                return cls.cast(e);
            }
            return null;
        }

        @Override
        public <T> List<T> getExtensors(Class<T> cls) {
            if (null == this.extensors) {
                return null;
            }
            ArrayList<T> list = new ArrayList<T>(this.extensors.size());
            for (ExtensibilityElement e : this.extensors) {
                if (!cls.isInstance(e)) continue;
                list.add(cls.cast(e));
            }
            return list;
        }

        @Override
        public void addExtensionAttribute(QName arg0, Object arg1) {
        }

        @Override
        public void addExtensor(Object arg0) {
        }

        @Override
        public Object getExtensionAttribute(QName arg0) {
            return null;
        }

        @Override
        public Map<QName, Object> getExtensionAttributes() {
            return null;
        }

        @Override
        public void setExtensionAttributes(Map<QName, Object> arg0) {
        }
    }
}

