/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.model.MethodInvocationInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriInfoImpl
implements UriInfo {
    private static final Logger LOG = LogUtils.getL7dLogger(UriInfoImpl.class);
    private static final String CASE_INSENSITIVE_QUERIES = "org.apache.cxf.http.case_insensitive_queries";
    private MultivaluedMap<String, String> templateParams;
    private Message message;
    private OperationResourceInfoStack stack;
    private boolean caseInsensitiveQueries;

    public UriInfoImpl(Message m) {
        this(m, (MultivaluedMap<String, String>)((MultivaluedMap)m.get("jaxrs.template.parameters")));
    }

    public UriInfoImpl(Message m, MultivaluedMap<String, String> templateParams) {
        this.message = m;
        this.templateParams = templateParams;
        if (m != null) {
            this.stack = m.get(OperationResourceInfoStack.class);
            this.caseInsensitiveQueries = MessageUtils.isTrue(m.getContextualProperty(CASE_INSENSITIVE_QUERIES));
        }
    }

    public URI getAbsolutePath() {
        String path = this.getAbsolutePathAsString();
        return URI.create(path);
    }

    public UriBuilder getAbsolutePathBuilder() {
        return new UriBuilderImpl(this.getAbsolutePath());
    }

    public URI getBaseUri() {
        URI u = URI.create(HttpUtils.getEndpointAddress(this.message));
        return HttpUtils.toAbsoluteUri(u, this.message);
    }

    public UriBuilder getBaseUriBuilder() {
        return new UriBuilderImpl(this.getBaseUri());
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        String value = this.doGetPath(decode, true);
        if (value.length() > 1 && value.startsWith("/")) {
            return value.substring(1);
        }
        return value;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return JAXRSUtils.getPathSegments(this.getPath(), decode);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (!this.caseInsensitiveQueries) {
            return JAXRSUtils.getStructuredParams((String)this.message.get(Message.QUERY_STRING), "&", decode);
        }
        MetadataMap<String, String> queries = new MetadataMap<String, String>(false, true);
        JAXRSUtils.getStructuredParams(queries, (String)this.message.get(Message.QUERY_STRING), "&", decode);
        return queries;
    }

    public URI getRequestUri() {
        String path = this.getAbsolutePathAsString();
        String queries = (String)this.message.get(Message.QUERY_STRING);
        if (queries != null) {
            path = path + "?" + queries;
        }
        return URI.create(path);
    }

    public UriBuilder getRequestUriBuilder() {
        return new UriBuilderImpl(this.getRequestUri());
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        if (this.templateParams == null) {
            return values;
        }
        for (Map.Entry entry : this.templateParams.entrySet()) {
            if (((String)entry.getKey()).equals("FINAL_MATCH_GROUP")) continue;
            values.add((String)entry.getKey(), decode ? HttpUtils.pathDecode((String)((List)entry.getValue()).get(0)) : (String)((List)entry.getValue()).get(0));
        }
        return values;
    }

    public List<Object> getMatchedResources() {
        if (this.stack != null) {
            ArrayList<Object> resources = new ArrayList<Object>(this.stack.size());
            for (MethodInvocationInfo invocation : this.stack) {
                resources.add(invocation.getRealClass());
            }
            return resources;
        }
        LOG.fine("No resource stack information, returning empty list");
        return Collections.emptyList();
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        if (this.stack != null) {
            ArrayList<String> objects = new ArrayList<String>();
            ArrayList<String> uris = new ArrayList<String>(this.stack.size());
            String sum = "";
            for (MethodInvocationInfo invocation : this.stack) {
                URITemplate[] paths;
                OperationResourceInfo ori = invocation.getMethodInfo();
                for (URITemplate t : paths = new URITemplate[]{ori.getClassResourceInfo().getURITemplate(), ori.getURITemplate()}) {
                    if (t == null) continue;
                    String v = t.getValue();
                    sum = sum + "/" + (decode ? HttpUtils.pathDecode(v) : v);
                }
                UriBuilder ub = UriBuilder.fromPath((String)sum);
                objects.addAll(invocation.getTemplateValues());
                uris.add(ub.build(objects.toArray()).normalize().getPath());
            }
            return uris;
        }
        LOG.fine("No resource stack information, returning empty list");
        return Collections.emptyList();
    }

    private String doGetPath(boolean decode, boolean addSlash) {
        String path = HttpUtils.getPathToMatch(this.message, addSlash);
        return decode ? HttpUtils.pathDecode(path) : path;
    }

    private String getAbsolutePathAsString() {
        String address = this.getBaseUri().toString();
        if (MessageUtils.isRequestor(this.message)) {
            return address;
        }
        String path = this.doGetPath(false, false);
        if (path.startsWith("/") && address.endsWith("/")) {
            address = address.substring(0, address.length() - 1);
        }
        return address + path;
    }
}

