/*
 * Decompiled with CFR 0.152.
 */
package com.planetj.math.rabinhash;

import com.planetj.math.rabinhash.RabinHashFunctionUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public final class RabinHashFunction32
implements Serializable,
Cloneable {
    private static final int DEFAULT_IRREDUCIBLE_POLY = 141;
    public static final RabinHashFunction32 DEFAULT_HASH_FUNCTION = new RabinHashFunction32(141);
    private static final int P_DEGREE = 32;
    private static final int X_P_DEGREE = Integer.MIN_VALUE;
    private static final int READ_BUFFER_SIZE = 1024;
    private final int P;
    private transient int[] table32;
    private transient int[] table40;
    private transient int[] table48;
    private transient int[] table56;

    public RabinHashFunction32(int P) {
        this.P = P;
        this.initializeTables();
    }

    private void initializeTables() {
        int i;
        int[] mods = new int[32];
        mods[0] = this.P;
        for (i = 1; i < 32; ++i) {
            int lastMod = mods[i - 1];
            int thisMod = lastMod << 1;
            if ((lastMod & Integer.MIN_VALUE) != 0) {
                thisMod ^= this.P;
            }
            mods[i] = thisMod;
        }
        this.table32 = new int[256];
        this.table40 = new int[256];
        this.table48 = new int[256];
        this.table56 = new int[256];
        for (i = 0; i < 256; ++i) {
            int c = i;
            for (int j = 0; j < 8 && c > 0; c >>>= 1, ++j) {
                if ((c & 1) == 0) continue;
                int n = i;
                this.table32[n] = this.table32[n] ^ mods[j];
                int n2 = i;
                this.table40[n2] = this.table40[n2] ^ mods[j + 8];
                int n3 = i;
                this.table48[n3] = this.table48[n3] ^ mods[j + 16];
                int n4 = i;
                this.table56[n4] = this.table56[n4] ^ mods[j + 24];
            }
        }
    }

    public int getP() {
        return this.P;
    }

    private int computeWShifted(int w) {
        return this.table32[w & 0xFF] ^ this.table40[w >>> 8 & 0xFF] ^ this.table48[w >>> 16 & 0xFF] ^ this.table56[w >>> 24 & 0xFF];
    }

    public int hash(byte[] A) {
        return this.hash(A, 0, A.length, 0);
    }

    int hash(byte[] A, int offset, int length, int w) {
        int s;
        int max;
        int starterBytes = length % 4;
        if (starterBytes != 0) {
            max = offset + starterBytes;
            for (s = offset; s < max; ++s) {
                w = w << 8 ^ A[s] & 0xFF;
            }
        }
        max = offset + length;
        while (s < max) {
            w = this.computeWShifted(w) ^ A[s] << 24 ^ (A[s + 1] & 0xFF) << 16 ^ (A[s + 2] & 0xFF) << 8 ^ A[s + 3] & 0xFF;
            s += 4;
        }
        return w;
    }

    public int hash(char[] A) {
        int s;
        int w;
        if (A.length % 2 == 1) {
            w = A[0] & 0xFFFF;
            s = 1;
        } else {
            w = 0;
            s = 0;
        }
        while (s < A.length) {
            w = this.computeWShifted(w) ^ (A[s] & 0xFFFF) << 16 ^ A[s + 1] & 0xFFFF;
            s += 2;
        }
        return w;
    }

    public int hash(int[] A) {
        int w = 0;
        for (int s = 0; s < A.length; ++s) {
            w = this.computeWShifted(w) ^ A[s];
        }
        return w;
    }

    public int hash(ByteBuffer A) {
        return this.hash(A.asIntBuffer());
    }

    public int hash(IntBuffer A) {
        int w = 0;
        while (A.hasRemaining()) {
            w = this.computeWShifted(w) ^ A.get();
        }
        return w;
    }

    public int hash(Serializable obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.hash(baos.toByteArray());
    }

    public int hash(String s) {
        return this.hash(s.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hash(File f) throws FileNotFoundException, IOException {
        if (f == null) {
            throw new NullPointerException();
        }
        FileInputStream fis = new FileInputStream(f);
        try {
            int n = this.hash(fis);
            return n;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hash(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            int n = this.hash(is);
            return n;
        }
        finally {
            is.close();
        }
    }

    public int hash(InputStream is) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        int w = 0;
        while ((bytesRead = is.read(buffer)) > 0) {
            w = this.hash(buffer, 0, bytesRead, w);
        }
        return w;
    }

    public boolean equals(Object o) {
        return o instanceof RabinHashFunction32 && ((RabinHashFunction32)o).P == this.P;
    }

    public int hashCode() {
        return this.P;
    }

    public String toString() {
        return "RabinHashFunction32[P: " + RabinHashFunctionUtils.polynomialToString(this.P) + "]";
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initializeTables();
    }
}

