/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;

public class FacebookReturnTypeProcessor5
implements AnnotationProcessor {
    private PrintWriter outJAXB;
    private PrintWriter outJSON;
    private PrintWriter outXML;
    private AnnotationProcessorEnvironment processingEnv;

    public FacebookReturnTypeProcessor5(AnnotationProcessorEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    private static CharSequence modifiers(ConstructorDeclaration e) {
        StringBuilder modifiers = new StringBuilder();
        Collection modifierSet = e.getModifiers();
        boolean isFirstModifier = true;
        for (Modifier m : modifierSet) {
            if (!isFirstModifier) {
                modifiers.append(" ");
            }
            modifiers.append(m.toString());
        }
        return modifiers;
    }

    private static CharSequence throwClause(ConstructorDeclaration e) {
        StringBuilder throwClause = new StringBuilder();
        Collection thrownTypes = e.getThrownTypes();
        boolean isFirstThrows = true;
        for (ReferenceType t : thrownTypes) {
            if (isFirstThrows) {
                throwClause.append("throws ");
            } else {
                throwClause.append(", ");
            }
            throwClause.append(t.toString());
        }
        return throwClause;
    }

    private static CharSequence throwClause(MethodDeclaration e) {
        StringBuilder throwClause = new StringBuilder();
        Collection thrownTypes = e.getThrownTypes();
        boolean isFirstThrows = true;
        for (ReferenceType t : thrownTypes) {
            if (isFirstThrows) {
                throwClause.append("throws ");
            } else {
                throwClause.append(", ");
            }
            throwClause.append(t.toString());
        }
        return throwClause;
    }

    private static CharSequence parametersIncludingTypes(ConstructorDeclaration e) {
        StringBuilder methodCode = new StringBuilder();
        boolean isFirstParam = true;
        Collection parameters = e.getParameters();
        for (ParameterDeclaration param : parameters) {
            if (!isFirstParam) {
                methodCode.append(", ");
            }
            TypeMirror paramType = param.getType();
            methodCode.append(paramType.toString());
            methodCode.append(" ");
            String paramName = param.toString();
            if (paramName.contains(" ")) {
                paramName = paramName.substring(paramName.indexOf(32) + 1);
            }
            methodCode.append(paramName);
            isFirstParam = false;
        }
        return methodCode;
    }

    private static CharSequence parametersIncludingTypes(MethodDeclaration e) {
        StringBuilder methodCode = new StringBuilder();
        boolean isFirstParam = true;
        Collection parameters = e.getParameters();
        for (ParameterDeclaration param : parameters) {
            if (!isFirstParam) {
                methodCode.append(", ");
            }
            TypeMirror paramType = param.getType();
            methodCode.append(paramType.toString());
            methodCode.append(" ");
            String paramName = param.toString();
            if (paramName.contains(" ")) {
                paramName = paramName.substring(paramName.indexOf(32) + 1);
            }
            methodCode.append(paramName);
            isFirstParam = false;
        }
        return methodCode;
    }

    private static CharSequence parametersExcludingTypes(ConstructorDeclaration e) {
        StringBuilder paramListCode = new StringBuilder();
        boolean isFirstParam = true;
        Collection parameters = e.getParameters();
        for (ParameterDeclaration param : parameters) {
            String paramName;
            if (!isFirstParam) {
                paramListCode.append(", ");
            }
            if ((paramName = param.toString()).contains(" ")) {
                paramName = paramName.substring(paramName.indexOf(32) + 1);
            }
            paramListCode.append(paramName);
            isFirstParam = false;
        }
        return paramListCode;
    }

    private static CharSequence parametersExcludingTypes(MethodDeclaration e) {
        StringBuilder paramListCode = new StringBuilder();
        boolean isFirstParam = true;
        Collection parameters = e.getParameters();
        for (ParameterDeclaration param : parameters) {
            String paramName;
            if (!isFirstParam) {
                paramListCode.append(", ");
            }
            if ((paramName = param.toString()).contains(" ")) {
                paramName = paramName.substring(paramName.indexOf(32) + 1);
            }
            paramListCode.append(paramName);
            isFirstParam = false;
        }
        return paramListCode;
    }

    private static void writeHeader(PrintWriter out, String classNamePart) {
        out.println("package com.google.code.facebookapi;");
        out.println();
        if (classNamePart.equals("Jaxb")) {
            out.println("@SuppressWarnings(\"unchecked\")");
        }
        out.println("public class Facebook" + classNamePart + "RestClient extends Facebook" + classNamePart + "RestClientBase {");
        out.println();
    }

    public void process() {
        try {
            this.outJAXB = this.processingEnv.getFiler().createSourceFile("com.google.code.facebookapi.FacebookJaxbRestClient");
            this.outJSON = this.processingEnv.getFiler().createSourceFile("com.google.code.facebookapi.FacebookJsonRestClient");
            this.outXML = this.processingEnv.getFiler().createSourceFile("com.google.code.facebookapi.FacebookXmlRestClient");
        }
        catch (IOException ex) {
            System.out.println("Ignoring second attempt to process annotations");
            return;
        }
        FacebookReturnTypeProcessor5.writeHeader(this.outJAXB, "Jaxb");
        FacebookReturnTypeProcessor5.writeHeader(this.outJSON, "Json");
        FacebookReturnTypeProcessor5.writeHeader(this.outXML, "Xml");
        CopyConstructorVisitor copyConstructorsJaxb = new CopyConstructorVisitor("Jaxb", this.outJAXB);
        CopyConstructorVisitor copyConstructorsJson = new CopyConstructorVisitor("Json", this.outJSON);
        CopyConstructorVisitor copyConstructorsXml = new CopyConstructorVisitor("Xml", this.outXML);
        ClassDeclaration jaxbClientBase = (ClassDeclaration)this.processingEnv.getTypeDeclaration("com.google.code.facebookapi.FacebookJaxbRestClientBase");
        for (ConstructorDeclaration cd : jaxbClientBase.getConstructors()) {
            cd.accept((DeclarationVisitor)copyConstructorsJaxb);
        }
        ClassDeclaration jsonClientBase = (ClassDeclaration)this.processingEnv.getTypeDeclaration("com.google.code.facebookapi.FacebookJsonRestClientBase");
        for (ConstructorDeclaration cd : jsonClientBase.getConstructors()) {
            cd.accept((DeclarationVisitor)copyConstructorsJson);
        }
        ClassDeclaration xmlClientBase = (ClassDeclaration)this.processingEnv.getTypeDeclaration("com.google.code.facebookapi.FacebookXmlRestClientBase");
        for (ConstructorDeclaration cd : xmlClientBase.getConstructors()) {
            cd.accept((DeclarationVisitor)copyConstructorsXml);
        }
        AnnotationVisitor visitor = new AnnotationVisitor(this.outJAXB, this.outJSON, this.outXML);
        Collection elements = this.processingEnv.getDeclarationsAnnotatedWith((AnnotationTypeDeclaration)this.processingEnv.getTypeDeclaration("com.google.code.facebookapi.FacebookReturnType"));
        for (Declaration element : elements) {
            element.accept((DeclarationVisitor)visitor);
        }
        this.outJAXB.println("}");
        this.outJAXB.flush();
        this.outJAXB.close();
        this.outJSON.println("}");
        this.outJSON.flush();
        this.outJSON.close();
        this.outXML.println("}");
        this.outXML.flush();
        this.outXML.close();
    }

    private static void shakeEnclosingElementMethods(MethodDeclaration e) {
        e.getDeclaringType().getMethods();
    }

    public static void printMethod(PrintWriter out, String returnType, boolean deprecated, String methSig, String methCall, String methRet) {
        if (deprecated) {
            out.println("    @Deprecated");
        }
        out.println(methSig.replace("%RETURNTYPE%", returnType));
        out.println(methCall);
        out.println(methRet.replace("%RETURNTYPE%", returnType));
        out.println("    }");
        out.println();
    }

    public static String stripDotClass(String input) {
        if (!input.endsWith(".class")) {
            return input;
        }
        return input.substring(0, input.length() - 6);
    }

    public static class AnnotationVisitor
    extends SimpleDeclarationVisitor {
        private PrintWriter outJAXB;
        private PrintWriter outJSON;
        private PrintWriter outXML;

        public AnnotationVisitor(PrintWriter outJAXB, PrintWriter outJSON, PrintWriter outXML) {
            this.outJAXB = outJAXB;
            this.outJSON = outJSON;
            this.outXML = outXML;
        }

        public void visitMethodDeclaration(MethodDeclaration e) {
            FacebookReturnTypeProcessor5.shakeEnclosingElementMethods(e);
            String jaxbReturnType = "Object";
            String jsonReturnType = "Object";
            String xmlReturnType = "org.w3c.dom.Document";
            Collection annotations = e.getAnnotationMirrors();
            AnnotationMirror firstAnnotation = (AnnotationMirror)annotations.iterator().next();
            Map annotationParams = firstAnnotation.getElementValues();
            boolean jaxbAlreadySet = false;
            for (AnnotationTypeElementDeclaration key : annotationParams.keySet()) {
                String name = key.getSimpleName();
                String val = ((AnnotationValue)annotationParams.get(key)).toString();
                if (name.contentEquals("JAXBList")) {
                    if (annotationParams.get(key) == null) continue;
                    jaxbReturnType = "java.util.List<" + FacebookReturnTypeProcessor5.stripDotClass(val) + ">";
                    jaxbAlreadySet = true;
                    continue;
                }
                if (!jaxbAlreadySet && name.contentEquals("JAXB")) {
                    if (annotationParams.get(key) == null) continue;
                    jaxbReturnType = FacebookReturnTypeProcessor5.stripDotClass(val);
                    continue;
                }
                if (!name.contentEquals("JSON") || annotationParams.get(key) == null) continue;
                jsonReturnType = FacebookReturnTypeProcessor5.stripDotClass(val);
            }
            boolean deprecated = e.getAnnotation(Deprecated.class) != null;
            String methName = e.getSimpleName();
            String methSig = "    public %s %s( %s ) %s {";
            methSig = String.format(methSig, "%RETURNTYPE%", methName, FacebookReturnTypeProcessor5.parametersIncludingTypes(e), FacebookReturnTypeProcessor5.throwClause(e));
            String methCall = "        Object rawResponse = client.%s( %s );";
            methCall = String.format(methCall, methName, FacebookReturnTypeProcessor5.parametersExcludingTypes(e));
            String methRet = "        return (%s)parseCallResult( rawResponse );";
            methRet = String.format(methRet, "%RETURNTYPE%");
            String methRet2 = "        return parseCallResult( %s.class, rawResponse );";
            methRet2 = String.format(methRet2, "%RETURNTYPE%");
            FacebookReturnTypeProcessor5.printMethod(this.outJAXB, jaxbReturnType, deprecated, methSig, methCall, methRet);
            FacebookReturnTypeProcessor5.printMethod(this.outJSON, jsonReturnType, deprecated, methSig, methCall, methRet2);
            FacebookReturnTypeProcessor5.printMethod(this.outXML, xmlReturnType, deprecated, methSig, methCall, methRet);
        }
    }

    public static class CopyConstructorVisitor
    extends SimpleDeclarationVisitor {
        private String clientType;
        private PrintWriter out;

        public CopyConstructorVisitor(String clientType, PrintWriter out) {
            this.clientType = clientType;
            this.out = out;
        }

        public void visitConstructorDeclaration(ConstructorDeclaration e) {
            this.out.print("    ");
            this.out.print(FacebookReturnTypeProcessor5.modifiers(e));
            this.out.print(" ");
            this.out.print("Facebook");
            this.out.print(this.clientType);
            this.out.print("RestClient");
            this.out.print("( ");
            this.out.print(FacebookReturnTypeProcessor5.parametersIncludingTypes(e));
            this.out.print(" ) ");
            this.out.print(FacebookReturnTypeProcessor5.throwClause(e));
            this.out.println(" {");
            this.out.print("        super( ");
            this.out.print(FacebookReturnTypeProcessor5.parametersExcludingTypes(e));
            this.out.println(" );");
            this.out.println("    }");
            this.out.println();
        }
    }
}

