 //////////////
 //   JSON   //
//////////////

/**
 * A queue of JSON requests.
 * This class maintains a queue of asynchronous JSON events. The requests are
 * processed one after another. While one request is pending, the remaining
 * requests can be cancelled with {@link #cancel}.
 * @constructor
 */
function JSON() {
}
/***
* 0 = NO JSON Request
* 1 = Criteria not in Cache
* 2 = Criteria modified check
* 3 = List request
*/
JSON.getStatus = function() {
    var tmpStatus= JSON.status;
    JSON.status=0;
    return tmpStatus;
}
JSON.status=0;
JSON.responses=new Object();
JSON.responses["tasks"]=new Object();
JSON.responses["tasks"].criteriaFirst=[
    {"data":[
            [31,24096,1191343085101],[31,24097,1186163508676],[31,24099,1186163647067],
            [31,24852,1188914229514],[31,24853,1188914576278],[31,24939,1191342749628],
            [31,24946,1196858909364],[31,25254,1195566883603]
            ],
     "timestamp":1196855309364}
];
JSON.responses["tasks"].listFirst=[
    {
		"data":[
		      [31,24097,1186163508676,"Menu Umbau"],
		      [31,24099,1186163647067,"Popup Umbau mit Disabled Background"],
			  [31,24096,1191343085101,"Objectcache"],
			  [31,24853,1188914576278,null],
			  [31,24852,1188914229514,null]
        ],
		"timestamp":1191335885101
    }
];
JSON.responses["tasks"].listUpdateNoChanges=[
    {
        "data":[
              [31,24097,1186163508676,"Menu Umbau"],
              [31,24099,1186163647067,"Popup Umbau mit Disabled Background"],
              [31,24096,1191343085101,"Objectcache"],
              [31,24853,1188914576278,null],
              [31,24852,1188914229514,null]
        ],
        "timestamp":1191335885101
    }
];
JSON.responses["tasks"].listUpdateNoChanges=[
    {
        "data":[
              [31,24097,1186163508676,"Menu Umbau"],
              [31,24099,1186163647067,"Popup Umbau mit Disabled Background"],
              [31,24096,1191343085101,"Objectcache"],
              [31,24853,1188914576278,null],
              [31,24852,1188914229514,null]
        ],
        "timestamp":1191335885101
    }
];
JSON.responses["tasks"].listUpdateUpdateChanges=[
    {
        "data":[
              [31,24097,1201193792415,"Menu Umbau 2"],
              [31,24099,1186163647067,"Popup Umbau mit Disabled Background"],
              [31,24096,1191343085101,"Objectcache"],
              [31,24853,1188914576278,null],
              [31,24852,1188914229514,null]
        ],
        "timestamp":1201190192415
    }
];
JSON.responses["tasks"].listUpdateDeleteChanges=[
    {
        "data":[
              [31,24099,1186163647067,"Popup Umbau mit Disabled Background"],
              [31,24096,1191343085101,"Objectcache"],
              [31,24853,1188914576278,null],
              [31,24852,1188914229514,null]
        ],
        "timestamp":1201190192415
    }
];



JSON.responses["tasks"].criteriaUpdateNoChanges=[
    {
        "data":[
            [31,24096,1191343085101],[31,24097,1186163508676],[31,24099,1186163647067],
            [31,24852,1188914229514],[31,24853,1188914576278],[31,24939,1191342749628],
            [31,24946,1196858909364],[31,25254,1195566883603]
        ],
        "timestamp":1196855309364
    },
    {
        "data":[],
        "timestamp":1196855309365
    }
];
JSON.responses["tasks"].criteriaUpdateNewObject=[
    {
        "data":[
            [31,24096,1191343085101],[31,24097,1186163508676],[31,24099,1186163647067],
            [31,24852,1188914229514],[31,24853,1188914576278],[31,24939,1191342749628],
            [31,24946,1196858909364],[31,25254,1195566883603],[31,25268,1201101570350]
        ],
        "timestamp":1201097970350
    },{
        "data":[[31,25268,1201101570350]],
        "timestamp":1201097970350
    }
];
JSON.responses["tasks"].criteriaUpdateUpdateObject=[
    {
        "data":[
            [31,24096,1191343085101],[31,24097,1186163508676],[31,24099,1186163647067],
            [31,24852,1188914229514],[31,24853,1188914576278],[31,24939,1191342749628],
            [31,24946,1201102128555],[31,25254,1195566883603]
        ],
        "timestamp":1201098528555
    },
    {
        "data":[[31,24946,1201102128555]],
        "timestamp":1201098528555
    }
];
JSON.responses["tasks"].criteriaUpdateDeleteObject=[
    {
        "data":[
            [31,24096,1191343085101],[31,24097,1186163508676],[31,24099,1186163647067],
            [31,24852,1188914229514],[31,24853,1188914576278],[31,24939,1191342749628],
            [31,24946,1201102128555]
        ],
        "timestamp":1201098528555
    },
    {
        "data":[],
        "timestamp":1201098528555
    }
];
JSON.responses["contacts"]=new Object();
JSON.responses["contacts"].criteriaFirst= [
    {
        "data":[
            [30,35314,1195044980908],[30,34189,1191334513259],[30,34188,1187284373925],
            [30,30868,1182875939889],[30,34192,1187285171065],[30,34193,1191339015403],
            [30,29884,1182875943992],[30,29879,1177495799293],[30,29885,1178814946200],
            [30,29865,1177494577592],[30,30842,1179741359755],[30,31528,1185811188799],
            [30,31529,1185811193347],[30,34190,1187284597097],[30,34186,1187284195085],
            [30,34191,1187285027482],[30,31009,1185794709033],[30,31530,1185811193733],
            [30,29874,1177495498235],[30,34185,1187284116884],[30,29883,1177495879102],
            [30,29882,1177495821092],[30,29881,1177495813685],[30,29878,1177495775688]
        ],
        "timestamp":1195044980908
    }
];
JSON.responses["contacts"].listFirst = [
    {
        "data":[
            [30,30868,1182875939889,null,"Jan Finsel Distri",null],
            [30,34188,1187284373925,null,"Jan","Jan2"],
            [30,34189,1191334513259,null,"hakkjk","hjkhjk"],
            [30,34192,1187285171065,null,"jjkl�j�l","jkl�j�lkj"]
        ],
        "timestamp":1191334513259
    }
];
JSON.responses["contacts"].criteriaUpdateNoChanges=[
    {
        "data":[
            [30,35314,1195044980908],[30,34189,1191334513259],[30,34188,1187284373925],
            [30,30868,1182875939889],[30,34192,1187285171065],[30,34193,1191339015403],
            [30,29884,1182875943992],[30,29879,1177495799293],[30,29885,1178814946200],
            [30,29865,1177494577592],[30,30842,1179741359755],[30,31528,1185811188799],
            [30,31529,1185811193347],[30,34190,1187284597097],[30,34186,1187284195085],
            [30,34191,1187285027482],[30,31009,1185794709033],[30,31530,1185811193733],
            [30,29874,1177495498235],[30,34185,1187284116884],[30,29883,1177495879102],
            [30,29882,1177495821092],[30,29881,1177495813685],[30,29878,1177495775688]
        ],
        "timestamp":1195044980908
    },
    {
        "data":[],
        "timestamp":1195044980909
    }
];
JSON.responses["contacts"].listUpdateNoChanges = [
    {
        "data":[
            [30,30868,1182875939889,null,"Jan Finsel Distri",null],
            [30,34188,1187284373925,null,"Jan","Jan2"],
            [30,34189,1191334513259,null,"hakkjk","hjkhjk"],
            [30,34192,1187285171065,null,"jjkl�j�l","jkl�j�lkj"]
        ],
        "timestamp":1191334513259
    }
];
JSON.responses["contacts"].listUpdateUpdateChanges = [
    {
        "data":[
            [30,30868,1182875939889,null,"Jan Finsel Distri",null],
            [30,34188,1187284373925,null,"Jan","Jan2"],
            [30,34189,1201177058959,null,"Geaendert","Geaendert"],
            [30,34192,1187285171065,null,"jjkl�j�l","jkl�j�lkj"]
        ],
        "timestamp":1201177058959
    }
];
JSON.responses["contacts"].listUpdateDeleteChanges = [
    {
        "data":[
            [30,30868,1182875939889,null,"Jan Finsel Distri",null],
            [30,34189,1201177058959,null,"hakkjk","hjkhjk"],
            [30,34192,1187285171065,null,"jjkl�j�l","jkl�j�lkj"]
        ],
        "timestamp":1201177058959
    }
];
JSON.responses["contacts"].criteriaUpdateNewObject=[
    {
        "data":[
            [30,35808,1201101077682],[30,35314,1195044980908],[30,34189,1191334513259],
            [30,34188,1187284373925],[30,30868,1182875939889],[30,34192,1187285171065],
            [30,34193,1191339015403],[30,29884,1182875943992],[30,29879,1177495799293],
            [30,29885,1178814946200],[30,29865,1177494577592],[30,30842,1179741359755],
            [30,31528,1185811188799],[30,31529,1185811193347],[30,34190,1187284597097],
            [30,34186,1187284195085],[30,34191,1187285027482],[30,31009,1185794709033],
            [30,31530,1185811193733],[30,29874,1177495498235],[30,34185,1187284116884],
            [30,29883,1177495879102],[30,29882,1177495821092],[30,29881,1177495813685],
            [30,29878,1177495775688]
        ],"timestamp":1201101077682
    },
    {
        "data":[[30,35808,1201101077682]],
        "timestamp":1201101077682
    }
];

JSON.responses["contacts"].criteriaUpdateUpdateObject=[
    {
        "data":[
            [30,35314,1201101431546],[30,34189,1191334513259],[30,34188,1187284373925],
            [30,30868,1182875939889],[30,34192,1187285171065],[30,34193,1191339015403],
            [30,29884,1182875943992],[30,29879,1177495799293],[30,29885,1178814946200],
            [30,29865,1177494577592],[30,30842,1179741359755],[30,31528,1185811188799],
            [30,31529,1185811193347],[30,34190,1187284597097],[30,34186,1187284195085],
            [30,34191,1187285027482],[30,31009,1185794709033],[30,31530,1185811193733],
            [30,29874,1177495498235],[30,34185,1187284116884],[30,29883,1177495879102],
            [30,29882,1177495821092],[30,29881,1177495813685],[30,29878,1177495775688]
        ],
        "timestamp":1201101431546
    },
    {
        "data":[[30,35314,1201101431546,4]],
        "timestamp":1201101431546
    }
];
JSON.responses["contacts"].criteriaUpdateDeleteObject=[
    {
        "data":[
            [30,34189,1191334513259],[30,34188,1187284373925],[30,30868,1182875939889],
            [30,34192,1187285171065],[30,34193,1191339015403],[30,29884,1182875943992],
            [30,29879,1177495799293],[30,29885,1178814946200],[30,29865,1177494577592],
            [30,30842,1179741359755],[30,31528,1185811188799],[30,31529,1185811193347],
            [30,34190,1187284597097],[30,34186,1187284195085],[30,34191,1187285027482],
            [30,31009,1185794709033],[30,31530,1185811193733],[30,29874,1177495498235],
            [30,34185,1187284116884],[30,29883,1177495879102],[30,29882,1177495821092],
            [30,29881,1177495813685],[30,29878,1177495775688]
        ],
        "timestamp":1191339015403
    },
    {
        "data":[],
        "timestamp":1201101431547
    }
];
JSON.responses["calendar"]=new Object();
JSON.responses["calendar"].criteriaFirst=[
    {
        "data":[
            [810,6767,0,1174658154633],[810,6766,0,1174930392551],[810,6765,0,1174930689530],
            [810,6764,0,1174930662526],[810,10500,0,1199894037505],[810,9066,0,1185380405699],
            [810,10505,0,1199897554985]
        ],
        "timestamp":1199893954985
    }
];
JSON.responses["calendar"].listFirst=[
    {
        "data":[
             [29,6596,0,1172077131139,"Fuckel"],
             [29,9071,0,1185551274804,"test group"],
             [29,9072,0,1185551275775,"test group"]
        ],
        "timestamp":1185544075775
    }
];
JSON.responses["calendar"].listUpdateNoChanges=[
    {
        "data":[
            [29,6596,0,1172077131139,"Fuckel"],
            [29,9071,0,1185551274804,"test group"],
            [29,9072,0,1185551275775,"test group"]
        ],
        "timestamp":1185544075775
    }
];
JSON.responses["calendar"].listUpdateUpdateChanges=[
    {
        "data":[
            [29,6596,0,1172077131139,"Fuckel"],
            [29,9071,0,1201197366399,"Ein ge�nderter Termin"],
            [29,9072,0,1185551275775,"test group"]
        ],
        "timestamp":1201193766399
    }
];
JSON.responses["calendar"].listUpdateDeleteChanges;

JSON.responses["calendar"].criteriaUpdateNoChanges=[
    {
        "data":[
            [810,6767,0,1174658154633],[810,6766,0,1174930392551],[810,6765,0,1174930689530],
            [810,6764,0,1174930662526],[810,10500,0,1199894037505],[810,9066,0,1185380405699],
            [810,10505,0,1199897554985]
        ],"timestamp":1199893954985
    },
    {
        "data":[],
        "timestamp":1199893954986
    }
];
JSON.responses["calendar"].criteriaUpdateNewObject=[
    {
        "data":[
            [810,36485,0,1201107491947],[810,6767,0,1174658154633],[810,6766,0,1174930392551],
            [810,6765,0,1174930689530],[810,6764,0,1174930662526],[810,10500,0,1199894037505],
            [810,9066,0,1185380405699],[810,10505,0,1199897554985]
        ],
        "timestamp":1201103891947
    },
    {
        "data":[[810,36485,0,1201107491947]],
        "timestamp":1201103891947
    }
];
JSON.responses["calendar"].criteriaUpdateUpdateObject=[
    {
        "data":[
            [810,6767,0,1174658154633],[810,6766,0,1201107795850],[810,6765,0,1174930689530],
            [810,6764,0,1174930662526],[810,10500,0,1199894037505],[810,9066,0,1185380405699],
            [810,10505,0,1199897554985]
        ],
        "timestamp":1201104195850
    },
    {
        "data":[[810,6766,0,1201107795850]],
        "timestamp":1201104195850
    }
];
JSON.responses["calendar"].criteriaUpdateDeleteObject=[
    {
        "data":[
            [810,6767,0,1174658154633],[810,6765,0,1174930689530],[810,6764,0,1174930662526],
            [810,10500,0,1199894037505],[810,9066,0,1185380405699],[810,10505,0,1199897554985]
        ],
        "timestamp":1201104195850
    },
    {
        "data":[],
        "timestamp":1201104195851
    }
];
JSON.responses["infostore"]=new Object();
JSON.responses["infostore"].criteriaFirst= [
    {
        "data":[
            ["32","3386",1187610991140],["32","3387",1194275861164],["32","3418",1179319517482],
            ["32","5939",1195567502115],["32","5956",1197025134886]
        ],
        "timestamp":1201102064720
    }
];
JSON.responses["infostore"].listFirst= [
    {
		"data":[
		    ["32","3386",1201106160488,"Infostore 257"],
			["32","3387",1194275861164,"Infostore 2"],
			["32","3418",1179319517482,"7777"],
			["32","5956",1197025134886,"Source LicenseDB Extra Text"]
	    ],
		"timestamp":1201191600030
    }
];
JSON.responses["infostore"].listUpdateNoChanges=[
    {
        "data":[
            ["32","3386",1201106160488,"Infostore 257"],
            ["32","3387",1194275861164,"Infostore 2"],
            ["32","3418",1179319517482,"7777"],
            ["32","5956",1197025134886,"Source LicenseDB Extra Text"]
        ],
        "timestamp":1201192105632
    }
];
JSON.responses["infostore"].listUpdateUpdateChanges=[
    {
		"data":[
		    ["32","3386",1201195910983,"Infostore 25788"],
			["32","3387",1194275861164,"Infostore 2"],
			["32","3418",1179319517482,"7777"],
			["32","5956",1197025134886,"Source LicenseDB Extra Text"]
	   ],
	   "timestamp":1201192315670
	}
];
JSON.responses["infostore"].listUpdateDeleteChanges=[
    {
		"data":[
	        ["32","3387",1194275861164,"Infostore 2"],
			["32","3418",1179319517482,"7777"],
			["32","5956",1197025134886,"Source LicenseDB Extra Text"]
		],
		"timestamp":1201192429712
	}
];
JSON.responses["infostore"].criteriaUpdateNoChanges=[
    {
        "data":[
            ["32","3386",1187610991140],["32","3387",1194275861164],["32","3418",1179319517482],
            ["32","5939",1195567502115],["32","5956",1197025134886]
        ],
        "timestamp":1201102209461
    },
    {
        "data":[],
        "timestamp":1201102209470
    }
];
JSON.responses["infostore"].criteriaUpdateNewObject=[
    {
        "data":[
            ["32","3386",1187610991140],["32","3387",1194275861164],["32","3418",1179319517482],
            ["32","5939",1195567502115],["32","5956",1197025134886],["32","5971",1201105921690]
        ],"timestamp":1201102325901
    },
    {
        "data":[["32","5971",1201105921690]],
        "timestamp":1201102325905
    }
];
JSON.responses["infostore"].criteriaUpdateUpdateObject=[
    {
        "data":[
            ["32","3386",1201106160488],["32","3387",1194275861164],["32","3418",1179319517482],
            ["32","5939",1195567502115],["32","5956",1197025134886]
        ],"timestamp":1201102563584
    },
    {
        "data":[["32","3386",1201106160488]],
        "timestamp":1201102563592
    }
];
JSON.responses["infostore"].criteriaUpdateDeleteObject=[
    {
        "data":[
            ["32","3386",1201106160488],["32","3387",1194275861164],["32","3418",1179319517482],
            ["32","5956",1197025134886]
        ],
        "timestamp":1201102769922
    },
    {
        "data":[],
        "timestamp":1201102769932
    }
];

JSON.responses["mail"]=new Object();
JSON.responses["mail"].criteriaFirst= [
    {
        "data":[
            ["INBOX/5 Mails/1","default/INBOX/5 Mails"],["INBOX/5 Mails/2","default/INBOX/5 Mails"],
            ["INBOX/5 Mails/3","default/INBOX/5 Mails"],["INBOX/5 Mails/4","default/INBOX/5 Mails"],
            ["INBOX/5 Mails/5","default/INBOX/5 Mails"]
        ]
    }
];
JSON.responses["mail"].listFirst= [
    {
		"data":[
		    ["INBOX/5 Mails/1","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"],
			["INBOX/5 Mails/7","default/INBOX/5 Mails","Test"],
			["INBOX/5 Mails/8","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"],
			["INBOX/5 Mails/9","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"],
			["INBOX/5 Mails/10","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"]
	     ]
    }
];
JSON.responses["mail"].listUpdateNoChanges= [
    {
        "data":[
            ["INBOX/5 Mails/1","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"],
            ["INBOX/5 Mails/7","default/INBOX/5 Mails","Test"],
            ["INBOX/5 Mails/8","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"],
            ["INBOX/5 Mails/9","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"],
            ["INBOX/5 Mails/10","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"]
         ]
    }
];
JSON.responses["mail"].listUpdateUpdateChanges= [
    {
        "data":[
            ["INBOX/5 Mails/1","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"],
            ["INBOX/5 Mails/7","default/INBOX/5 Mails","Test"],
            ["INBOX/5 Mails/8","default/INBOX/5 Mails","Ein neuer Test"],
            ["INBOX/5 Mails/9","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"],
            ["INBOX/5 Mails/10","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"]
         ]
    }
];
JSON.responses["mail"].listUpdateDeleteChanges= [
    {
        "data":[
            ["INBOX/5 Mails/1","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"],
			["INBOX/5 Mails/8","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"],
			["INBOX/5 Mails/9","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"],
			["INBOX/5 Mails/10","default/INBOX/5 Mails","Ein neuer Testnnnjjjjjjjjj"]
		]
	}
];



JSON.responses["mail"].criteriaUpdateNoChanges=[
    {
        "data":[
            ["INBOX/5 Mails/1","default/INBOX/5 Mails"],["INBOX/5 Mails/2","default/INBOX/5 Mails"],
            ["INBOX/5 Mails/3","default/INBOX/5 Mails"],["INBOX/5 Mails/4","default/INBOX/5 Mails"],
            ["INBOX/5 Mails/5","default/INBOX/5 Mails"]
        ]
    },
    {"data":[]}
];
JSON.responses["mail"].criteriaUpdateNewObject=[
    {
        "data":[
            ["INBOX/5 Mails/1","default/INBOX/5 Mails"],["INBOX/5 Mails/2","default/INBOX/5 Mails"],
            ["INBOX/5 Mails/3","default/INBOX/5 Mails"],["INBOX/5 Mails/4","default/INBOX/5 Mails"],
            ["INBOX/5 Mails/5","default/INBOX/5 Mails"],["INBOX/5 Mails/6","default/INBOX/5 Mails"]
        ]
    },
    {"data":[]}
];
JSON.responses["mail"].criteriaUpdateUpdateObject=[
    {
        "data":[
            ["INBOX/5 Mails/1","default/INBOX/5 Mails"],["INBOX/5 Mails/2","default/INBOX/5 Mails"],
            ["INBOX/5 Mails/3","default/INBOX/5 Mails"],["INBOX/5 Mails/4","default/INBOX/5 Mails"],
            ["INBOX/5 Mails/5","default/INBOX/5 Mails"]
        ]
    },
    {"data":[]}
];
JSON.responses["mail"].criteriaUpdateDeleteObject=[
    {
        "data":[
            ["INBOX/5 Mails/1","default/INBOX/5 Mails"],["INBOX/5 Mails/2","default/INBOX/5 Mails"],
            ["INBOX/5 Mails/4","default/INBOX/5 Mails"],["INBOX/5 Mails/5","default/INBOX/5 Mails"]
        ]
    },
    {"data":[]}
];




JSON.waitingCallbacks=new Array();
JSON.prototype = {
    put: function(uri, data, meta, cb, errorHandler, raw) {
        //console.log(data);
        if(data) {
            if(data.length==1) {
                if(data[0].action=="all") {
                    JSON.status=1;
                } else {
                    JSON.status=-1;
                }
            } else if(data.length==2) {
                if(data[0].action=="all" && data[1].action=="updates") {
                    JSON.status=2;
                } else {
                    JSON.status=-1;
                }
            } else {
                JSON.status=-1;
            }
        }
        JSON.waitingCallbacks.push(cb);
        if(JSON.status==-1) {
		   for(var i=0;i<data.length;i++) {
		   	    if(data[i].action=="list") {
                    JSON.status=3;                   
                }
            }
		}
    }
}
JSON.response = function(module,type,cbNumber) {
    if(JSON.waitingCallbacks[cbNumber]) {
        JSON.waitingCallbacks[cbNumber](JSON.responses[module][type]);
    }
};
JSON.clearCallbacks = function() {
    JSON.waitingCallbacks=new Array();
}
JSON.serialize = function(data) {
	if (typeof(data) == "string")
		return "\"" + data.replace(/[\x00-\x1f\\"]/g, function(c) {
			var n = Number(c.charCodeAt(0)).toString(16);
			return "\\u00" + (n.length < 2 ? "0" + n : n);
		}) + "\"";
	if (typeof(data) == "function") return "function";
	if (!data || typeof(data) !== "object") return String(data);
	var strings = new Array(data.length);
	if (data.constructor == Array) {
		for (var i in data) strings[i] = JSON.serialize(data[i]);
		return "[" + strings.join() + "]";
	}
	var j = 0;
	for (var i in data) strings[j++] = "\"" + i + "\":" + JSON.serialize(data[i]);
	return "{" + strings.join() + "}";
}