var tab = new temporary.VTab(newnode("span", 0, 0, [
    addTranslated(_("Subscriptions")),
    newnode("span", { background: "orange", marginLeft: "5px", padding: "2px",
                      MozBorderRadius: "2px", WebkitBorderRadius: "2px",
                      color:"white" }, 0, [ addTranslated("New") ])
]), 0.2);
temporary.folderTabs.addTab(tab);

var sourceTargetMappings = {
    "com.openexchange.subscribe.microformats.infostore.http":
        ["com.openexchange.publish.microformats.infostore.online"],
    "com.openexchange.subscribe.microformats.contacts.http":
        ["com.openexchange.publish.microformats.contacts.online"]
};

var targetSourceMapping = {};

var widgets = {
    input: function(def) { return new ox.UI.Input(noI18n(def.displayName)); },
    password: function(def) {
        return new ox.UI.Password(noI18n(def.displayName));
    },
    checkbox: function(def) {
        return new ox.UI.CheckBox(noI18n(def.displayName));
    },
    text: function(def) { return new ox.UI.Text(noI18n(def.displayName)); },
    link: function(def) {
        var link = new ox.UI.Widget();
        link.default_value = "";
        link.addContent = function() {
            this.anchor = newnode("a", 0,
                { href: this.default_value, target: "_blank" },
                [document.createTextNode(this.default_value)]);
            this.node = this.parent.addCells(noI18n(def.displayName),
                                             this.anchor);
            ox.UI.Widget.prototype.addContent.apply(this, arguments);
        };
        link.set = function(value) {
            this.anchor.href = value;
            this.anchor.firstChild.data = value;
        };
        link.get = function() { return this.anchor.firstChild.data; };
        return link;
    }
};

//create plugin namespace
var com_openexchange_subscribe = {};
com_openexchange_subscribe.sources = {};
com_openexchange_subscribe.modules = {};
com_openexchange_subscribe.mailHead = {};
com_openexchange_subscribe.tab = tab;
var addedSubscription = null;

com_openexchange_subscribe.fnButton = function (button, fn_click){
	 var node = newnode("div",{flt:"left", width:"14em"},{ className:"fakeButton background-color-default cursorPointer whiteground"},[newnode("div",{},{className:"fakeButtonBottom"},[newnode("div",{},{className:"fakeButtonLeft"},[newnode("div",{},{className:"fakeButtonRight"},[
         newnode("div",{},{className:"fakeButtonTopLeft"},[newnode("div",{},{className:"fakeButtonTopRight"},[newnode("div",{},{className:"fakeButtonBottomLeft"},[newnode("div",{},{className:"fakeButtonBottomRight"},[button])])])])
      ])])])]);
	 
	if(fn_click)
		addDOMEvent(node, "click", fn_click);
	return node;
};

/*
 * Returns a table node for the mail Header with a subscribe button
 * @param view - {string} - mail view i.e hsplit or vsplit
 * 
 * */
com_openexchange_subscribe.getTable = function(view) {
	
	com_openexchange_subscribe.mailHead[view] = newnode("table",{ display: "none", padding: "0 0.5em" },{ id:"mail."+view+".detail.header.puburl" , border : "0", width:"100%", className:"smallpopupborderbottom border-color-design mail-imip-content" },[
		newnode("tbody",null,null,[
			newnode("tr",null,null,[
				newnode("td",{padding: "5px"},null,[
					newnode("img",{width:"16", height:"16", align:"absmiddle"},{ src : getFullImgSrc("img/dummy.gif") },[])
				]),
				newnode("td",{ width: "100%" },{className:"font-style-big-headline"},[
					addTranslated("This mail contains an URL to a publication.")]),
				newnode("td",null,null,[
					com_openexchange_subscribe.fnButton(addTranslated("Subscribe this publication..."), com_openexchange_subscribe.ox_subcribePubURL)
				])
			])
		])
	]);
	
	return com_openexchange_subscribe.mailHead[view];
}


/*
 * Automatic subscript an URL in a Publish E-Mail, US4127
 * @param mailmessage - {object} - currently opened message in hsplit or vsplit view
 * @param view - {string} - mail view i.e hsplit or vsplit
 * 
 * */
com_openexchange_subscribe.checkSubscribeButton = function (mailmessage, view) {
    
    var pubURL = mailmessage.headers["X-OX-PubURL"] || "";
	var pubType = /^(\w+),(.*)$/.exec(mailmessage.headers["X-OX-PubType"])
	           || [, "", ""];
	var pubSource = targetSourceMapping[pubType[2]];
	
	com_openexchange_subscribe.getModuleType = function() {
		return pubType[1];
	}
	
    com_openexchange_subscribe.ox_subcribePubURL = function(e) {
        
		if (pubURLFolderpopupFrame.style.display == "none") {

            var currentModuleType = com_openexchange_subscribe.getModuleType();
            removeChildNodes(pubURLFolderpopup);
            var tree = new cFolderTree(pubURLFolderpopup,
                function(folder) {
                    // callback for click in folder tree
                    pubURLFolderpopupFrame.style.display = "none";
                    removeDOMEvent(body, "click", bodyPubClick);

                    var sFolderId = folder.oxfolder.data.id;
                    var oCacheFolder = oMainFolderTree.get_folder_by_node_id(
                        oMainFolderTree.getDOMID(sFolderId));
                    setActiveFolder(sFolderId);
                    
                    //switch view to subscribe tab
                    setTabLists(fdpropsTabsList, fdpropsPanelsList,
                                fdpropsEventList);
                    viewProperties(oMainFolderTree.nodes[
                        oMainFolderTree.getDOMID(sFolderId)], false);
                    temporary.folderTabs.showTab(com_openexchange_subscribe.tab);
                    addedSubscription = { source: pubSource };
                    addedSubscription[pubSource] = { url: pubURL };
                }, false, oMainFolderTree.cache,
                optFolderState.getState(currentModuleType+".folder"));
            tree.enabled_modules = {};
            tree.enabled_modules[currentModuleType] = true;
            	
            //load folder tree in small popup
            tree.load();
            tree.display_folder(config.folder[currentModuleType]);
            tree.setSaveConfiguration(optFolderState);
            pubURLFolderpopupFrame.style.display = "block";
            treePubURLOpened = true;
            addDOMEvent(body, "click", bodyPubClick);
        }
		
	};
	
	//check if table node in mail head already created
	if(!com_openexchange_subscribe.mailHead[view]) {
		com_openexchange_subscribe.getTable(view);
		$("mail." + view + ".detail.header.phishing_protection").parentNode.insertBefore(com_openexchange_subscribe.mailHead[view], $("mail." + view + ".detail.header.phishing_protection"));
	}
	
	var treePubURLOpened = false;
	function bodyPubClick() {
        if (treePubURLOpened) {
        	treePubURLOpened = false;
            return;
        }
        removeChildNodes(pubURLFolderpopup);
        pubURLFolderpopupFrame.style.display = "none";
        removeDOMEvent(body, "click", bodyPubClick);
    }
	
	var pubURLFolderpopupFrame = newnode("div",
        { position: "absolute", display: "none", zIndex: 21,
          height: "19em", width: "18em", top: "50px", right: "185px",
          overflow: "auto" },
        { className: "background-color-content smallpopupborder " +
                     "border-color-design" });
	
	var pubURLFolderpopupHead = newnode("div",
            { height: "auto", padding: "5px" },
            { className: "background-color-content " +
                         "border-color-design" });
	
	var pubURLFolderpopup = newnode("div",
            { height: "auto", width: "18em",
              overflow: "auto" },
            { className: "background-color-content " +
                         "border-color-design" });
	
	pubURLFolderpopupHead.appendChild(document.createTextNode("Subscribe into:"/*i18n*/));
	pubURLFolderpopupFrame.appendChild(pubURLFolderpopupHead);
	pubURLFolderpopupFrame.appendChild(pubURLFolderpopup);
	
	$("mail." + view).appendChild(pubURLFolderpopupFrame);
	
    addDOMEvent(pubURLFolderpopup, "click", function(e) {
        cancelBubbling(e);
    });
	
	
    // check if mail contains a publication URL 
    if (pubURL && pubSource) {
        com_openexchange_subscribe.mailHead[view].style.display = "";
    } else {
        com_openexchange_subscribe.mailHead[view].style.display = "none";
    }
};

//register to mail load, this will triggert every time a mail is opened
register("OX_Mail_load",com_openexchange_subscribe.checkSubscribeButton);

// get modules
ox.JSON.get(AjaxRoot + "/subscriptionSources/?action=all"
    + "&columns=id,displayName,icon,module,formDescription&session=" + session,
    function(reply) {
        for (var i in reply.data) {
            var s = reply.data[i];
            var source = { id: s[0], displayName: s[1], icon: s[2],
                           module: s[3], formDescription: s[4] };
            com_openexchange_subscribe.sources[source.id] = source;
            var map = sourceTargetMappings[source.id];
            for (var i = 0; map && i < map.length; i++) {
                targetSourceMapping[map[i]] = source.id;
            }
            var module = com_openexchange_subscribe.modules[source.module];
            if (!module) {
                module = com_openexchange_subscribe.modules[source.module] = {};
            }
            module[source.id] = source;
        }
});

//is active?
com_openexchange_subscribe.supportsFolder = function(folder) {
    return Boolean(
        com_openexchange_subscribe.modules && 
        folder && folder.data &&
        folder.data.module in com_openexchange_subscribe.modules && 
        folder.data.own_rights & (127 << 14)
    );
};

//add menu item
// onClick open the tab subscribe of the folder property
com_openexchange_subscribe.folderMenuItem = new MenuItem("Subscribe" /*i18n*/, 
    function() {
        setTabLists(fdpropsTabsList, fdpropsPanelsList, fdpropsEventList);
        viewProperties(this.getContext().data, false);
        temporary.folderTabs.showTab(com_openexchange_subscribe.tab);
    }
);


//set its "onShow" handler
com_openexchange_subscribe.folderMenuItem.onShow = function() {
    // get folder
    var folder = oMainFolderTree.get_folder_by_node_id(this.getContext().data.id);
    // support for this folder?
    this.setVisible(com_openexchange_subscribe.supportsFolder(folder.oxfolder));
};
com_openexchange_subscribe.folderMenuItem.getAutoEnabled = function() {
    // get folder
    var folder = oMainFolderTree.get_folder_by_node_id(this.getContext().data.id);
    // support for this folder?
    return com_openexchange_subscribe.supportsFolder(folder.oxfolder);
};

var folderTypeSeperator = new MenuSeparator();
globalContextMenus.newFolderType.addItem(folderTypeSeperator);

var abo_folder_menu = new PopupMenu();

var new_abo_folder = new MenuItem("Subscribe"/*i18n*/, abo_folder_menu);

globalContextMenus.newFolderType.addItem(new_abo_folder);

/*
 * Listener for subscribe submenu opens in RMB Folder
 * append menuitems to the subscribe menuitem, with possible subscribe services (i.e. facebook or gmx.de)
 * */
new_abo_folder.onShow = function() {
	var folder = oMainFolderTree.get_folder_by_node_id(this.getContext().data.id);
	
	abo_folder_menu.removeAllItems();
	var availableTypes = com_openexchange_subscribe.modules[folder.oxfolder.data.module];
	
	var visible = !isEmpty(availableTypes);
	new_abo_folder.setVisible(visible);
	folderTypeSeperator.setVisible(visible);
	
	for (var i in availableTypes) (function(type) {
	    var def = availableTypes[type];
	    
	     var item = new MenuItem(def.displayName,
	        function() { new_subscribed_folder(this.getContext().data, folder.oxfolder.data.module, def.displayName); });
	    item.onShow = function() {
	        this.setEnabled(   true);
	    };
	    abo_folder_menu.addItem(item);
	})(i);
}

var dataSubscribeReply;

/*
 * RMB for subscribe folder
 * Appends a submenu "subscribe" to the RMB Foldermenu
 * @param parentFolderNode - {node} - clicked folder
 * @param folderModule - {string} - module of the clicked folder (i.e. contacts)
 * @param folderTitle - {string} - name of the subscribe service (i.e. facebook or gmx.de)
 * 
 * */
var new_subscribed_folder = function(parentFolderNode, folderModule, folderTitle) {
	
	function uniqueName(aChildren,sName) {
		for (var nChild in aChildren) {			
			var oCurrChild = oMainFolderTree.get_folder_by_node_id(parentFolderNode.children[nChild].id);
			if(sName == oCurrChild.oxfolder.data.title)
				return false;		
		}
		return true;
	}
	
	var tmpFolderTitle = folderTitle;
	
	var nCounter = 1;
    while(!uniqueName(parentFolderNode.children, tmpFolderTitle)) {
    	tmpFolderTitle = folderTitle + " " + nCounter;     
        nCounter++;
    }
	var data = { "title": tmpFolderTitle,
	   		"module":folderModule,	
	   		"permissions": [{ bits: 403710016, // all admin
	   		                  entity: configGetKey("identifier"),
	   		                  group: false }],
	   		"subscribed":1 };
	var sParentId = parentFolderNode.id;
	var aSplitedId = sParentId.split('$')[1];
	ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + aSplitedId, data,
			function(reply) {
				dataSubscribeReply = reply;
				if (oMainFolderTree){
					oMainFolderTree.update(null, true, function(){
						oMainFolderTree.nodes[sParentId].setOpen(true, function() {
								var sFolderId = dataSubscribeReply.data;
								var oCacheFolder = oMainFolderTree.get_folder_by_node_id(oMainFolderTree.getDOMID(sFolderId));
								setActiveFolder(sFolderId);
								setTabLists(fdpropsTabsList, fdpropsPanelsList, fdpropsEventList);						
								viewProperties(oMainFolderTree.nodes[oMainFolderTree.getDOMID(sFolderId)], false);
						        temporary.folderTabs.showTab(com_openexchange_subscribe.tab);
						        com_openexchange_subscribe.tab.addNew({});
						        if(typeof com_openexchange_subscribe.tab.children[0].children[0].combobox != "undefined") {
						        	com_openexchange_subscribe.tab.children[0].children[0].combobox.setValue(folderTitle);
						        }
							}
						);
					});
				}
				
			},
        	function(reply) {
				drawError(_("Unable to create a new subscription folder."));
            	return true;
            });
}


globalContextMenus.extended_folder_menu.addItem(com_openexchange_subscribe.folderMenuItem);

/* Refresh Button for subscribe folder */
com_openexchange_subscribe.generate_refresh_button = function(modulename) {
	
	registerView(modulename,
		null,
		function() {
	    	com_openexchange_subscribe.func_button_refresh_subscription_folder(modulename);
		},
		null,
		null,
		function() {
	    	com_openexchange_subscribe.func_button_refresh_subscription_folder(modulename); 
		}
	);	

	menuarrows[modulename]["menu_subscribe_refresh"]=new Array();
	var menuRefresh = MenuNodes.createSmallButtonContext(modulename+".menu_subscribe_refresh",
	    _("Subscriptions"), modulename);
	MenuNodes.createSmallButton(menuRefresh, modulename+".menu_subscribe_refresh.button", _("Refresh"),
	    getFullImgSrc("img/toolbar/tb_loading.gif"),
	    getFullImgSrc("img/toolbar/ox_animated.gif"),
	    function() { refreshFolder(); });
	addMenuNode(menuRefresh.node, MenuNodes.DYNAMIC, 2);
	changeDisplay(modulename,modulename+".menu_subscribe_refresh");
	
};


/* Refresh Button for subscribe folder */

com_openexchange_subscribe.generate_refresh_button("contacts");
com_openexchange_subscribe.generate_refresh_button("infostore");
com_openexchange_subscribe.generate_refresh_button("calendar");





/*
 * test if this folder a subscribed folder, so enable refresh button in the toolbar
 * */
com_openexchange_subscribe.func_button_refresh_subscription_folder = function() {
	com_openexchange_subscribe.oFolder = oMainFolderTree.cache.find_folder(activefolder);
	var subscription_flag = com_openexchange_subscribe.oFolder.oxfolder.data["com.openexchange.subscribe.subscriptionFlag"];
	if(subscription_flag) {
		$(activemodule+'.menu_subscribe_refresh').style.display ="";	
	} else {
		$(activemodule+'.menu_subscribe_refresh').style.display ="none";
	}
};



function refreshFolder(callback) {
    ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&folder=" + activefolder + "&session=" + session,
        function() {
            var module = activemodule;
            if (module == "calendar") {
                storageCache.update();
            } else {
                OXCache.newRequest(null, activemodule,
                    { criteria: { folder_id: activefolder } },
                    null, null, true);
            }
            storageCache.update();
            if(callback)
            	callback();
        });
}

tab.init = function() {
    var sources, modules, onInit;
    
    // copy
    sources = com_openexchange_subscribe.sources;
    modules = com_openexchange_subscribe.modules;
    
    // visible?
    for (var s in sources) {
        if (temporary.folderTabs.folder.module == sources[s].module) {
            tab.setVisible(true);
            break;
        }
    }
    
    var old_enter = temporary.folderTabs.enter;
    temporary.folderTabs.enter = function() {
        tab.setVisible(Boolean(modules && this.folder.module in modules &&
                               (this.folder.own_rights & (127 << 14)) >= (2 << 14)) &&
                               	computePerm(this.folder.own_rights,0) >= 2);
        old_enter.call(this);
        if (sources) initSelect(); else onInit = initSelect;
    };
    
    // Left panel
    var selection = new Selection();
    var grid = new LiveGrid([{
        text: _("Name"),
        index: 1,
        clear: LiveGrid.makeClear(""),
        set: LiveGrid.defaultSet
    }], selection);
    grid.emptylivegridtext = _("No subscriptions configured");
    tab.list = grid;
    
    var storage = new Storage(0, []);

    tab.enableList = function() {
        ox.JSON.get(AjaxRoot +
            "/subscriptions?action=all&columns=id,displayName&folder=" +
            this.parent.folder.id + "&entityModule=" +
            this.parent.folder.module + "&session=" + session,
            function(reply) {
                storage.remove(0, storage.ids.length);
                storage.append(reply.data);
                grid.enable(storage);
                if (addedSubscription) {
                    tab.addNew({});
                    tab.set(addedSubscription);
                    addedSubscription = null;
                } else if (reply.data.length < 1) {
                	tab.addNew({});
                } else {
                	grid.selection.click(0);
                }
            });
    };
        
    function load(id, cont) {
        ox.JSON.get(AjaxRoot + "/subscriptions?action=get&id=" + id +
            "&session=" + session, function(reply) { cont(reply.data); });
    }

    tab.load = function(cont) { load(selection.getSelected()[0], cont); };
    
    function refresh(id, callback) {
        ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id=" + id +
            "&folder=" + tab.parent.folder.id + "&session=" + session,
            function() {
                var module = tab.parent.folder.module;
                if (module == "calendar") {
                    storageCache.update();
                } else {
                    OXCache.newRequest(null, tab.parent.folder.module,
                        { criteria: { folder_id: tab.parent.folder.id } },
                        null, null, true);
                }
                callback();
            });
    }
    
    // temporary fix for bug #16710
    // @todo: needs to be re-viewed by vp
    tab.leave = function() {
    	grid.selection.reset();
    	tab.cancelView();
    }
    
    tab.save = function(data, cont) {
    	// temporary fix for bug #16710
    	// @todo: needs to be re-viewed by vp
    	if (isEmpty(data)) {
    		return;
    	}
    	
        if ("id" in data) {
            ox.JSON.put(AjaxRoot + "/subscriptions/?action=update&session=" +
                session, data, function(reply) {
                    refresh(data.id, function() {
                        load(data.id, function(data) {
                            storage.localUpdate([data.id], function(old) {
                                return [data.id, data.displayName];
                            });
                            cont(data);
                        });
                    });
                });
        } else {
            ox.JSON.put(AjaxRoot + "/subscriptions/?action=new&session=" +
                session, data, function(reply) {
                    refresh(reply.data, function() {
                        load(reply.data, function(data) {
                            storage.append([[data.id, data.displayName]]);
                            cont(data);
                        });
                    });
                });
        }
    };
    
    menuarrows[tab.viewID] = {};

    var menu = MenuNodes.createSmallButtonContext("subscribe.subscriptions",
        _("Subscriptions"));
    MenuNodes.createSmallButton(menu, "subscribe.subscriptions.add", _("Add"),
        getFullImgSrc("img/menu/add_category.gif"),
        getFullImgSrc("img/menu/add_category_d.gif"),
        function() { tab.addNew({}); });
    MenuNodes.createSmallButton(menu, "subscribe.subscriptions.remove", _("Remove"),
        getFullImgSrc("img/menu/remove_category.gif"),
        getFullImgSrc("img/menu/remove_category_d.gif"), confirmDelete);
    addMenuNode(menu.node, MenuNodes.FIXED, 31);
    changeDisplay(tab.viewID, "subscribe.subscriptions");
    

    menuarrows[tab.viewID] = {};
    register("OX_SELECTED_ITEMS_CHANGED", function() {
        var deleteenabled = selection.count > 0;
        menuglobalzaehler = 0;
        menuarrows[tab.viewID]["subscribe.subscriptions"] = [];
        menu_display_contents(tab.viewID, "subscribe.subscriptions", true,
            "subscribe.subscriptions.add");
        menu_display_contents(tab.viewID, "subscribe.subscriptions", deleteenabled,
            "subscribe.subscriptions.remove");
    });

    function confirmDelete() {
        if (!selection.count) return;
        newConfirm(ngettext("Delete Subscription", "Delete Subscriptions",
                            selection.count)(),
            ngettext(
                "Are you sure you want to delete the selected subscription?",
                "Are you sure you want to delete the selected subscriptions?",
                selection.count)(),
            AlertPopup.YES | AlertPopup.NO, null, null, handleDelete);
    }
    function handleDelete() {
        var ids = selection.getSelected();
        ox.JSON.put(AjaxRoot + "/subscriptions?action=delete&session=" + session,
            ids, function(reply) { storage.removeIDs(ids); });
    }

    
    

    // Right panel
    var select = new ox.UI.ComboBox(_("Source"));
    select.changed = function() { entry.updateSelect(); };
    if (sources) initSelect(); else onInit = initSelect;
    function initSelect() {
        var module = tab.parent.folder.module;
        var ids = [], names = [];
        for (var i in sources) {
            var m = sources[i].module;
            if (m == module) {
                ids.push(i);
                names.push(sources[i].displayName);
            }
        }
        select.setEntries(ids, names);
        onInit = undefined;
    }
    
    var entry = new ox.UI.Container();
    entry.addContent = function(node_id) {
        this.childWidth = this.parent.childWidth;
        this.table = newnode("div");
        this.node = this.parent.addRow(this.table);
        ox.UI.Container.prototype.addContent.apply(this, arguments);
    };
    entry.addRow = ox.Configuration.VSplit.prototype.addRow;
    entry.addCells = ox.Configuration.VSplit.prototype.addCells;
    entry.addWidget(select);
    
    entry.updateSelect = function() {
        for (var i = this.children.length - 1; i > 0; i--) {
            this.deleteWidget(entry.children[i]);
        }
        var id = select.get();
        if (id && (id in sources)) {
            var defs = sources[id].formDescription;
            for (var i = 0; i < defs.length; i++) {
                var def = defs[i];
                if (widgets[def.widget]) {
                    var widget = widgets[def.widget](def);
                    if ("defaultValue" in def)
                        widget.default_value = def.defaultValue;
                    this.addWidget(widget, def.name);
                }
            }
        }
    };
    var defaultSet = entry.set;
    entry.set = function(value) {
        this.id = value.id;
        select.set(value.source);
        this.updateSelect();
        defaultSet.call(this, value[value.source]);
    };
    var defaultGet = entry.get;
    entry.get = function() {
        var id = select.get();
        if (!id) return;
        var value = {
            source: id,
            folder: tab.parent.folder.id,
            entityModule: tab.parent.folder.module,
            entity: { folder: tab.parent.folder.id }
        };
        value[value.source] = defaultGet.call(this);
        if (this.id) value.id = this.id;
        return value;
    };
    tab.addWidget(entry, ox.Configuration.Group.NoField);
    var subscriptiondur = new ox.UI.Text("");
    subscriptiondur.addContent = function() {
    	this.text = newnode("div",{lineHeight:"1.2em",marginTop:"1.5em"});
    	this.text.innerHTML = _("<b>Approximate Duration for Subscriptions</b><br/><br/>Subscribing to contacts that are not delivered by another Open-Xchange Server (i.e. OXMF) may take some time. <br/>Importing 100 contacs from Xing takes about 5 minutes for example.<br/><br/>We are continually improving this functionality. Future releases will work significantly faster.");
        this.node = this.parent.addRow(this.text,true);
        ox.UI.Widget.prototype.addContent.apply(this, arguments);
    };
    tab.addWidget(subscriptiondur);
};