var tab = new temporary.VTab(newnode("span", 0, 0, [
    addTranslated(_("Publications")),
    newnode("span", { background: "orange", marginLeft: "5px", padding: "2px",
                      MozBorderRadius: "2px", WebkitBorderRadius: "2px",
                      color:"white" }, 0, [ addTranslated("New") ])
]), 0.2);
temporary.folderTabs.addTab(tab);
var widgets = {
    input: function(def) { return new ox.UI.Input(noI18n(def.displayName)); },
    password: function(def) {
        return new ox.UI.Password(noI18n(def.displayName));
    },
    checkbox: function(def) {
        return new ox.UI.CheckBox(noI18n(def.displayName));
    },
    text: function(def) { return new ox.UI.Text(noI18n(def.displayName)); },
    link: function(def) {
        var link = new ox.UI.Widget();
        link.default_value = "";
        link.addContent = function() {
            this.anchor = newnode("a", 0,
                { href: this.default_value, target: "_blank" },
                [document.createTextNode(this.default_value)]);
            this.node = this.parent.addCells(noI18n(def.displayName),
                                             this.anchor);
            ox.UI.Widget.prototype.addContent.apply(this, arguments);
        };
        link.set = function(value) {
            this.anchor.href = value;
            this.anchor.firstChild.data = value;
        };
        link.get = function() { return this.anchor.firstChild.data; };
        return link;
    }
};

// create plugin namespace
var com_openexchange_publish = {};
com_openexchange_publish.targets = {};
com_openexchange_publish.modules = {};
com_openexchange_publish.tab = tab;

// get modules
ox.JSON.get(AjaxRoot + "/publicationTargets/?action=all" +
    "&columns=id,displayName,icon,module,formDescription&session=" + session, 
    function(reply) {
        for (var i in reply.data) {
            var t = reply.data[i];
            var target = { id: t[0], displayName: t[1], icon: t[2],
                           module: t[3], formDescription: t[4] };
            com_openexchange_publish.targets[target.id] = target;
            var module = com_openexchange_publish.modules[target.module];
            if (!module) {
                module = com_openexchange_publish.modules[target.module] = {};
            }
            module[target.id] = target;
        }
    }
);

// is active?
com_openexchange_publish.supportsFolder = function(folder) {
    return Boolean(
        com_openexchange_publish.modules && 
        folder && folder.data &&
        folder.data.module in com_openexchange_publish.modules && 
        folder.data.own_rights & (1 << 28)
    );
};

// add menu item
com_openexchange_publish.folderMenuItem = new MenuItem("Publish" /*i18n*/, 
    function() { 
        setTabLists(fdpropsTabsList, fdpropsPanelsList,fdpropsEventList);
        viewProperties(this.getContext().data, false);
        temporary.folderTabs.showTab(com_openexchange_publish.tab);
    }
);

// set its "onShow" handler
com_openexchange_publish.folderMenuItem.onShow = function() {
    // get folder
    var folder = oMainFolderTree.get_folder_by_node_id(this.getContext().data.id);
    // support for this folder?
    this.setVisible(com_openexchange_publish.supportsFolder(folder.oxfolder));
    return this.visible && this.enabled;
};
com_openexchange_publish.folderMenuItem.getAutoEnabled = function() {
    // get folder
    var folder = oMainFolderTree.get_folder_by_node_id(this.getContext().data.id);
    return com_openexchange_publish.supportsFolder(folder.oxfolder);
};
globalContextMenus.extended_folder_menu.addItem(com_openexchange_publish.folderMenuItem);

tab.init = function() {

    var targets, modules, onInit;
    
    // copy
    targets = com_openexchange_publish.targets;
    modules = com_openexchange_publish.modules;
    
    // visible?
    for (var t in targets) {
        if (temporary.folderTabs.folder.module == targets[t].module) {
            tab.setVisible(true);
            break;
        }
    }
        
    var old_enter = temporary.folderTabs.enter;
    temporary.folderTabs.enter = function() {
        var pubActive = Boolean(
            modules && this.folder.module in modules && this.folder.own_rights & (1 << 28)
        );
        tab.setVisible(pubActive);
        old_enter.call(this);
        if (targets) initSelect(); else onInit = initSelect;
    };
    
    // Left panel
    var selection = new Selection();
    var grid = new LiveGrid([{
        text: _("Name"),
        index: 1,
        clear: LiveGrid.makeClear(""),
        set: LiveGrid.defaultSet
    }], selection);
    grid.emptylivegridtext = _("No publications configured");
    tab.list = grid;
    
    var storage = new Storage(0, []);

    tab.enableList = function() {
        ox.JSON.get(AjaxRoot +
            "/publications?action=all&columns=id,displayName&folder=" +
            this.parent.folder.id + "&entityModule=" +
            this.parent.folder.module + "&session=" + session,
            function(reply) {
                storage.remove(0, storage.ids.length);
                storage.append(reply.data);
                grid.enable(storage);
                if(reply.data.length < 1) {
                	tab.addNew({});
                } else {
                	grid.selection.click(0);
                }
            });
    };
    
    function load(id, cont) {
        ox.JSON.get(AjaxRoot + "/publications?action=get&id=" + id +
            "&session=" + session, function(reply) { cont(reply.data); });
    }

    tab.load = function(cont) { load(selection.getSelected()[0], cont); };
    
    // temporary fix for bug #16710
    // @todo: needs to be re-viewed by vp
    tab.leave = function() {
    	grid.selection.reset();
    	tab.cancelView();
    }
    
    tab.save = function(data, cont) {
    	// temporary fix for bug #16710
    	// @todo: needs to be re-viewed by vp
    	if (isEmpty(data)) {
    		return;
    	}    	
    	
        if ("id" in data) {
            ox.JSON.put(AjaxRoot + "/publications/?action=update&session=" +
                session, data, function(reply) {
                    load(data.id, function(data) {
                        storage.localUpdate([data.id], function(old) {
                            return [data.id, data.displayName];
                        });
                        cont(data);
                    });
                });
        } else {
            ox.JSON.put(AjaxRoot + "/publications/?action=new&session=" +
                session, data, function(reply) {
                    load(reply.data, function(data) {
                        storage.append([[data.id, data.displayName]]);
                        cont(data);
                    });
                });
        }
    };
    
    menuarrows[tab.viewID] = {};
    var menu = MenuNodes.createSmallButtonContext("publish.publications",
        _("Publications"));
    MenuNodes.createSmallButton(menu, "publish.publications.add", _("Add"),
        getFullImgSrc("img/menu/add_category.gif"),
        getFullImgSrc("img/menu/add_category_d.gif"),
        function() { tab.addNew({}); });
    MenuNodes.createSmallButton(menu, "publish.publications.remove", _("Remove"),
        getFullImgSrc("img/menu/remove_category.gif"),
        getFullImgSrc("img/menu/remove_category_d.gif"), confirmDelete);
    addMenuNode(menu.node, MenuNodes.FIXED, 31);
    changeDisplay(tab.viewID, "publish.publications");
    
    menuarrows[tab.viewID] = {};
    register("OX_SELECTED_ITEMS_CHANGED", function() {
        var deleteenabled = selection.count > 0;
        menuglobalzaehler = 0;
        menuarrows[tab.viewID]["publish.publications"] = [];
        menu_display_contents(tab.viewID, "publish.publications", true,
            "publish.publications.add");
        menu_display_contents(tab.viewID, "publish.publications", deleteenabled,
            "publish.publications.remove");
    });

    function confirmDelete() {
        if (!selection.count) return;
        newConfirm(ngettext("Delete Publication", "Delete Publications",
                            selection.count)(),
            ngettext(
                "Are you sure you want to delete the selected publication?",
                "Are you sure you want to delete the selected publications?",
                selection.count)(),
            AlertPopup.YES | AlertPopup.NO, null, null, handleDelete);
    }
    function handleDelete() {
        var ids = selection.getSelected();
        ox.JSON.put(AjaxRoot + "/publications?action=delete&session=" + session,
            ids, function(reply) {
                storage.removeIDs(ids);
                oMainFolderTree.cache.updateFolders(
                    [temporary.folderTabs.folder.id],
                    function() {
                        oMainFolderTree.load_view(
                            oMainFolderTree.cache.folders.root,
                            oMainFolderTree.tree, true, false);
                    }); 
            });
    }

    // Right panel
    var select = new ox.UI.ComboBox(_("Target"));
    select.changed = function() { entry.updateSelect(); };
    if (targets) initSelect(); else onInit = initSelect;
    function initSelect() {
        var module = com_openexchange_publish.tab.parent.folder.module;
        var ids = [], names = [];
        for (var i in targets) {
            var m = targets[i].module;
            if (m == module) {
                ids.push(i);
                names.push(targets[i].displayName);
            }
        }
        select.setEntries(ids, names);
        onInit = undefined;
        // Done!
//        if (com_openexchange_publish.tab.initSelectDone) {
//            com_openexchange_publish.tab.initSelectDone();
//        }
    }
    
    var entry = new ox.UI.Container();
    entry.addContent = function(node_id) {
        this.childWidth = this.parent.childWidth;
        this.table = newnode("div");
        this.node = this.parent.addRow(this.table);
        ox.UI.Container.prototype.addContent.apply(this, arguments);
    };
    entry.addRow = ox.Configuration.VSplit.prototype.addRow;
    entry.addCells = ox.Configuration.VSplit.prototype.addCells;
    entry.addWidget(select);
    
    entry.updateSelect = function() {
        for (var i = this.children.length - 1; i > 0; i--) {
            this.deleteWidget(entry.children[i]);
        }
        var id = select.get();
        if (id && (id in targets)) {
            var defs = targets[id].formDescription;
            for (var i = 0; i < defs.length; i++) {
                var def = defs[i];
                var widget = widgets[def.widget](def);
                this.addWidget(widget, def.name);
                if ("defaultValue" in def) {
                    widget.default_value = def.defaultValue;
                    widget.set(def.defaultValue);
                }
            }
        }
    };
    var defaultSet = entry.set;
    entry.set = function(value) {
        this.id = value.id;
        select.set(value.target);
        this.updateSelect();
        defaultSet.call(this, value[value.target]);
    };
    var defaultGet = entry.get;
    entry.get = function() {
        var id = select.get();
        if (!id) return;
        var value = {
            target: id,
            entityModule: tab.parent.folder.module,
            entity: { folder: tab.parent.folder.id }
        };
        value[value.target] = defaultGet.call(this);
        if (this.id) value.id = this.id;
        return value;
    };
    tab.addWidget(entry, ox.Configuration.Group.NoField);


    // Option for sending an e-mail about this subscription
	var info_mail_button = new ox.UI.Button(_("Send E-Mail about this publication"));
	info_mail_button.click = function() {
	    // compose mail
	    var pub_url = this.url || "";
	    ox.api.mail.compose({
	        params: {
	            subject: _("Publication") /*i18n*/
	        },
	        data: {
	            headers: {
                    "X-OX-PubURL": pub_url,
                    "X-OX-PubType": this.pubType
                },
	            aInfoMailAttachmentLink: [{
	                content_type: "text/plain",
	                content: pub_url
                }]
	        }
	    });
	}
	var on_off_switcher = { 
		get: function(data, value) {},
	    set: function(data) {
            info_mail_button.pubType = data.entityModule + "," + data.target;
            var url = null;
            if (data.target && data[data.target]) {
                url = data[data.target].url;
                info_mail_button.url = url;
            }
			info_mail_button.setEnabled(!isEmpty(url));
		}
	};
	tab.addWidget(info_mail_button, on_off_switcher);


    var privacy = new ox.UI.Button("");
    privacy.addContent = function() {
    	this.text = newnode("div",{lineHeight:"1.2em",marginTop:"1.5em"});
    	this.text.appendChild(newnode("p", { fontWeight: "bold" }, 0, [ document.createTextNode(_("Attention"))]));
    	this.text.appendChild(newnode("p", 0, 0, [ document.createTextNode( _("The published data will be accessible to everyone on the Internet. Please consider, which data you want to publish.") )]));
    	
    	this.text.appendChild(newnode("p", { fontWeight: "bold" }, 0, [ document.createTextNode(_("Privacy Notice"))]));
    	var tmpText = _("When using this publish feature, you as the current owner of the data are responsible for being careful with privacy rules and for complying with legal obligations (Copyright, Privacy Laws).\n\nEspecially when publishing personal data you are the responsible party according to the Federal Data Protection Act (BDSG, Germany) or other Privacy Acts of your country.\n\nAccording to European and other national regulations you as the responsible party are in charge of data economy, and must not publish or forward personal data without the person’s consent.\n\nBeyond legal obligations, Open-Xchange would like to encourage extreme care when dealing with personal data. Please consider carefully where you store and to whom you forward personal data. Please ensure appropriate access protection, e.g. by proper password protection.");
    	var nText = String(tmpText).split("\n");
        for (var i in nText) {
        	this.text.appendChild(document.createTextNode(nText[i]));
        	this.text.appendChild(newnode("br"));
        }
    	this.node = this.parent.addRow(this.text,true);
        ox.UI.Widget.prototype.addContent.apply(this, arguments);
    };
    tab.addWidget(privacy, ox.Configuration.Group.NoField);
};