/* each folder tree should use this cache */
function ox_folder_cache(){	
	/* register all events here */	
	this.events = new Events();
	/* contains all folders which are stored hierarchically in storagecaches */
	this.folders = {"root":{children:null,parent:null,oxfolder:null}};
	var Self = this;
	this.columns = "1,301,300,307,304,306,302,305,308,311,2,314,313,315,3010,3020";
	this.fast_access = new Object();
	this.timestamp = 0;
	this.treeID = configGetKey("modules.folder.tree") || 0;
}

ox_folder_cache.prototype = {

	/* load the root folders or all folder defined in oState */
	load_folders : function (oState, join_param, bReplace) {
        var Self = this;
        this.loading = [];
        var join = new Join(join_param.add(function() {
            join_param.arg = this.arg;
            var l = Self.loading;
            Self.loading = null;
            for (var i = 0; i < l.length; i++) l[i]();
        }));
        var join_fn = join.add( function (arg){ join.arg = arg; } );
		if (Self.folders["root"].children != null && !bReplace) {
			for (var i = 0; i < Self.folders["root"].children.length; i++) {											
				if(oState && oState[Self.folders["root"].children[i].oxfolder.data.id]) {
					Self.load_subfolders(
					       Self.folders["root"].children[i].oxfolder.data.id,
					       Self.folders["root"].children[i],
					       oState[nfldrN], join, bReplace 
				    );
				}														
			}		
			join_fn(Self.folders);
		} else {
			var locJson = new JSON();
            var action = this.treeID == 1 ? "list&parent=1&all=1" : "root";
            locJson.get(AjaxRoot + "/folders?action=" + action
                + "&columns=" + this.columns + "&tree=" + this.treeID
                + "&session=" + session, null,
                function(arg) {		
                    Self.folders["root"].children = [];
                    Self.timestamp = arg.timestamp;
                    for (var nfldr=0; nfldr<arg.data.length; nfldr++) {
                        var id = arg.data[nfldr][0];
                        var child = Self.fast_access[id] = {
                            oxfolder: new ox_folder(arg.timestamp,
                                                    arg.data[nfldr]),
                            parent: Self.folders.root,
                            children: null
                        };
                        Self.folders.root.children.push(child);
                        if(oState && oState[id]) {
                            Self.load_subfolders(id, child, oState[id],
                                                 join, bReplace);
                        }														
                    }		
                    join_fn(Self.folders);							
                });		
		}
	},
	
	do_load_subfolders : function (nId,refer,oState,callback,bReplace){
		this.load_subfolders(nId, refer, oState, 
		      new Join(
		              function() {
		                  callback(this.arg);
		              }
		      ), bReplace);
	},
	
	/*loads subfolders from server*/
	load_subfolders : function (nId, refer, oState, join_param, bReplace) {
		var Self = this;
		
		var join_fn = join_param.add(
		      function (arg) {
		          join_param.arg = arg;
		      }
		);
	
		if (refer.children != null && !bReplace) {
            for (var i = 0; i < refer.children.length; i++) {
                var id = refer.children[i].oxfolder.data.id;
                if(oState && oState[id]) {
                    Self.load_subfolders(id, refer.children[i], oState[id],
                                         join_param, bReplace);
				}													
			}					
			join_fn(refer);		
		} else {
			var callback = (function(nId, refer, oState, join_param, bReplace, join_fn) {
			    return function(arg) {			    	
    	            // if children loaded before server responded
    	            if(refer.children != null && !bReplace) {
    	                for (var i = 0; i < refer.children.length; i++) {
    	                    var id = refer.children[i].oxfolder.data.id;
    	                    if (oState && oState[id]) {
    	                        Self.load_subfolders(id, refer.children[i],
    	                            oState[id], join_param, bReplace);
    	                    }
    	                }
    	                join_fn(refer); 
    	                return;
    	            }
    	            refer.children = [];
    	            if (nId == 2) Self.GALPresent = false;
    	            for (var nfldr=0; nfldr<arg.data.length; nfldr++) {
    	                var id = arg.data[nfldr][0];
    	                if (id == 6) Self.GALPresent = true;
    	                var newChild =
                            { "oxfolder": new ox_folder(arg.timestamp, arg.data[nfldr]),
                              "parent"  : refer,
                              "children": null
                            };
    	                refer.children.push(newChild);
    	                var oldrefer = null;
    	                if (refer.oxfolder.data.id == configGetKey("folder.infostore") && Self.fast_access[id] != undefined) {
    	                	var children = Self.fast_access[id].children;
    	                	if (children && children.length) {
    	                	    newChild.children = children;
    	                	}
    	                }
    	                    
    	                Self.fast_access[id] = newChild; 
    	                if (oState && oState[id]) {
                            Self.load_subfolders(id, newChild, oState[id],
                                                 join_param, bReplace);
    	                }                                                   
    	            }
    	            join_fn(refer);
    	        };
			})(nId, refer, oState, join_param, bReplace, join_fn);
	        
			(new JSON()).get(AjaxRoot + "/folders?action=list&all=1"
			     + "&columns=" + this.columns 
			     + "&parent=" + getUrlEncodedString(nId) 
                 + "&tree=" + this.treeID
			     + "&session=" + session, null, callback);
		}
	},
	
    /**
     * Finds folders which satisfy the specified predicate and returns an array
     * with their IDs.
     * @param {Function} pred A predicate function which takes a folder object
     * as parameter and returns true if the folder matches the search criteria.
     * @type Array
     * @return An array with folder IDs of matching folders.
     */
    search: function(pred) {
        var result = [];
        for (var i in this.fast_access)
            if (pred(this.fast_access[i].oxfolder.data)) result.push(i);
        return result;
    },
    
	updateFolders : function(folderIDs, fn_cb) {
        var Self = this;
        var locJson = new JSON();
        var _reqParams = new Array();
        for (var i in folderIDs) {
        	var obj = { module: "folder", action: "get", id: folderIDs[i], columns: this.columns };
        	obj.tree = this.treeID;
            _reqParams.push( obj );
        }
        locJson.put(AjaxRoot + "/multiple?session=" + session, _reqParams, null, 
            function(resp) {
                for (var ia=0; ia<resp.length; ia++) {
                    var _tmp = resp[ia];
                    if (_tmp.error && _tmp.error_id) continue;
                    var _oFolder = Self.find_folder(_tmp.data.id);
                    var timestamp = _tmp.timestamp || new Date().getTime();
                    _oFolder.oxfolder = { timestamp: timestamp, ENABLED: true, data: _tmp.data };
                    Self.fast_access[_tmp.data.id].oxfolder = _oFolder.oxfolder;
                }   
                fn_cb();
            }
        );
    },
	
	/* loads the path and all folder siblings */
	load_path : function (nId, join_param, bNOReplace){
		var Self = this;
		var sAjaxRequest = AjaxRoot + '/folders?action=path'		                
		                 + '&id=' + getUrlEncodedString(nId) 
		                 + '&columns=1,300'
		                 + "&tree=" + this.treeID
		                 + '&session=' + session ;
		
		var arg;
		function callback() {
	        if (Self.loading) {
	            Self.loading.push(callback);
	            return;
	        }
			var oState = {};
			var statetmp  = oState;
			var bFoundFolder = false;
			var oRefer;
            if (Self.treeID == 1 && arg.data[arg.data.length - 1][0] == 1) {
			    arg.data.length--;
			}
			/*
			 * fixed bug, in this case is the requested folder a first level folder and it must be present
			 * return the path
			 */
			if (arg.data.length <= 1) {
				var join_fn = join_param.add(
			        function (arg, arg2) {
			            if (arg) join_param.arg = arg;
			            if( arg2) join_param.arg2 = arg2;
			        }
				);		
				join_fn(Self.fast_access[nId], arg.data);
				return;
			}
			join_param.arg2 = arg.data;
			for (var indx = arg.data.length - 1; indx >= 0; indx--) {
				//found the last loaded node and load the rest
				if (!bFoundFolder && Self.fast_access[arg.data[indx][0]] != undefined) {
					oRefer = Self.fast_access[arg.data[indx][0]];
				} else {
					if (!bFoundFolder) {
						nParentId = arg.data[indx][0];				
					}
					bFoundFolder = true;
					statetmp[arg.data[indx][0]] = {};
					statetmp = statetmp[arg.data[indx][0]];
				}
			}
			var join_fn = join_param.add(
			    function (arg, arg2) {
			    	if (arg) join_param.arg = arg;
			        if (arg2) join_param.arg2 = arg2;
			    }
			);				
			//if node not found, load complete path
			if (oRefer == undefined) {
				join_param.count--;
				Self.load_folders(oState, join_param, !bNOReplace);
				
			} else if (!Self.fast_access[nId]) {
				join_param.count--;			
				Self.load_subfolders(oRefer.oxfolder.data.id, oRefer, oState, join_param, (true && !bNOReplace));
				
			} else {
				join_fn(Self.fast_access[nId], arg.data);
			}
		}
		
		(new JSON()).get(sAjaxRequest, null, function(a) {
		    arg = a;
		    callback();
		});
	},
	
	/* updates all folders; fetches new subfolder if availible, removes deleted folder from cache */
	update : function (nIdOpt, bWith_mail, fn_callback_opt) {
		var Self = this;
		var locJson = new JSON();
		var sAjaxRequest = AjaxRoot + "/folders?action=updates"
	            + "&columns=1,20&mail=" + (bWith_mail ? 1 : 0) 
	            + "&timestamp=" + this.timestamp
                + "&tree=" + this.treeID
	            + "&session=" + session;
	            		
		function cb_fn_updates(arg){
			var aReferences = new Array();
			if (arg.data) {
				Self.timestamp = arg.timestamp;
						
                if (Self.treeID == 1) {
                    for (var i = 0; i < arg.data.length; i++) {
                        if (arg.data[i][0] == 1 || arg.data[i][1] == 1) {
                            Self.load_folders(
                                Self.compute_state(Self.folders.root),
                                new Join(function() {
                                    Self.events.trigger("Changed",
                                                        Self.folders.root);
                                    if (fn_callback_opt) fn_callback_opt();
                                }), true);
                            return;
                        }
                    }
                }
				
				var top = {};
                for (var i = 0; i < arg.data.length; i++) {
                    var id = arg.data[i][0];
                    var parent = arg.data[i][1];
                    if (Self.fast_access[parent]) {
                        top[parent] = true;
                    } else if (Self.fast_access[id]) {
                        top[id] = true;
                    }
                }
                
                for (var i in top) {
                    for (var p = Self.fast_access[i].parent; p; p = p.parent) {
                        if (p.oxfolder && (p.oxfolder.data.id in top)) {
                            top[i] = false;
                            break;
                        }
                    }
                }
                
				var outer_join = new Join(fn_callback_opt || emptyFunction);
				for (var nNum in top) {
				    if (!top[nNum]) continue;
					var oRefer = Self.fast_access[nNum];
					var oReferState = Self.compute_state(oRefer);
					var fn_out_join = outer_join.add();
		//			delete oRefer.parent.children;
		//			oRefer.parent.children = [];			
					function close_it(obj, fn_out_join_close) {
						return function () {
							Self.events.trigger("Changed",obj);
							if (fn_out_join_close) {
								fn_out_join_close();
							}
					    };
					}
                    Self.load_subfolders(oRefer.oxfolder.data.id, oRefer,
                        oReferState, new Join(close_it(oRefer, fn_out_join)),
                        true);
				}
			}
		}
		locJson.get(sAjaxRequest, null, cb_fn_updates);
	},
	
	compute_state : function (refer){
		function fn_traverse(refer) {
			var retval = {};
			if (!refer.children) return retval;
            for (var i = 0; i < refer.children.length; i++) {
                if (   refer.children[i].children
                    && refer.children[i].children.length)
                {
                    retval[refer.children[i].oxfolder.data.id] =
                    fn_traverse(refer.children[i]);
				}			
			}
			return retval;
		}
		var oState = fn_traverse(refer);
		return oState;
	},
	
	find_folder : function (nId){
		var Self = this;
		var oFolder = null;		
		function fn_traverse(refer) {
		    if (!refer.children) return;
			for (var i = 0; i < refer.children.length; i++) {
				if (refer.children[i].oxfolder.data.id != nId) {
					fn_traverse(refer.children[i]);				
				} else {
					oFolder = refer.children[i];
					return;
				}
			}
		}
		fn_traverse(this.folders["root"]);
		return oFolder;
	},
	
	/*loads a folder if not loaded*/
	get_folder : function (nId,callback){
		var Self = this;
		var oFolder = this.fast_access[nId] || this.find_folder(nId);
		//request the folder if that could not be found
		if (oFolder == null) {		
			this.load_path(nId, 
			     new Join(
				     function () {
				         oFolder = Self.fast_access[nId] ||
				                   Self.find_folder(nId);
				         if (!oFolder) {
				             triggerEvent("OX_New_Error", 4,
				                 "Server error: wrong path for folder " + nId);
				         } else {
				             callback(oFolder);
				         }
				     }
				 ), true);
		} else if (callback) {	
			callback(oFolder);
		}
	}
};

function ox_folder(timestamp, dataArray) {
	this.data = new Object();	
	if (dataArray && dataArray.length > 11) {
		this.data.id = dataArray[0];
		this.data.module = dataArray[1];
		this.data.title = dataArray[2];
		this.data.summary = dataArray[3];
		this.data.subfolders = dataArray[4];
		this.data.permissions=dataArray[5]; 
		this.data.type = dataArray[6];
		this.data.own_rights=dataArray[7]; 
		this.data.standard_folder = dataArray[8];	
		this.data.unread= dataArray[9];
		this.data.created_by = dataArray[10];
		this.data.subscribed = dataArray[11];		
		this.data.capabilities = dataArray[12];
		this.data.subscr_subflds = dataArray[13];
		this.data["com.openexchange.publish.publicationFlag"] = dataArray[14];
		this.data["com.openexchange.subscribe.subscriptionFlag"] = dataArray[15];
	}
	
	this.timestamp = timestamp;
	//flags
	this.ENABLED = true;
}