/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 * 
 */

register("OX_Configuration_Loaded_Complete", function() {
    var modules = configGetKey("availableModules");
    if (!modules) return;
    var join = new Join(function() { temporary.services.finish(); });
    var lock = join.add();
    for (var i in modules) loadModule(modules[i], join);
    lock();
});

  //////////////////////////////////////////
 //   Global names defined for plugins   //
//////////////////////////////////////////

/**
 * Translates a string.
 * @function
 * @name _
 * @param {String} text The original English text to translate.
 * @type I18nString
 * @return The translated text.
 */

/**
 * Translates a string.
 * @function
 * @name gettext
 * @param {String} text The original English text to translate.
 * @type I18nString
 * @return The translated text.
 */

/**
 * Translates a string with context
 * @function
 * @name pgettext
 * @param {String} context A context to differentiate multiple identical texts
 * with different translations.
 * @param {String} text The original English text to translate.
 * @type I18nString
 * @return The translated text.
 */

/**
 * Translates a string containing numbers.
 * @function
 * @name ngettext
 * @param {String} singular The original English text for the singular form.
 * @param {String} plural The original English text for the plural form.
 * @param {Number} n The number which determines which text form is used.
 * @type I18nString
 * @return The translated text.
 */

/**
 * Translates a string containing numbers with context.
 * @function
 * @name npgettext
 * @param {String} context A context to differentiate multiple identical texts
 * with different translations.
 * @param {String} singular The original English text for the singular form.
 * @param {String} plural The original English text for the plural form.
 * @param {Number} n The number which determines which text form is used.
 * @type I18nString
 * @return The translated text.
 */

/**
 * Converts a string to I18nString without translation.
 * @function
 * @name noI18n
 * @param {String} text The text to conevrt.
 * @type I18nString
 * @return The untranslated text as I18nString.
 */

//////////////////////////////////////////

/**
 * Loads a module at runtime.
 * Loading a module which is already (being) loaded has no effect. 
 * The register.js file from the module's directory is converted to the body of
 * a function and that function is called without parameters.
 * The file is downloaded asynchronously.
 * @param {String} name The name of the module to load.
 * @param {Join} join An optional Join object which is locked until the module
 * finishes loading.
 */
function loadModule(name, join) {
    if (name in loadedModules) return;
    loadedModules[name] = true;
    if (!join) join = new Join(emptyFunction);
    // inject version
    var url = oxProductInfo.build + "/plugins/" + name + "/register.js";
    // get register.js
    (new JSON()).get(url, null,
        join.add(function(js) {
            if (internalPlugins[name])
                name = "";
            else
                bindtextdomain(name, "plugins/" + name + "/lang/%s.po");
            if (debugPlugins) {
                loadModule.params[++loadModule.index] =
                    [gt, gt, pgt, ngt, npgt, noI18n, join.add()];
                var src =["(function(_,gettext,pgettext,ngettext,npgettext,",
                          "noI18n,$done){delete loadModule.params[",
                          loadModule.index, "];try{(function(){",js,
                          "})()}finally{$done();}})("];
                var params = [];
                var prefix = "loadModule.params[" + loadModule.index + "][";
                for (var i = 0; i < 7; i++) params.push(prefix + i + "]");
                src.push(params.join());
                src.push(");");
                document.getElementsByTagName("head")[0].appendChild(
                    newnode("script", 0, {
                        type: "text/javascript",
                        src: "data:text/javascript;charset=utf-8," +
                            encodeURIComponent(src.join(""))
                    }));
            } else {
                (Function("_", "gettext", "pgettext", "ngettext", "npgettext",
                    "noI18n", js))(gt, gt, pgt, ngt, npgt, noI18n);
            }
            /**
             * @class A translated string. All text strings displayed to
             * the user must be instances of this class instead of the default
             * <code>String</code> class. All translation functions return
             * instances of this class. When the UI language changes,
             * <code>I18nString</code> objects are retranslated automatically.
             * Setting the global variable <code>debug</code> to
             * <code>true</code> will enable console warnings when strings are
             * used where <code>I18nString</code> is expected.
             * @name I18nString
             */
            function I18nString(f) { return f.toString = f; }

            function gt(text) {
                return I18nString(function() {
                    return dpgettext(name, "", text);
                });
            }
            function pgt(context, text) {
                return I18nString(function() {
                    return dpgettext(name, context, text);
                });
            }
            function ngt(singular, plural, n) {
                return I18nString(function() {
                    return dnpgettext(name, "", singular, plural, n);
                });
            }
            function npgt(context, singular, plural, n) {
                return I18nString(function() {
                    return dnpgettext(name, context, singular, plural, n);
                });
            }
            function noI18n(text) {
                return I18nString(function() { return text; });
            }
        }),
        join.alt(function(result, status) {
            delete loadedModules[name];
            return status == 404;
        }), true);
};

loadModule.params = {};
loadModule.index = 0;

var internalPlugins = {
    "com.openexchange.group": true,
    "com.openexchange.mail.filter": true,
    "com.openexchange.oxupdater": true,
    "com.openexchange.publish": true,
    "com.openexchange.resource": true,
    "com.openexchange.subscribe": true,
    "com.openexchange.user.passwordchange": true,
    "com.openexchange.user.personaldata": true
};

// TODO: fill during initialization of modules.
var loadedModules = {
    calendar: true,
    contacts: true,
    folder: true,
    infostore: true,
    interfaces: true,
    mail: true,
    mailaccount: true,
    messaging: true,
    portal: true,
    tasks: true,
    themes: true,
    folderstorage: true
};
