/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 */

(function() {
    
    function _(text) {
        var f = function() { return window._(text); };
        f.toString = f;
        return f;
    }

    var activeService, activeGrid, grids;
    var folderPath = new FolderPath("messaging");
    
    register("OX_Configuration_Loaded", function() {
        oMainFolderTree.enabled_modules.messaging = true;
        menulastviews.messaging = "messaging";
        register("NewMessage", function() {
            if (activeService) activeService.newMessage.getMessage();
        });
        changeDisplay("messaging", "menu_messaging_new");
        function updateMenu() {
            if (activeGrid) Editor.selected(activeGrid.selection.count);
        }
        for (var i in allServices) {
            var actions = allServices[i].actions;
            if (!actions) continue;
            register("OX_SELECTED_ITEMS_CHANGED", updateMenu);
            register("OX_menu_Change_Height", updateMenu);
            register("OX_Switched", updateMenu);
            var context = MenuNodes.createSmallButtonContext(i, _("Actions"),
                                                             "messaging");
            for (var j in actions) actions[j].createMenuItem(context);
            addMenuNode(context.node, MenuNodes.FIXED, 40);
            changeDisplay("messaging", i);
        }
    });
    
    registerView("messaging",
        function() {
            showNode("messaging");
        }, function(type) {
            if (!grids) {
            	grids = new MessagingGrids();
            	grids.selection.events.register("Selected", Editor.selected);
            }
            changeFolder(type);
        }, function() {
        	grids.disable();
            folderPath.clear();
        }, function() {
            hideNode("messaging");
        }, changeFolder);
    
    function getBody(message) {    	
        var retval = {};
        var contentType = message.contentType && message.contentType.type
                       || message.headers && message.headers["Content-Type"].type;
                
        switch (contentType) {
            case "text/plain":
                retval.plain = message.body;
                break;
            case "text/html":
                retval.html = message.body;
                break;
            default:
                if (contentType && contentType.substring(0, 10) == "multipart/") {
                    for (var i = 0; i < message.body.length; i++) {
                        var sub = getBody(message.body[i]);
                        for (var j in sub) {
                            if (!retval[j]) retval[j] = sub[j];
                        }
                    }
                }
        }
        return retval;
    } 
    
    function getElements(div) {
        var e = {};
        if (!div.firstChild) {
            div.appendChild(e.picture = newnode("img", { flt: "left",
                width: "4em", height: "4em", margin: "0.4em" }));
            div.appendChild(newnode("div", { marginLeft: "4.8em" }, 0, [
                e.time = newnode("span", { flt: "right" }, 0, [newtext()]),
                e.from = newnode("span", { fontWeight: "bold" }, 0, [newtext()])
            ]));
            div.appendChild(e.text = newnode("div",
                { marginLeft: "4.8em", height: "3.2em",
                  whiteSpace: "normal", overflow: "hidden" }));
        } else {
            e.picture = div.firstChild;
            e.time = e.picture.nextSibling.firstChild;
            e.from = e.time.nextSibling;
            e.text = e.picture.nextSibling.nextSibling;
        }
        return e;
    };
    
    // parse plain text content and make urls and special tags clickable
    var htmlRegexp = new RegExp("(\\b(?:https?:\/\/|ftp:\/\/|mailto:|news\\\\.|www\\\\.)[-A-Za-z0-9+&@#\/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#\/%=~_()|])|@(\\w+)|(#\\w+)", "gi");
    function parseHTML(content, oDiv) {
    	var mpos, lIndex = 0;
    	// iterate through results
    	while (mpos = htmlRegexp.exec(content)) {
    		// everything before
			oDiv.appendChild(newtext(content.substring(lIndex, mpos.index)));
			lIndex = mpos.index + mpos[0].length;
			var link = content.substring(mpos.index, lIndex); // the shown link text
			var href = link; // the real hred
			// twitter: @ or # links?
			if (mpos[2] || mpos[3]) {				
				href="http://www.twitter.com/" + (mpos[3] ? "#search?q=" : "") + encodeURIComponent(link);
			}
			var mn = newnode("a", { fontWeight: "bold"}, { href: href, target: "_blank" }, 
					[ newtext(link) ]);
			oDiv.appendChild(mn);
			// prevent stopEvent from grid
			mn.onclick=function(e) {
        		cancelBubbling(e);
        	};
    	}
    	// everything else
    	oDiv.appendChild(newtext(content.substring(lIndex, content.length)));
    };
    
    function MessagingGrids() {
    	this.container = { "list":null, "hsplit":null };
    	this.selection = selection = new Selection2();
    }
    
    MessagingGrids.prototype = {
    	initGrid: function(type, select_cb) {
	    	var grid = new LiveGrid2([{
	            text: "",
	            name: ["subject", "from", "receivedDate", "body", "headers", "picture"],
	            style: { height: "4.8em", borderBottom: "1px solid silver" },
	            set: function(div, content) {
	            	if (activeService.set) 
	            		activeService.set(div, content);
	            	else {
	            		var e = getElements(div);
		                e.picture.src = content.picture;	                
		                if (activeService.getSubject)                	
		                	activeService.getSubject(e, content);
		                else 
		                	e.from.firstChild.data = content.from ? content.from.personal
		                			: content.subject;
		                var date = content.receivedDate;
		                e.time.firstChild.data = date ?
		                    formatDate(date, isToday(date) ? "time" : "datetime") : "";
		                var body = getBody(content);
		                if (body.plain) {
		                    removeChildNodes(e.text);
		                    parseHTML(body.plain, e.text);
		                } else if (body.html) {
		                    e.text.innerHTML = body.html;
		                } else {
		                    removeChildNodes(e.text);
		                }
	            	}
	            },
	            clear:function(div) {
	            	if (activeService.clear) 
	            		activeService.clear(div);
	            	else {
	            		var e = getElements(div);
		                e.picture.src = getFullImgSrc("img/dummy.gif");
		                e.from.firstChild.data = "";
		                e.time.firstChild.data = "";
		                e.text.innerHTML = "";
	            	}
	            }
	        }], selection, "messaging/message");
	        grid.disablehover = true;
	        grid.contextmenu = new ContextMenu();
	        grid.getHeader();
	        grid.getTable($("messaging." + type + ".grid"));
	        if (select_cb) grid.events.register("Selected", select_cb);
	        return this.container[type] = grid;
    	},
    	disable: function() {
    		for (var i in this.container) {
    			if (this.container[i]) 
    				this.container[i].disable();
    		}
    	},
    	getGrid: function(type, select_cb) {
    		var grid = this.container[type] || this.initGrid(type, select_cb);    	
    		for (var i in this.container) {
    			$("messaging." + i).style.display = (type == i) ? "" : "none";
    		}
    		return grid;
    	}
    };
    
    function showDetails() {    	
    	
    	var msg = activeGrid.selection.getSelected()[0];
        var Self = this;
        ox.JSON.get(AjaxRoot +
            "/messaging/message?action=get" +
            "&id=" + encodeURIComponent(msg.id) + "&folder=" + encodeURIComponent(msg.folder) +
            "&session=" + session, function(message) {
        		var msg = message.data;
        		var date = msg.receivedDate;
        		$("messaging.hsplit.date").firstChild.data = date ?
	                    formatDate(date, isToday(date) ? "time" : "datetime") : "";
				if (msg.id) {
					var linked = newnode("a", 0, {href:msg.id, target:"_blank"}, [newtext(msg.subject)]);
					$("messaging.hsplit.subject").replaceChild(linked, $("messaging.hsplit.subject").firstChild);
				} else {
					$("messaging.hsplit.subject").firstChild.data = msg.subject || "";
				}
	        	var body = getBody(msg);
	        	if (body.html) {
	            	$("messaging.hsplit.detail").innerHTML = body.html;
	        	} else if (body.plain) {
	                removeChildNodes($("messaging.hsplit.detail"));
	                parseHTML(body.plain, $("messaging.hsplit.detail"));
	            } else {
	                removeChildNodes($("messaging.hsplit.detail"));
	            }
            });
    	
    }
    
    function changeFolder(type) {
        folderPath.drawDOMNode("messaging.foldername", activefolder);
        
        var service = /^(.*?):/.exec(activefolder);
        if (service) {
            service = service[1];
            messagingServices.get(setService);
        }
        
        function setService(serviceDefs) {
            activeService = allServices[service];
            if (!activeService || !(service in serviceDefs)) {
                activeService == null;
                return;
            }
            activeGrid = activeService.getGrid();
            activeGrid.contextmenu.removeAllItems();
            var actionDefs = serviceDefs[service].messagingActions;
            for (var i = 0; i < actionDefs.length; i++) {
                var item = activeService.actions &&
                           activeService.actions[actionDefs[i]];
                if (item) {
                    activeGrid.contextmenu.addItem(item.getContextMenuItem());
                }
            }
            activeGrid.contextmenu.display = activeGrid.contextmenu.items.length ?
                ContextMenu.prototype.display : emptyFunction;
            for (var i in allServices) {
                if (i == service) showNode(i); else hideNode(i);
            }
            Editor.selected(0);
            activeGrid.enable({ folder: activefolder });
        }
    }

    function Editor(action, title) {
        this.action = action;
        this.title = title;
        var Self = this;
        this.send_cb = function() { Self.send(); };
        this.done_cb = function() { Self.done(); };
    }
    
    Editor.menuID = 0;
    
    Editor.menuSections = {};
    
    Editor.selected = function(count) {
        var enabled = count == 1;
        for (var i in Editor.menuSections) {
            var section = Editor.menuSections[i];
            menuglobalzaehler = 0;
            menuarrows.messaging[i] = [];
            for (var j = 0; j < section.length; j++) {
                menu_display_contents("messaging", i, enabled, section[j]);
            }
            showArrowPopUpMenu(i + ".enhancement", i, "messaging");
        }
    };
    
    menuarrows.messaging = {};
    
    Editor.prototype = {
        getContextMenuItem: function() {
            if (this.contextMenuItem) return this.contextMenuItem;
            this.contextMenuItem = new MenuItem(this.title, function() {
                this.editor.getMessage(this.getContext().getSelected()[0]);
            });
            this.contextMenuItem.editor = this;
            this.contextMenuItem.onShow = function() {
                this.setEnabled(this.getContext().count == 1);
            };
            return this.contextMenuItem;
        },
        createMenuItem: function(context) {
            var Self = this;
            var id = context.node.id;
            var section = Editor.menuSections[id];
            if (!section) section = Editor.menuSections[id] = [];
            section.push("messaging.menubutton." + Editor.menuID);
            MenuNodes.createSmallButton(context,
                "messaging.menubutton." + Editor.menuID++, this.title,
                getFullImgSrc("img/dummy.gif"), getFullImgSrc("img/dummy.gif"),
                function() {
                    Self.getMessage(activeGrid.selection.getSelected()[0]);
                });
        },
        getMessage: function(message) {
            this.edit({ contentType: { type: "text/plain" },
                        folder: activefolder, body: "" });
        },
        edit: function(message) {
            this.message = message;
            $("messaging.message").value = getBody(message).plain || "";
            $("messaging.to").style.display = "none";
            if (this.onEdit) this.onEdit();
            centerPopupWindow($("messaging.popup"));
            $("messaging.popup").style.display = "";
            $("messaging.send").onclick = this.send_cb;
            setFocus($("messaging.message"));
        },
        send: function() {
            $("messaging.popup").style.display = "none";
            this.message.contentType = { type: "text/plain" };
            this.message.body = $("messaging.message").value;
            ox.JSON.put(AjaxRoot +
                "/messaging/message?action=perform&messageAction=" +
                this.action + "&folder=" + this.message.folder + "&session=" +
                session, this.message, this.done_cb);
        },
        done: function() { OXCache.update(); }
    };
    
    function MessageEditor(getAction, sendAction, title) {
        Editor.call(this, sendAction, title);
        this.getAction = getAction;
    }
    
    MessageEditor.prototype = extend(Editor, {
        getMessage: function(message) {
            var Self = this;
            ox.JSON.get(AjaxRoot +
                "/messaging/message?action=perform&messageAction=" +
                this.getAction + "&id=" + message.id + "&folder=" +
                message.folder + "&session=" + session, function(reply) {
                    Self.edit(reply.data);
                });
        }
    });
    
    var post = new Editor("post", _("Post"));
    post.getMessage = function(message) {
        this.edit({
            contentType: { type: "text/plain" },
            body: "",
            id: message.id,
            folder: message.folder,
            to: message.from
        });
    };
    post.onEdit = function() {
        $("messaging.to").parentNode.parentNode.style.display = "";
        $("messaging.to").value = this.message.to.personal;
    };
    var retweetNew = new Editor("tweet", _("Retweet new"));
    retweetNew.done = function() {
        ox.Configuration.info(_("Retweet sent successfully"));
    };
    
    var allServices = {
        "com.openexchange.messaging.facebook": {
            newMessage: new Editor("updateStatus"),
            actions: { post: post },
            getSubject: function(e, content) {
            	var mynode=newnode("a", { fontWeight:"bold" }, 
            			{ href: "http://www.facebook.com/people/" + content.from.personal + "/" + content.from.address,
      			  target: "facebook" },
      			  [ newtext(content.from ? content.from.personal : content.subject) ]);
            	// replace current node
            	e.from.parentNode.replaceChild(mynode, e.from );
            	// prevent stopEvent from grid
            	mynode.onclick=function(e) {
            		cancelBubbling(e);
            	};
            },
            getGrid: function() {
            	return grids.getGrid("list");
            },
            getFolderIcons: function(folder) {
                return { open: getFullImgSrc("img/folder/facebook.png"),
                       closed: getFullImgSrc("img/folder/facebook.png") };
            }
        },
        "com.openexchange.messaging.rss": { 
            getSubject: function(e, content) {
            	e.from.parentNode.replaceChild(newnode("span", { fontWeight:"bold" }, 0,
            			[ newtext(content.from ? content.from.personal : content.subject) ]), e.from);
            },
            getGrid: function() {
            	return grids.getGrid("hsplit", showDetails);
            },
            getFolderIcons: function(folder) {
                return { open: getFullImgSrc("img/folder/rss.png"),
                       closed: getFullImgSrc("img/folder/rss.png") };
            }
        },
        "com.openexchange.messaging.twitter": {
            newMessage: new Editor("tweet"),
            actions: {
                retweet: new MessageEditor("retweet", "tweet", _("Retweet")),
                retweetNew: retweetNew,
                directMessage: new MessageEditor("directMessage", "tweet",
                    _("Direct message"))
            },
            getSubject: function(e, content) {
            	var mynode=newnode("a", { fontWeight:"bold" }, 
            			{ href: "http://www.twitter.com/" + content.from.address,
      			  target: "twitter" },
      			  [ newtext(content.from ? content.from.personal : content.subject) ]);
            	// replace current node
            	e.from.parentNode.replaceChild(mynode, e.from);
            	// prevent stopEvent from grid
            	mynode.onclick=function(e) {
            		cancelBubbling(e);
            	};
            },
            getGrid: function() {
            	return grids.getGrid("list");
            },
            getFolderIcons: function(folder) {
                return { open: getFullImgSrc("img/folder/twitter.png"),
                       closed: getFullImgSrc("img/folder/twitter.png") };
            }
        }
    };
    
    customFolderIcons.messaging = function(folder) {
        var service = /^(.*?):/.exec(folder.id);
        if (service) return allServices[service[1]].getFolderIcons(folder);
        return { open: getFullImgSrc("img/folder/folder_opened.gif"),
               closed: getFullImgSrc("img/folder/folder_closed.gif") };
    };
    
})();