<?php

/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Manuel Kraft <manuel.kraft@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */
    session_start();
    $oxdata = $_SESSION['ox_data'];
?>

<ul id="calendarList" title="<?php echo _("Calendar"); ?>" selected="true">
<?php
  
    $session_is_expired = false;
    try {
        $data = oxGetAppointmentList($oxdata,"","",null);
    } catch(oXSessionTimeoutException $e){
        //echo "Session expired , loggin in again!";
        $session_is_expired = true;
        $oxdata = oXDoLogin($oxdata['ox_host'], $oxdata['ox_user'], $oxdata['ox_passwd'], false);
    }

    if($session_is_expired){
        // data is not defined, seems that session is expired
        $data = oxGetAppointmentList($oxdata,"","",null);
    }
    
    $lastDate="";
    foreach ($data as $app_object) {
        // 0. id
        // 1. title
        // 2. start
        // 3. end
        // 4. folder id
        // 5. location of the appointment
        
        $start_t = strftime('%a, %e. %B %Y',strtotime(oXGetDisplayDate($oxdata,$app_object[2],'D d.m.Y')));
        $end = oXGetDisplayDate($oxdata,$app_object[3],null);

        if ($start_t != $lastDate) {
            $lastDate = $start_t;
            ?>
                <li class="group"<?php 
                    if (date("D d.m.Y")==$lastDate) {
                        echo " style=\"color:#225577\"";
                    }; ?>><?php echo $lastDate ?></li>
            <?php
        }
        $location = $app_object[5];
        $startHr = strftime('%R', strtotime(oXGetDisplayDate($oxdata,$app_object[2],null))) . " - " . strftime('%R', strtotime(oXGetDisplayDate($oxdata,$app_object[3],null)));
        if ($app_object[6]) {
            $startHr = _("All day");
        }
        $subject = $app_object[1] ? $app_object[1] : "&nbsp;";
        echo "<li style=\"padding-left:0px\"><div class=\"calLi-time\">".$startHr."</div> <a style=\"padding-left:100px;\" href=\"index.php?content=no&module=calendar&view=detail&obj_id=".$app_object[0]."&folder_id=".$app_object[4]."\">" . $subject;
        if (!empty($location)) {
            echo "<br><span style=\"color:grey; font-size:14px\">".$location."</span>";
        }
        echo "</a></li>";
    }
?>
</ul>