<?php

/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Manuel Kraft <manuel.kraft@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */

    session_start();
    $oxdata = $_SESSION['ox_data'];

    $folder_id = $oxdata['ox_default_folder_calendar'];
    if ($_GET['folder_id']) {
        $folder_id = $_GET['folder_id'];
    }
    $obj_id = $_GET['obj_id'];    
    if(!$obj_id){
        // show errror html
        $html = <<< EOH
<table border="0">
<tr>
<td style="color:red;">
Missing object id!
</td>
</tr>
</table>
EOH;
        echo($html);
        return; // let script return
    } else {        
        // fetch contact data
        try{
            $data = oxGetAppointment($oxdata,$obj_id,$folder_id);
        }catch(oXSessionTimeoutException $e){
            //echo "Session expired , loggin in again!";
            $session_is_expired = true;
            $oxdata = oXDoLogin($oxdata['ox_host'],$oxdata['ox_user'], $oxdata['ox_passwd'], false);
        }

        if($session_is_expired){
            // data is not defined, seems that session is expired
            $data = oxGetAppointment($oxdata,$obj_id,$folder_id);
        }
        
        $isAllDay = $data->full_time;
        $isSameDay = true;
        if (oXGetDisplayDate($oxdata, $data->start_date,'d.m.Y') != oXGetDisplayDate($oxdata, $data->end_date,'d.m.Y')) {
            $isSameDay = false;
        }
        $start_date = strtotime(oXGetDisplayDate($oxdata,$data->start_date,'D d.m.Y H:i'));
        $end_date = strtotime(oXGetDisplayDate($oxdata,$data->end_date,'D d.m.Y H:i'));
        if ($isAllDay) {
            $start_date = strftime('%A %e. %b. %Y', $start_date);
            $end_date = _("All day");
        } else if ($isSameDay) {            
            $end_date = _("from") . strftime(' %R ', $start_date) . _("until") . strftime(' %R', $end_date);
            $start_date = strftime('%A %e. %b. %Y', $start_date);
        } else {
            $start_date = strftime('%R %a %e. %b. %Y', $start_date);
            $end_date = strftime('%R %a %e. %b. %Y', $end_date);
        }
    }
?>

<div id="calendarDetail" title="<?php echo _("Details");?>" class="panel">
    <fieldset>
        <div class="row" style="text-align:left;">
            <?php 
               if (!empty($data->title)) {
            ?>
                <div style="padding-bottom:0;font-size:17px;font-weight:bold"><?php echo $data->title; ?></div>
            <?php
               }
               if ($data->location) {
               ?>
                <div style="color:grey;padding-top:0;padding-bottom:0"><? echo $data->location; ?></div>
               <?
               }
            ?>
            <div class="labelH"> 		
                <?php 
                    if (!$isAllDay && !$isSameDay) {
                        echo _("begins") . " ";
                    }
                    echo $start_date . "<br/>";
                    
                    if (!$isAllDay && !$isSameDay) {
                        echo _("ends") . " ";
                    }
                    echo $end_date;
                ?>
            </div>
        </div>

        <!--
        <div class="row">
            <?php
                $confirmation_msg = "";
                // loop through the participants and show my current accept deny status
                foreach ($data->users as $participant) {
                    if($participant->id== $oxdata["ox_user_id"]){
                        $confirmation_msg = $participant->confirmmessage;
                        $confirmation_status = $participant->confirmation;

                    }
                }
                $myoptions = array(0=>_("None"),1=>_("Accepted"),2=>_("Declined"),3=>_("Tentative"));
                $options = getSelectOptionsForm($myoptions,$confirmation_status);
            ?>
            <label><?php echo _("Confirmation Status") ?></label>
            <select name="conf_status">
              <?php echo $options ?>
            </select>
        </div>
        <div class="row">
            <label><?php echo $confirmation_msg ?></label>
        </div>
        -->
        
        <?php
        if (!empty($data->note)) {
        ?>
        <div class="row">
            <label>Notes</label><br>
            <div class="labelH labelN">
                <?php echo nl2br($data->note); ?>
            </div>
        </div>
        <?php
        }
        ?>
    </fieldset>
</div>
