<?php

/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Manuel Kraft <manuel.kraft@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */
    session_start();
    $oxdata = $_SESSION['ox_data'];
?>

<table class="listview" cellspacing="1" cellpadding="3">

    <?php

        $folder_id = $oxdata['ox_default_folder_tasks'];
        
        try{
            $data = oxGetTaskList($oxdata,$folder_id);
        }catch(oXSessionTimeoutException $e){           
            $oxdata = oXDoLogin($oxdata['ox_host'],$oxdata['ox_user'], $oxdata['ox_passwd'], false);
            $data = oxGetTaskList($oxdata,$folder_id);
        }
        
        foreach ($data as $task_object) {
        /**
         * 1 id
        * 4  creation_date
        * 5  last_modified
        * 200 title
        * 201 start_date
        * 202 end_date
        * 203 note
        * 300 status
        * Status of the task:
            1 	not started
            2 	in progress
            3 	done
            4 	waiting
            5 	deferred
         * 301 percent_completed
         * 302 actual_costs
         * 303 actual_duration
         * 309 priority
         * Number
            1 = LOW,
            2 = MEDIUM,
            3 = HIGH
         */
           
            $object_id = $task_object[0];
             $create_date = $task_object[1];
             $last_modified = $task_object[2];
            $title = $task_object[3];
            $start_date = $task_object[4];
            $start_date_ = $task_object[4];
            $end_date = $task_object[5];
            $note = $task_object[6];
            $status = $task_object[7];
            $percent_complete= $task_object[8];
            $priority = $task_object[11];

             if($start_date){
                $start_formatted = strftime('%a, %e. %B %Y',strtotime(oXGetDisplayDateTasks($oxdata,$start_date)));
                //$start_date  = oXGetDisplayDateTasks($oxdata,$start_date);
             }else{
                 $start_formatted = _("Not set");
             }
             if($end_date){
                $end_formatted = strftime('%a, %e. %B %Y',strtotime(oXGetDisplayDateTasks($oxdata,$end_date)));
                //$end_date  = oXGetDisplayDateTasks($oxdata,$end_date);
             }else{
                 $end_formatted = _("Not set");
             }

             echo "<tr>
                <td class=\"listview_grey_column\">
                    <a href=\"index.php?module=tasks&view=detail&obj_id=".$object_id."\" style=\"display:block;\">
                      "._("Begins")."&nbsp;".$start_formatted."&nbsp;-&nbsp;"._("Ends")."&nbsp;".$end_formatted."
                    </a>
                </td>
                </tr>
                <tr>
                <td class=\"listview_darkgrey_column\">
                    <a href=\"index.php?module=tasks&view=detail&obj_id=".$object_id."\" style=\"display:block;\">
                     ".$title." &nbsp;
                    </a>
                </td>
              </tr>";

        }

    ?>

</table>
