<?php
/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Manuel Kraft <manuel.kraft@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */

    session_start();
    $oxdata = $_SESSION['ox_data'];


    $obj_id = $_GET['obj_id'];

    if(!$obj_id){
        // show errror html
        $html = <<< EOH
<table border="0">
<tr>
<td style="color:red;">
Missing object id!
</td>
</tr>
</table>
EOH;
        echo($html);
        return; // let script return
    }else{
        $folder_id = $oxdata['ox_default_folder_tasks'];
        // fetch task data
        try{
            $data = oXGetTask($oxdata,$obj_id,$folder_id);
        }catch(oXSessionTimeoutException $e){
            //echo "Session expired , loggin in again!";
            $session_is_expired = true;
            $oxdata = oXDoLogin($oxdata['ox_host'],$oxdata['ox_user'], $oxdata['ox_passwd'], false);
            $data = oXGetTask($oxdata,$obj_id,$folder_id);
        }
       

        if($data->start_date){
            $start_formatted = strftime('%a, %e. %B %Y',strtotime(oXGetDisplayDateTasks($oxdata,$data->start_date)));
        }else{
            $start_formatted = _("Not set");
        }
        if($data->end_date){
            $end_formatted = strftime('%a, %e. %B %Y',strtotime(oXGetDisplayDateTasks($oxdata,$data->end_date)));
        }else{
            $end_formatted = _("Not set");
        }
        


    }
?>

<table class="listview">

        <tr>
            <td class="listview_grey_column">
                <b><?php echo _("Detail view"); ?></b>
            </td>            
        </tr>
        <tr>
            <td class="listview_darkgrey_column">
                <?php echo $data->title; ?>&nbsp;
            </td>
        </tr>       


        <tr>
            <td class="listview_grey_column">
                <b><?php echo _("Begins"); ?></b>                 
            </td>
        </tr>
        <tr>
            <td class="listview_darkgrey_column">
                <?php echo $start_formatted; ?>
            </td>
        </tr>


         <tr>
            <td class="listview_grey_column">
                <b><?php echo _("Ends"); ?></b>               
            </td>
        </tr>
        <tr>
            <td class="listview_darkgrey_column">
                <?php echo $end_formatted; ?>
            </td>
        </tr>
        
        <tr>
            <td class="listview_grey_column">
                <b><?php echo _("Priority"); ?></b>   
            </td>
        </tr>
        <tr>
            <td class="listview_darkgrey_column">
                 <?php
                if($data->priority){
                    switch ($data->priority) {
                        case 1:
                        echo _("Low");
                        break;
                        case 2:
                        echo _("Medium");
                        break;
                        case "3":
                        echo _("High");
                        break;
                    }
                } else {
                    echo "&nbsp;";
                }

            ?>
            </td>
        </tr>



        <tr>
            <td class="listview_grey_column">
                <b><?php echo _("% completed"); ?></b>
            </td>
        </tr>
        <tr>
            <td class="listview_darkgrey_column">
                <?php echo $data->percent_completed; ?>%
            </td>
        </tr>

        <tr>
            <td class="listview_grey_column">
                <b><?php echo _("Status"); ?></b>
            </td>
        </tr>
        <tr>
            <td class="listview_darkgrey_column">
                <?php
                 if($data->status){
                    switch ($data->status) {
                        case 1:
                        echo _("Not started");
                        break;
                        case 2:
                        echo _("In progress");
                        break;
                        case "3":
                        echo _("Done");
                        break;
                        case "4":
                        echo _("Waiting");
                        break;
                        case "5":
                        echo _("Deferred");
                        break;
                    }
                }else{
                    echo "&nbsp;";
                }
                ?>
            </td>
        </tr>


        <tr>
            <td class="listview_grey_column">
                <b><?php echo _("Comments"); ?></b>
            </td>            
        </tr>
        <tr>
        <td class="listview_darkgrey_column">
                <?php echo nl2br($data->note); ?>&nbsp;
            </td>
        </tr>      

    </table>
