<?php

/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Manuel Kraft <manuel.kraft@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */
    session_start();
    $oxdata = $_SESSION['ox_data'];
?>
<table class="listview" cellspacing="1" cellpadding="3">
<?php
    function getmicrotime(){
        list($usec, $sec) = explode(" ",microtime());
        return ((float)$usec + (float)$sec);
    }

    $session_is_expired = false;
    try {
        $data = oxGetAppointmentList($oxdata,"","",$oxdata['ox_default_folder_calendar']);
    } catch(oXSessionTimeoutException $e){
        //echo "Session expired , loggin in again!";
        $session_is_expired = true;
        $oxdata = oXDoLogin($oxdata['ox_host'], $oxdata['ox_user'], $oxdata['ox_passwd'], false);
    }

    if($session_is_expired){
        // data is not defined, seems that session is expired
        $data = oxGetAppointmentList($oxdata,"","",$oxdata['ox_default_folder_calendar']);
    }

    foreach ($data as $app_object) {
        // 0. id
        // 1. title
        // 2. start
        // 3. end
        // 4. folder id
        // 5. location of the appointment
        $start_t = strftime('%a, %e. %B %Y',strtotime(oXGetDisplayDate($oxdata,$app_object[2],'D d.m.Y')));
        $end = oXGetDisplayDate($oxdata,$app_object[3],null);

        $startHr = strftime('%R', strtotime(oXGetDisplayDate($oxdata,$app_object[2],null))) . " - " . strftime('%R', strtotime(oXGetDisplayDate($oxdata,$app_object[3],null)));
        if ($app_object[6]) {
            $startHr = _("All day");
        }

        $location = $app_object[5];

        echo "<tr>
                <td class=\"listview_grey_column\">
                    <a href=\"index.php?module=calendar&view=detail&obj_id=".$app_object[0]."\" style=\"display:block;\">
                     ".$start_t.", ".$startHr."          
                    </a>
                </td>
                </tr>
                <tr>
                <td class=\"listview_darkgrey_column\">
                    <a href=\"index.php?module=calendar&view=detail&obj_id=".$app_object[0]."\" style=\"display:block;\">
                    ".$app_object[1]." - ".$location."
                    </a>
                </td>
              </tr>";
    }
?>
</table>
