<?php

/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Manuel Kraft <manuel.kraft@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */
session_start();
$oxdata = $_SESSION['ox_data'];

//$folder_id = $_GET['folder_id']; supplied in session
$obj_id = $_GET['obj_id'];
$folder_id ;
if(!$obj_id){
    // show errror html
    $html = <<< EOH
<table border="0">
<tr>
<td style="color:red;">
Missing object id!
</td>
</tr>
</table>
EOH;
    echo($html);
    return; // let script return
}else{
    $folder_id = $oxdata['ox_default_folder_calendar'];
    // fetch contact data
    try{
        $data = oxGetAppointment($oxdata,$obj_id,$folder_id);
    }catch(oXSessionTimeoutException $e){
        //echo "Session expired , loggin in again!";
        $session_is_expired = true;
        $oxdata = oXDoLogin($oxdata['ox_host'],$oxdata['ox_user'], $oxdata['ox_passwd'], false);
    }

    if($session_is_expired){
        // data is not defined, seems that session is expired
        $data = oxGetAppointment($oxdata,$obj_id,$folder_id);
    }

    $start_date = oXGetDisplayDate($oxdata,$data->start_date,null);
    $end_date = oXGetDisplayDate($oxdata,$data->end_date,null);


}
?>
<form method="POST" action="edit.php">
    <input type="hidden" name="module" value="calendar">
    <input type="hidden" name="action" value="edit_confirmation">
    <input type="hidden" name="obj_id" value="<?php echo $obj_id ?>">
    <input type="hidden" name="folder_id" value="<?php echo $folder_id ?>">
    <input type="hidden" name="last_modified" value="<?php echo $data->last_modified ?>">

    <table class="listview">

        <tr>
            <td class="listview_grey_column">
                <b><?php echo _("Detail view"); ?></b>
            </td>           
        </tr>
        <tr>
         <td class="listview_darkgrey_column">
                <?php echo $data->title; ?>
            </td>
        </tr>

        <tr>
            <td class="listview_grey_column">
                <b><?php echo _("Location"); ?></b>
            </td>            
        </tr>
        <tr>
        <td class="listview_darkgrey_column">
                <?php echo $data->location; ?>&nbsp;
            </td>
        </tr>

        <tr>
            <td class="listview_grey_column">
                <b><?php echo _("Begins"); ?></b>
            </td>            
        </tr>
        <tr>
        <td class="listview_darkgrey_column">
                <?php echo $start_date; ?>
            </td>
        </tr>

        <tr>
            <td class="listview_grey_column">
                <b><?php echo _("Ends"); ?></b>
            </td>            
        </tr>
        <tr>
        <td class="listview_darkgrey_column">
                <?php echo $end_date ?>
            </td>
        </tr>

        <tr>
            <td class="listview_grey_column">
                <b><? echo _("Confirmation Status");?></b>
            </td>
        </tr>
        <tr>

        <td class="listview_darkgrey_column">
            <?php
    
                $confirmation_msg = "";
                foreach ($data->users as $participant) {
                    if ($participant->id== $oxdata["ox_user_id"]){
                        $confirmation_msg = $participant->confirmmessage;
                        $confirmation_status = $participant->confirmation;
                    }
                }
    
                if ($confirmation_status) {
                        switch ($confirmation_status) {
                            case "0":
                            echo _("None");
                            break;
                            case "1":
                            echo _("Accepted");
                            break;
                            case "2":
                            echo _("Declined");
                            break;
                            case "3":
                            echo _("Tentative");
                            break;
                        }
                } else {
                    echo "&nbsp;";
                }
            ?>
               
            </td>
        </tr>

        <tr>
            <td class="listview_grey_column">
                <b><?php echo _("Comments"); ?>:</b>
            </td>            
        </tr>
        <tr>
        <td class="listview_darkgrey_column">
                <?php echo nl2br($data->note); ?>&nbsp;
            </td>
        <tr>

        <!--
            <tr>
                <td class="listview_darkgrey_column" colspan="2">
                    <input type="submit" name="edit_appt" value="<? /*echo _("Save");*/?>">
                </td>
            </tr>
        -->
    </table>
</form>