<?php

/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Manuel Kraft <manuel.kraft@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */

    class LoginFailedException extends Exception {
        private $error_code;
        public function __construct($message,$error_code_="") {
            $this->error_code = $error_code_;
            parent::__construct($message);
        }
        public function __toString() {
            return __CLASS__ . ": [{$this->code}]: {$this->message}\n";
        }
        public function getErrorCode() {
            return $this->error_code;
        }
    }

    class oXGetDataFailedException extends Exception {
        private $error_code;
        public function __construct($message,$error_code_="") {
            $this->error_code = $error_code_;
            parent::__construct($message);
        }
        public function __toString() {
            return __CLASS__ . ": [{$this->code}]: {$this->message}\n";
        }
        public function getErrorCode() {
            return $this->error_code;
        }
    }

    class oXSessionTimeoutException extends Exception {
        private $error_code;
        public function __construct($message,$error_code_="") {
            $this->error_code = $error_code_;
            parent::__construct($message);
        }
        public function __toString() {
            return __CLASS__ . ": [{$this->code}]: {$this->message}\n";
        }
        public function getErrorCode() {
            return $this->error_code;
        }
    }

    /**
     * @param <type> $hostname
     * @param <type> $user
     * @param <type> $pass
     * @param <type> $use_ssl
     * @return array Array needed for further methods of this API.
     * Fields: ox_sessionid - This is the OX SessionID.
     *         ox_cookies - Array with all Cookies set by OX Server.
     *         ox_host - String -> The OX Server which all requests will be made to.
     *         ox_user - String -> OX Username
     *         ox_passwd - String -> OX Password
     *         use_ssl - Boolean which indicates if SSL should be used to connect to OX Server.
     *         ox_lang - String -> The Locale of the User
     *         ox_timezone - String -> The Timezone of the User
     *         ox_user_id - int -> identifier of the user
     *         ox_display_name - String -> Display name of the user
     *         ox_default_folder_calendar - String -> Default calendar folder ID
     *         ox_default_folder_contacts - String -> Default contacts folder ID
     *         ox_default_folder_tasks - String -> Default tasks folder ID
     */
    function oXDoLogin($hostname, $user, $pass, $use_ssl) {       
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocol($use_ssl)."".$hostname."/ajax/login?action=login");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "name=".urlencode($user)."&password=".urlencode($pass));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, 1);

        // switch to ssl use
        if ($use_ssl==true) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,0);
        }
        $data_response = curl_exec($ch); // execute the curl command

        // always call handleCurlResponse to get the json response from curl
        // it will test if status code !=200 and if an error was returned by the server
        $jsondata = handleLoginResponse($ch,$data_response);

        $myccookies = getCookies(substr($data_response, 0, curl_getinfo($ch, CURLINFO_HEADER_SIZE)));
        $mysessionid = $jsondata->session;
        curl_close($ch);

        $oxdata = array("use_ssl"=>$use_ssl, "ox_sessionid" => $mysessionid , "ox_cookies"=>$myccookies,"ox_host"=>$hostname,"ox_user"=>$user,"ox_passwd"=>$pass);
        $lang = oXGetLanguage($oxdata);
        $timezone = oXGetTimezone($oxdata);
        $user_id = oXGetUserId($oxdata);
        $oxdata = array("use_ssl"=>$use_ssl, "ox_sessionid" => $mysessionid , "ox_cookies"=>$myccookies,"ox_host"=>$hostname,"ox_user"=>$user,"ox_passwd"=>$pass,"ox_lang"=>$lang,"ox_timezone"=>$timezone,"ox_user_id"=>$user_id);
        $display_name = oXGetDisplayName($oxdata);
        $oxdata = array("use_ssl"=>$use_ssl, "ox_sessionid" => $mysessionid , "ox_cookies"=>$myccookies,"ox_host"=>$hostname,"ox_user"=>$user,"ox_passwd"=>$pass,"ox_lang"=>$lang,"ox_timezone"=>$timezone,"ox_user_id"=>$user_id,"ox_display_name"=>$display_name);

        $default_folder = oXGetDefaultFolder($oxdata);
        $calendar_folder = $default_folder->calendar ;
        $tasks_folder = $default_folder->tasks ;
        $contacts_folder = $default_folder->contacts ;

        $oxdata = array("use_ssl"=>$use_ssl, "ox_sessionid" => $mysessionid , "ox_cookies"=>$myccookies,"ox_host"=>$hostname,"ox_user"=>$user,"ox_passwd"=>$pass,"ox_lang"=>$lang,"ox_timezone"=>$timezone,"ox_user_id"=>$user_id,"ox_display_name"=>$display_name,"ox_default_folder_calendar"=>$calendar_folder,"ox_default_folder_contacts"=>$contacts_folder,"ox_default_folder_tasks"=>$tasks_folder);
        return $oxdata;
    }
    
    global $TIMESTAMP_ONE_MONTH;
    $TIMESTAMP_ONE_MONTH=2592000000;
    function getTimestamp($add) {
        $time = bcmul(time(),1000); // 
        return (bcadd($time, $add));
    }

    /**
     * Returns all appointments within the users private folder
     *
     * If start and end date are supplied with "" then a list with apps for next 7 days is fetched
     * @param <type> $oxdata
     * @param <type> $start_date
     * @param <type> $end_date
     * @return <type>
     */
    function oxGetAppointmentList($oxdata, $start_date, $end_date, $folder_id){
        global $TIMESTAMP_ONE_MONTH;
        $ch = curl_init();
        if (!$start_date) {
            $start_date = bcmul(mktime(0, 0, 0, date("n"), date("j"), date("y")),1000);;
        }
        if (!$end_date) {
            $end_date =  getTimestamp($TIMESTAMP_ONE_MONTH); // next month
        }
        $folder = "";
        if ($folder_id) {
            $folder = "folder=".$folder_id;
        }
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata)."".$oxdata["ox_host"]."/ajax/calendar?".$folder."&action=all&sort=201&order=asc&start=".$start_date."&end=".$end_date."&columns=1,200,201,202,20,400,401&session=".$oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data;
    }

    /**
     * Fetch a complete appointment from the server
     *
     * @param <type> $oxdata
     * @param <type> $object_id Of the appointment
     * @param <type> $folder_id Of the calendar folder
     * @return array with detailed data about the appointment
     *
     * #### Detailed infos about the data array ####
     *
     * id = id of this object
     * folder_id = folder id where the object resides in
     * title - Title of requested appointment
     * note - note/comment regarding the appointment
     * location - Location of the appointment, e.g Berlin
     * recurrence_position -
     * shown_as - Describes, how this appointment appears in availability queries:
     * 1 -> reserved
     * 2 -> temporary
     * 3 -> absent
     * 4 -> free
     * categories - Each element is a string, naming a category/tag
     * start_date - Start date
     * end_date - End date
     * timestamp - needed for updating the requested object
     * created_by - Id of the user who created this appointment
     * creation_date - the date when the object was created on the server
     * modified_by - id of the user who modified the object
     * last_modified - date of last modification of this object in "user time"
     * number_of_attachments - count of attached documents
     * participants - participants and their details like internal(1) or external(2) and their corresponding id
     * users - details of the confirmation regarding this appointment
     * "confirmation" field :
     * 0 -> none
     * 1 -> accepted
     * 2 -> declined
     * 3 -> tentative
     * "id" field:
     * If of the user/contact which confirmed to this appointment
     *
     * private_flag - true if this appointment is a pure private appointment , else false
     * color_label - how this object should be displayed
     * full_time - true if this appointment is a full time appointment else false
     */
    function oxGetAppointment($oxdata, $object_id, $folder_id) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata)."".$oxdata["ox_host"]."/ajax/calendar?id=".$object_id."&folder=".$folder_id."&action=get&session=".$oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data;
    }

    /**
     * WORKS ONLY WITH PHP >= 5.2 :
     * Because the older php cannot write temporary into the memory of the machine!
     *
     * I will not write a single temp. file for every PUT request as suggested in the curl docs! Not very common :-|
     *
     * Updates an appointment confirmation status with message!
     * ONLY for the current user!
     *
     * @param <type> $oxdata
     * @param <type> $object_id Of the appointment
     * @param <type> $folder_id Of the appointment folder
     * @param <type> $status_id one of 0,1,2,3
     * @param <type> $status_msg text message regarding the appt. status
     */
    function updateConfirmationForAppointment($oxdata, $object_id, $folder_id, $status_id, $status_msg){
        $json_object = "[{\"module\":\"calendar\",\"action\":\"confirm\",\"data\":{\"folder_id\":$folder_id,\"id\":$object_id,\"confirmmessage\":\"$status_msg\",\"confirmation\":$status_id}}]";

        // workaround because PUT with curl always needs a file instead of string as the PUT body
        // WORKS ONLY WITH PHP >= 5.2
        $fh = fopen('php://memory', 'rw');
        fwrite($fh, $json_object);
        rewind($fh);
        $length = strlen ($json_object);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata)."".$oxdata["ox_host"]."/ajax/multiple?session=".$oxdata['ox_sessionid']);
        
        // workaround
        curl_setopt($ch, CURLOPT_PUT, 1);
        curl_setopt($ch, CURLOPT_INFILE, $fh);
        curl_setopt($ch, CURLOPT_INFILESIZE, $length);
        curl_setopt($ch, CURLOPT_HTTPHEADER, Array("Content-Type: text/javascript","Expect:"));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        fclose($fh);
        return $jsondata->data;
    }

    /**
     * 1 id
     * 4  creation_date
     * 5  last_modified
     * 200 title
     * 201 start_date
     * 202 end_date
     * 203 note
     * 300 status
     * Status of the task:
     * 1 	not started
     * 2 	in progress
     * 3 	done
     * 4 	waiting
     * 5 	deferred
     * 301 percent_completed
     * 302 actual_costs
     * 303 actual_duration
     * 309 priority
     * Number 	 1 = LOW, 2 = MEDIUM, 3 = HIGH
     *
     * @param <type> $oxdata
     * @param <type> $folder_id
     * @return <type>
     */
    function oxGetTaskList($oxdata, $folder_id) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata) . "" .  $oxdata["ox_host"]. "/ajax/tasks?action=all&sort=202&order=asc&folder=".$folder_id."&columns=1,4,5,200,201,202,203,300,301,302,303,309&session=" . $oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data;
    }
    
    /**
     *
     * Fetch whole task from server
     * @param array $oxdata
     * @param String $contact_id
     * @param String $folder_id
     * @return array containning the infos of the requestes object
     *
     * Detailed field (NAME) infos about the returned array:
     * http://www.open-xchange.com/wiki/index.php?title=HTTP_API#DetailedTaskAndAppointmentData
     */
    function oXGetTask($oxdata, $contact_id, $folder_id) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata)."".$oxdata["ox_host"]."/ajax/tasks?id=".$contact_id."&folder=".$folder_id."&action=get&session=".$oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);

        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data;
    }

    /**
     * If contact folder is not specified, contacts from public adressbook folder is fetched
     * @param <type> $oxdata
     * @param <type> $contact_folder
     * @return array containing the contact objects as each element
     *
     * Array Details:
     * <column-id> -  <field> -> <position>
     * 
     * FIXME MANUEL!
     */
    function oxGetContactList($oxdata, $contact_folder) {
        $ch = curl_init();
        if (!$contact_folder) {
            $contact_folder = 6;
        }
        /*
                1        contact id   ->0
                500      displayname  ->1
                542 	 Telephone business 1 ->2
                543 	 Telephone business 2 ->3
                547 	 Telephone company ->4
                548 	 Telephone home 1  ->5
                549 	 Telephone home 2 ->6
                551 	 Cellular telephone 1 ->7
                552 	 Cellular telephone 2 ->8
                553 	 Telephone other .>9
                555 	 Email business ->10
                558 	 URL ->11
                508      city home ->12
                506      street home ->13
                501      first_name -> 14
                502      last name -> 15
                526      city business -> 16
         *      551      Cellular telephone business -> 17
         *      569      Company -> 18
         */
         
        $columns = "1,500,542,543,547,548,549,551,552,553,555,558,508,506,501,502,526,551,569";
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata)."".$oxdata["ox_host"]. "/ajax/contacts?sort=502&order=asc&action=all&order=asc&columns=".$columns."&folder=".$contact_folder."&session=".$oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data;
    }

    function oXGetContact($oxdata, $contact_id, $folder_id) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata) . "" .  $oxdata["ox_host"]. "/ajax/contacts?id=".$contact_id."&folder=".$folder_id."&action=get&session=" . $oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data;
    }

    function oXDoLogout($oxdata) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata). "" .$oxdata['ox_host'] . "/ajax/login?action=logout&session=" . $oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        }
        handleResponse($ch);
        curl_close($ch);
    }

    function oXGetLanguage($oxdata) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata)."".$oxdata['ox_host']."/ajax/config/language?session=".$oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data;
    }

    function oXGetUserId($oxdata) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata)."".$oxdata['ox_host']."/ajax/config/identifier?session=".$oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data;
    }

    function oXGetDisplayName($oxdata) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata)."".$oxdata['ox_host']."/ajax/contacts?action=getuser&id=".$oxdata['ox_user_id']."&session=".$oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) { 
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data->display_name;
    }

    /**
     * Calculate and return a date , for example for an appointment !
     * @param $oxdata Needed for localization and the timezone of the user, calculates the offset etc.
     * @param $timestamp The date which should be made "displayable".
     * @return String with parsed date like 10.10.2009 14:33
     */
    function oXGetDisplayDate($oxdata, $timestamp, $pattern) {
        date_default_timezone_set('UTC');
        //$dateTime = new DateTime();
        //$dateTime->setTimezone('UTC');
        //$offset = $dateTime->getOffset();
        $dateTime = new DateTime(date("c",$timestamp/1000-$offset),new DateTimeZone('UTC'));
        return $dateTime->format($pattern ? $pattern : "d.m.Y H:i");
    }

    /**
     * Calculate and return a date for a task date (just DD.MM.YYYY) !
     * @param $oxdata Needed for localization and the timezone of the user, calculates the offset etc.
     * @param $timestamp The date which should be made "displayable".
     * @return String with parsed date like 10.10.2009 14:33
     */
    function oXGetDisplayDateTasks($oxdata, $timestamp) {
        date_default_timezone_set('UTC');
        //$dateTime = new DateTime();
        //$dateTime->setTimezone(new DateTimeZone($oxdata["ox_timezone"]));
        //$offset = $dateTime->getOffset();
        $dateTime = new DateTime(date("c",$timestamp/1000-$offset),new DateTimeZone('UTC'));
        return $dateTime->format("d.m.Y");
    }

    function oXGetMailAddresses($mailconfig){
        return $mailconfig->addresses;
    }

    function oXGetSendAddress($mailconfig){
        return $mailconfig->sendaddress;
    }

    function oXGetTimezone($oxdata) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata) . "" .  $oxdata['ox_host']. "/ajax/config/timezone/?session=" . $oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data;
    }
    
    /**
     *
     * @param <type> $oxdata
     * @return <type>
     */
    function oXGetDefaultFolder($oxdata) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata) . "" .  $oxdata['ox_host']. "/ajax/config/folder?session=" . $oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,0);
        }        
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data;
    }

    function oXGetMailConfiguration($oxdata) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, getProtocolByArray($oxdata)."".$oxdata['ox_host']."/ajax/config/mail?session=".$oxdata['ox_sessionid']);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIE, $oxdata['ox_cookies']);
        if (useSSL($oxdata)) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,0);
        }
        $jsondata = handleResponse($ch);
        curl_close($ch);
        return $jsondata->data;
    }
    
    function oXGetDisplayNameFromContact($contact_object) {
        $displayname;
        if ($contact_object->display_name) {
            $displayname = $contact_object->display_name;
        } else {
            if ($contact_object->first_name && $contact_object->last_name) {
                $displayname = $contact_object->first_name." ".$contact_object->last_name;
            }
            if ($contact_object->first_name) {
                $displayname = $contact_object->first_name;
            }
            if ($contact_object->last_name) {
                $displayname = $contact_object->last_name;
            }
        }
        return $displayname;
    }


    // added returning json data if request was successfull
    function handleLoginResponse($ch,$data_response) {
        $return_code = curl_getinfo($ch,CURLINFO_HTTP_CODE);
        if (curl_error($ch)) {
            throw new oXGetDataFailedException(curl_error ($ch));
        }
        if ($return_code != 200) {
            $error_message;
            switch ($return_code) {
                case 404:
                $error_message = "Not found! - ".$return_code;
                break;
                case 500:
                $error_message = "Internal server error - ".$return_code;
                break;
                case 301:
                $error_message = "Moved permanently - ".$return_code;
                break;
            }
            if ($error_message) {
                throw new oXGetDataFailedException($error_message);
            } else {
                throw new oXGetDataFailedException(curl_error ($ch));
            }
        } else {
            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            // return the actual json object back
            $response_body = substr($data_response, $header_size);
            $jsondata = json_decode($response_body);
            if ($jsondata->error) {
                throw new LoginFailedException($jsondata->error,$jsondata->code);
            } else {
                return $jsondata;
            }
        }
    }

    function handleResponse($ch) {
        $data_response = curl_exec($ch);
        $return_code = curl_getinfo($ch,CURLINFO_HTTP_CODE);
        if (curl_error($ch)){
            throw new oXGetDataFailedException(curl_error ($ch));
        }
        if ($return_code!=200) {
            $error_message ;
            switch ($return_code) {
                case 404:
                $error_message = "Not found! - ".$return_code;
                break;
                case 500:
                $error_message = "Internal server error - ".$return_code;
                break;
                case 301:
                $error_message = "Moved permanently - ".$return_code;
                break;
            }
            if ($error_message) {
                throw new oXGetDataFailedException($error_message);
            } else {
                throw new oXGetDataFailedException(curl_error ($ch));
            }
        } else {
            $jsondata = json_decode($data_response);
            if ($jsondata->error) {
                if ($jsondata->code && $jsondata->code=="SES-0203") {
                    // session is expired
                    throw new oXSessionTimeoutException($jsondata->error,$jsondata->code);
                } else {
                    throw new oXGetDataFailedException($jsondata->error,$jsondata->code);
                }
            } else {
                return $jsondata;
            }
        }
    }

    function getProtocolByArray($oxdata) {
        return getProtocol($oxdata["use_ssl"]);
    }

    function getProtocol($use_ssl) {
        if ($use_ssl==true) {
            return "https://";
        } else {
            return "http://";
        }
    }

    function useSSL($oxdata) {
        return $oxdata["use_ssl"];
    }

    function getCookies($header) {
        preg_match_all('/^Set-Cookie:\s+(.*);/mU', $header, $matches);
        $cookie = implode(';', $matches[1]);
        return $cookie;
    }

    /*
     * $myoptions must be associatives array like
     * array(0=>'none',1=>'accepted',2=>'declined',3=>'tentative');
     * $selected must be the key of an element within the array like 2
    */
    function getSelectOptionsForm($myoptions,$selected) {
        $retval = "";
        foreach (array_keys($myoptions) as $key){
            if($key==$selected){
                $retval .= "<option value=\"$key\" selected>$myoptions[$key]</option>\n";
            }else{
                $retval .= "<option value=\"$key\">$myoptions[$key]</option>\n";
            }
        }
        return $retval;
    }

    function isWebKit() {
        $useragent  = strtolower($_SERVER['HTTP_USER_AGENT']);
        $httpaccept = strtolower($_SERVER['HTTP_ACCEPT']);
        if (stripos($useragent, 'webkit') > -1)
             return true; 
        else
             return false; 
    }
?>