<?php

/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Manuel Kraft <manuel.kraft@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */


class Cipher {
    private $securekey, $iv;
    function __construct() {
        global $mysecret;
        $this->securekey = hash('sha256',$mysecret,TRUE);
        $this->iv = mcrypt_create_iv(32,MCRYPT_DEV_URANDOM);
    }
    function encrypt($input) {
        return base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $this->securekey, $input, MCRYPT_MODE_ECB, $this->iv));
    }
    function decrypt($input) {
        return trim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $this->securekey, base64_decode($input), MCRYPT_MODE_ECB, $this->iv));
    }
}



function checkLogin($ox_server, $use_ssl) {
    global $username, $passwd, $error,$remembercredentials,$expire_days;

    $username = trim($_POST['user']);
    if (isset($_GET['user'])) {
        $username = trim($_GET['user']);
    }
    $passwd = trim($_POST['passwd']);
    if (isset($_GET['passwd'])) {
        $passwd = trim($_GET['passwd']);
    }

    if ($username && $passwd && isset ($username { 1 }) && isset ($passwd { 1 })) {

        try {
            // connect to ox and login, if login is ok, redirect to main page
            $ox_data = oXDoLogin($ox_server, $username , $passwd, $use_ssl);
            $language = oXGetLanguage($ox_data);
            session_start();

            $_SESSION["language"] = $language;
            $_SESSION["ox_data"] = $ox_data; // here is sessionid,cookies ,username,password saved

            // Remember username/password via cookie ?
            if($remembercredentials){
                // crypt via cipher class
                $cipher = new Cipher();
                $expired_time = time()+60*60*24*$expire_days;
                setcookie("ugas", base64_encode($cipher->encrypt($passwd)),$expired_time);
                setcookie("uga", base64_encode($cipher->encrypt($username)),$expired_time);
            }

        } catch (LoginFailedException $e){
            $error = $e;
            //header("location:index.php?user=" . $username."&err_code=".$e->getErrorCode()."&msg=".$e->getMessage());
        } catch (oXGetDataFailedException $e2){
            $error = $e2;
            //header("location:index.php?user=" . $username."&err_code=".$e2->getErrorCode()."&msg=".$e2->getMessage());
        }

        $sessionid = $ox_data['ox_sessionid'];
    }
    setAppLocale(); 
}

?>