/* each folder tree should use this cache */
function ox_folder_cache(){	
	/* register all events here */	
	this.events = new Events();
	/* contains all folders which are stored hierarchically in storagecaches */
	this.folders = {"root":{children:null,parent:null,oxfolder:null}};
	var Self = this;
	this.columns = "1,301,300,307,304,306,302,305,308,311,2,314,313,315";
	this.fast_access = new Object();
	this.timestamp = 0;
}

ox_folder_cache.prototype = {

	/* load the root folders or all folder defined in oState */
	load_folders : function (oState, join_param, bReplace) {
		var Self = this;
		var join_fn = join_param.add( function (arg){ join_param.arg = arg; } );
		if (Self.folders["root"].children != null && !bReplace) {
			for (var nfldrN in Self.folders["root"].children[nfldrN]) {											
				if(oState && oState[Self.folders["root"].children[nfldrN].oxfolder.data.id]) {
					Self.load_subfolders(
					       Self.folders["root"].children[nfldrN].oxfolder.data.id,
					       Self.folders["root"].children[nfldrN],
					       oState[nfldrN], join_param, bReplace 
				    );
				}														
			}		
			join_fn(Self.folders);			
		} else {
			var locJson = new JSON();		
			locJson.get("/ajax/folders?action=root&columns="+this.columns+"&session="+session,null,
									function(arg) {		
											Self.folders["root"].children = {};
											Self.timestamp = arg.timestamp;
											for (var nfldr=0;nfldr<arg.data.length;nfldr++)
											{											
												Self.folders["root"].children[arg.data[nfldr][0]] = 
																{oxfolder:new ox_folder(arg.timestamp,arg.data[nfldr]),parent:Self.folders["root"],
																																		children:null};
												Self.fast_access[Self.folders["root"].children[arg.data[nfldr][0]].oxfolder.data.id] = Self.folders["root"].children[arg.data[nfldr][0]];
												if(oState && oState[arg.data[nfldr][0]])
												{
													Self.load_subfolders(arg.data[nfldr][0],Self.folders["root"].children[arg.data[nfldr][0]],
																		oState[arg.data[nfldr][0]],join_param,bReplace);
												}														
											}		
											join_fn(Self.folders);							
										});		
		}
		
	},
	
	do_load_subfolders : function (nId,refer,oState,callback,bReplace){
		this.load_subfolders(nId, refer, oState, 
		      new Join(
		              function() {
		                  callback(this.arg);
		              }
		      ), bReplace);
	},
	
	/*loads subfolders from server*/
    load_subfolders : function (nId, refer, oState, join_param, bReplace) {
        var Self = this;
        
        var join_fn = join_param.add(
              function (arg) {
                  join_param.arg = arg;
              }
        );
    
        if (refer.children != null && !bReplace) {
            for (var nfldrN in refer.children) {
                if(oState && oState[nfldrN]) {
                    Self.load_subfolders(nfldrN, refer.children[nfldrN], oState[nfldrN], join_param, bReplace);
                }                                                   
            }                   
            join_fn(refer);     
        } else {
            var callback = (function(nId, refer, oState, join_param, bReplace, join_fn) {
                return function(arg) {                  
                    // if children loaded before server responsed
                    if(refer.children != null && !bReplace) {
                        join_fn(refer); 
                        return;
                    }
                    refer.children = {};
                    if (nId == 2) Self.GALPresent = false;
                    for (var nfldr=0; nfldr<arg.data.length; nfldr++) {
                        var id = arg.data[nfldr][0];
                        if (id == 6) Self.GALPresent = true;
                        refer.children[id] = 
                            { "oxfolder": new ox_folder(arg.timestamp, arg.data[nfldr]),
                              "parent"  : refer,
                              "children": null
                            };
                        var oldrefer = null;
                        if (refer.oxfolder.data.id == configGetKey("folder.infostore") && Self.fast_access[id] != undefined) {
                            var child = Self.fast_access[id].children;
                            refer.children[id] = 
                                { "oxfolder": new ox_folder(arg.timestamp, arg.data[nfldr]),
                                  "parent"  : refer, 
                                  "children": (isEmpty(child) ? null : child) 
                                };
                        }
                            
                        Self.fast_access[refer.children[id].oxfolder.data.id] = refer.children[id]; 
                        if (oState && oState[id]) {
                            Self.load_subfolders(id, refer.children[id],
                                                 oState[id], join_param, bReplace);
                        }                                                   
                    }
                    join_fn(refer);
                };
            })(nId, refer, oState, join_param, bReplace, join_fn);
            
            (new JSON()).get(AjaxRoot + "/folders?action=list&all=1"
                 + "&columns=" + this.columns 
                 + "&parent=" + getUrlEncodedString(nId) 
                 + (configContainsKey("modules.folderstorage") ? "&tree=1" : "")
                 + "&session=" + session, null, callback);
        }
    },
	
	updateFolders : function(folderIDs, fn_cb) {
        var Self = this;
        var locJson = new JSON();
        var _reqParams = new Array();
        for (var i in folderIDs) {
            _reqParams.push( { module: "folder", action: "get", id: folderIDs[i], columns: this.columns } );
        }
        locJson.put(AjaxRoot + "/multiple?session=" + session, _reqParams, null, 
            function(resp) {
                for (var ia=0; ia<resp.length; ia++) {
                    var _tmp = resp[ia];
                    if (_tmp.error && _tmp.error_id) continue;
                    var _oFolder = Self.find_folder(_tmp.data.id);
                    _oFolder.oxfolder = { timestamp: 0, ENABLED: true, data: _tmp.data };
                    Self.fast_access[_tmp.data.id].oxfolder = _oFolder.oxfolder;
                }   
            }
        );
    },
	
	/* loads the path and all folder siblings */
	load_path : function (nId, join_param, bNOReplace){
		var Self = this;
		var sAjaxRequest = AjaxRoot + '/folders?action=path'
		                 + '&session=' + session 
		                 + '&id=' + getUrlEncodedString(nId) 
		                 + '&columns=1,300';
		var pathJson = new JSON();
		
		function cb_fn_path(arg) {
			var oState = {};
			var statetmp  = oState;
			var bFoundFolder = false;
			var oRefer;
			/*
			 * fixed bug, in this case is the requested folder a first level folder and it must be present
			 * return the path
			 */
			if (arg.data.length <= 1) {
				var join_fn = join_param.add(
			        function (arg, arg2) {
			            if (arg) join_param.arg = arg;
			            if( arg2) join_param.arg2 = arg2;
			        }
				);		
				join_fn(Self.fast_access[nId], arg.data);
				return;
			}
			join_param.arg2 = arg.data;
			for (var indx=(arg.data.length-1); indx>0; indx--) {
				//found the last loaded node and load the rest
				if (!bFoundFolder && Self.fast_access[arg.data[indx][0]] != undefined) {
					oRefer = Self.fast_access[arg.data[indx][0]];
				} else {
					if (!bFoundFolder) {
						nParentId = arg.data[indx][0];				
					}
					bFoundFolder = true;
					statetmp[arg.data[indx][0]] = {};
					statetmp = statetmp[arg.data[indx][0]];
				}
			}
			var join_fn = join_param.add(
			    function (arg, arg2) {
			    	if (arg) join_param.arg = arg;
			        if (arg2) join_param.arg2 = arg2;
			    }
			);				
			//if node not found, load complete path
			if (oRefer == undefined) {
				join_param.count--;
				Self.load_folders(oState, join_param, true);
				
			} else if(oRefer.children == null || oRefer.children != null && oRefer.children[nId] == undefined) {
				join_param.count--;			
				Self.load_subfolders(oRefer.oxfolder.data.id, oRefer, oState, join_param, (true && !bNOReplace));
				
			} else {
				join_fn(oRefer.children[nId], arg.data);
			}
		}
		pathJson.get(sAjaxRequest,null,cb_fn_path);
	},
	
	/* updates all folders; fetches new subfolder if availible, removes deleted folder from cache */
	update : function (nIdOpt, bWith_mail, fn_callback_opt) {
		var Self = this;
		var locJson = new JSON();
		var sAjaxRequest = AjaxRoot + "/folders?action=updates"
	            + "&columns=1,300&mail=" + (bWith_mail ? 1 : 0) 
	            + "&timestamp=" + this.timestamp + "&session=" + session;
	            		
		function cb_fn_updates(arg){
			var aReferences = new Array();
			if (arg.data) {
				Self.timestamp = arg.timestamp;
						
				//separate folder, which will be updated in cache
				var aRootNodes = new Object();
				function fn_traverse(refer) {
					for (var indx in refer.children) {
						var nFound = 0;
						for (var indxResp=0; indxResp<arg.data.length; indxResp++) {
							//first condition is for deleted folder identification
							if (arg.data[indxResp][1] != undefined && arg.data[indxResp][0] == indx) {						
								nFound = 1;
								break;
							} else if (arg.data[indxResp][1] == undefined && arg.data[indxResp][0] == indx) {					
								nFound = 2;
								break;
							}
						}
						//don't traverse the subtree, if the parent of the sub tree must be updated;
						//all subtree elements will be updated automatically
						//->added != 10 condition to update links correcty
						if (nFound != 0 && Self.fast_access[indx].parent.oxfolder && Self.fast_access[indx].parent.oxfolder.data.id != 10) {					
							if (aRootNodes[Self.fast_access[indx].parent.oxfolder.data.id] == undefined) {
								aRootNodes[Self.fast_access[indx].parent.oxfolder.data.id] = new Array();
								aRootNodes[Self.fast_access[indx].parent.oxfolder.data.id].push({id:indx,type:nFound});
							} else {
								aRootNodes[Self.fast_access[indx].parent.oxfolder.data.id].push({id:indx,type:nFound});
							}
							
						} else if (nFound != 0) {					
							if (aRootNodes[Self.fast_access[indx].oxfolder.data.id] == undefined) {
								aRootNodes[Self.fast_access[indx].oxfolder.data.id] = new Array();
								aRootNodes[Self.fast_access[indx].oxfolder.data.id].push({id:indx,type:nFound});
							} else {
								aRootNodes[Self.fast_access[indx].oxfolder.data.id].push({id:indx,type:nFound});
							}
						} else {
							fn_traverse(refer.children[indx]);
						}
					}
				}
				fn_traverse(Self.folders["root"]);
				if (!fn_callback_opt) {
					fn_callback_opt = function () {};
				}
				var outer_join = new Join(fn_callback_opt);
				for (var nNum in aRootNodes) {
					var oRefer = Self.fast_access[nNum];
					var oReferState = Self.compute_state(oRefer);
					var fn_out_join = outer_join.add();
		//			delete oRefer.parent.children;
		//			oRefer.parent.children = {};			
					function close_it(obj,aFolders,fn_out_join_close) {
						return function () {
							Self.events.trigger("Changed",obj);
							if (fn_out_join_close) {
								fn_out_join_close();
							}
					    }
					}
					Self.load_subfolders(oRefer.oxfolder.data.id, oRefer, oReferState, 
					       new Join(close_it(oRefer, aRootNodes[nNum], fn_out_join)), true);
				}
			}
		}
		locJson.get(sAjaxRequest, null, cb_fn_updates);
	},
	
	compute_state : function (refer){
		function fn_traverse(refer) {
			var retval = {};
			for (var i in refer.children) {
				var bSubChilds = false
				for (var j in refer.children[i].children) {
					bSubChilds=true;				
				}
				if (bSubChilds) {
				    retval[refer.children[i].oxfolder.data.id] = fn_traverse(refer.children[i]);
				}			
			}
			return retval;
		}
		var oState = fn_traverse(refer);
		return oState;
	},
	
	find_folder : function (nId){
		var Self = this;
		var oFolder = null;		
		function fn_traverse(refer) {
			for (var indx in refer.children) {
				if (indx != nId) {
					fn_traverse(refer.children[indx]);				
				} else {
					oFolder = refer.children[indx];
					return;
				}
			}
		}
		fn_traverse(this.folders["root"]);
		return oFolder;
	},
	
	/*loads a folder if not loaded*/
	get_folder : function (nId,callback){
		var Self = this;
		var oFolder = null;
		// trying fast acess cache
		oFolder = this.fast_access[nId];
		if (oFolder == undefined) {
			// not found, so trying to find it in regular cache
			oFolder = this.find_folder(nId);
		}
		//request the folder if that could not be found
		if (oFolder == null) {		
			this.load_path(nId, 
			     new Join(
				     function () {
				     	callback(this.arg);
				     }
				 ), true);
		} else if (callback) {	
			callback(oFolder);
		}
	}
}

function ox_folder(timestamp, dataArray) {
	this.data = new Object();	
	if (dataArray && dataArray.length > 11) {
		this.data.id = dataArray[0];
		this.data.module = dataArray[1];
		this.data.title = dataArray[2];
		this.data.summary = dataArray[3];
		this.data.subfolders = dataArray[4];
		this.data.permissions=dataArray[5]; 
		this.data.type = dataArray[6];
		this.data.own_rights=dataArray[7]; 
		this.data.standard_folder = dataArray[8];	
		this.data.unread= dataArray[9];
		this.data.created_by = dataArray[10];
		this.data.subscribed = dataArray[11];		
		this.data.capabilities = dataArray[12];
		this.data.subscr_subflds = dataArray[13];
	}
	
	this.timestamp = timestamp;
	//flags
	this.ENABLED = true;
}