/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */
 
/* TODO:
 * popup
 * static context menu
 * dynamic context menu
 * submenu (context menu)
 * pseudo-window: header, moving
 */
/**
 * Displays a popup.
 * @param {Object} content The DOM node which contains the popup.
 * @param {Int} x Optional horizontal position of the left edge of the popup.
 * @param {Int} y Optional vertical position of the top edge of the popup.
 */
displayAt = function(content, x, y, cb) {
	if (x && y) {
		content.style.left = x;
		content.style.top = y;
	}
	fade(content,0,100,500,cb);
};
var popupenabled=false;
/**
 * Displays a popup which disappears when the user clicks anywhere else.
 * @param {Object} content The DOM node which contains the popup.
 * @param {Int} x Optional horizontal position of the left edge of the popup.
 * @param {Int} y Optional vertical position of the top edge of the popup.
 */
var popup;
var popupHide;

(function() {

	var popups = [];	

	register("Loaded", function (){
		var moving = null;
		var offsetX, offsetY;
		var body = $("body");
		popupHide = function() {
			for (var i in popups) {
				if(popups[i].onhide) {
					popups[i].onhide();
				}
                fade_setOpacity(popups[i].popup, 0, false);
                showIFrames();
                popupenabled=false;
                popups.splice(i,1);
			}
		}
		addDOMEvent(body, "click", popupHide);
		addDOMEvent(body, "contextmenu", function(e) {
			popupHide();
			var DOMTarget = (e.target) ? e.target : e.srcElement;
			if (DOMTarget != undefined && DOMTarget.nodeName != "TEXTAREA") {				
				stopEvent(e);
				delete(DOMTarget);
				return false;
			}
			delete(DOMTarget);
		});
		for (var i in init.movable) {
			var node = $(init.movable[i]);
			(function(node, parent) {
				addDOMEvent(node, "mousedown", function(e) {
					if (e.button != LeftButton) return;
					moving = parent;
					offsetX = parent.offsetLeft - e.clientX;
					offsetY = parent.offsetTop - e.clientY;
					parent.style.cursor = "move";
					function moveHandler(e) {
						var topposition=(e.clientY + offsetY);
						var leftposition=(e.clientX + offsetX);
						if(topposition<0) {
							topposition=0;
						}
						else if(topposition+parent.offsetHeight > $("body").offsetHeight) {
							topposition=$("body").offsetHeight-parent.offsetHeight;
						}
						if(leftposition<0) {
							leftposition=0;
						}
						else if(leftposition+parent.offsetWidth > $("body").offsetWidth) {
							leftposition=$("body").offsetWidth-parent.offsetWidth;
						}
						moving.style.left = leftposition + "px";
						moving.style.top = topposition + "px";
						stopEvent(e);
					}
					function upHandler(e) {
						if (moving && e.button == LeftButton) {
							moving = null;
							parent.style.cursor = "auto";
							removeDOMEvent(body, "mousemove", moveHandler);
							removeDOMEvent(body, "mouseup", upHandler);
							//removeDOMEvent(body, "mouseout", upHandler);
							stopEvent(e);
						}
					}
					addDOMEvent(body, "mousemove", moveHandler);
					addDOMEvent(body, "mouseup", upHandler);
					//addDOMEvent(body, "mouseout", upHandler);
					cancelDefault(e);
				});
				addDOMEvent(node.firstChild, "click", function() {
					parent.style.display = "none";
				});
			})(node, node.parentNode);
		}
	});
	popup = function(content, x, y, onhide, type, leave_open) {
		/*
		 * @todo  now we have the same behaviour like the context menus under a well known OS.
		 *        only the panel menus doesn't behave as they should. a click should
		 *        enable / disable such menus. right now a click re-enables it all the time. 
		 */
		popupHide();
        hideIFrames();
        popupenabled=true;
        displayAt(content, x, y);
        setTimeout(function() {
            popups.push({popup: content, onhide: onhide, type : type, leave_open : leave_open }); 
        }, 0);
	};
	
})();
function centerPopupWindow(popupwindow) {
	var windowheight=$("body").offsetHeight;
	var windowwidth=$("body").offsetWidth;
	var tmpnode=popupwindow.cloneNode(true);
	tmpnode.style.display="block";
	tmpnode.style.zIndex=-1;
	body.appendChild(tmpnode);
	var popupwindowheight=tmpnode.offsetHeight;
	var popupwindowwidth=tmpnode.offsetWidth;
	body.removeChild(tmpnode);
	popupwindow.style.left =((windowwidth/2) -(popupwindowwidth/2)) +"px";
	popupwindow.style.top =((windowheight/2) -(popupwindowheight/2)) +"px";
}

/**
 * Adds a DOM event listener to the onclick event of the "Close" icon in the
 * right top corner of a popup window.
 * @param {Object} popupwindow The DOM node of the popup window.
 * @param {Function} onclose The callback function which will be called when
 * the popup window is closed by clicking on the "Close" icon.
 */
function addOnClose(popupwindow, onclose) {
	addDOMEvent(getElement(popupwindow.firstChild).firstChild, "click", onclose);
}

/**
 * Removes a previously added DOM event listener from the onclick event of
 * the "Close" icon in the rihgt top corner of a popup window.
 * @param {Object} popupwindow The DOM node of the popup window.
 * @param {Function} onclose The callback function which was supplied in
 * a previous call to {@link addOnClose}.
 */
function removeOnClose(popupwindow, onclose) {
	removeDOMEvent(getElement(popupwindow.firstChild).firstChild, "click", onclose);
}

/**
 * Adds a context menu to an element. the context menu must be a child of
 * the document body.
 * @param {Object} parent The DOM element to which the context menu is added.
 * @param {Object} menu The DOM element which contains the context menu.
 */
function addContextMenu(parent, menu,contxParam) {
	
	addDOMEvent(parent, "contextmenu", function(e) {
		if (e && e.button && e.button != RightButton) return;
		var newRefer  = contxParam.node;
		menu.context = newRefer;		
		popup(menu.div, e.clientX + "px", e.clientY + "px",function (){contxParam.onhide(newRefer)},"contextmenu2",true);
		menu.events.trigger('OX_Tree_Popup_Menu_Down',menu,parent);
		stopEvent(e);		
	});
}

/**
 * @param {Object} parent Optional absolutely positioned DOM element which
 * serves as the parent node for the popup menu. Defaults to the document body.
 */
function Popup(parent, contDiv) {
	this.entries = [];
	this.context;
	this.parent = parent || $("body");
	this.div = contDiv || newnode("div", {display: "none", position: "absolute"});
	this.parent.appendChild(this.div);
	this.events = new Events();
}

/**
 * @private
 */
Popup.makeDiv = function(entry) {
	return typeof(entry) == "string" ? newnode('div',0,{className:"PopupEntryDiv"},[addTranslated(entry)])
	                                 : entry;
}

Popup.prototype = {

	/**
	 * @param {Object or String} entry The new menu entry either as a DOM node
	 * or as a string.
	 */
	append: function(entry, callback, idOpt, disabled) {
		var div = Popup.makeDiv(entry);
		var Self = this;
		function modifiedCallBack(evt)
		{
			//stopEvent(evt);
			callback(evt,Self.context);
			Self.div.style.display = "none";
		}
		var entryobject = {div: div, entry_id: idOpt, indx: -1, callback: modifiedCallBack, disabled: disabled || false};
		addDOMEvent(div,'mouseover',function (e) {
			         div.className = (entryobject.disabled)?'PopupEntryDivDisabled font-color-disabled':"PopupEntryDivOver border-color-PMG-selection-elements";
			         //stopEvent(e);
			     });		
		addDOMEvent(div,'mouseout',function (e) {
			         div.className = (entryobject.disabled)?'PopupEntryDivDisabled font-color-disabled':"PopupEntryDiv";
			         //stopEvent(e);
			     });				
		if (entryobject.disabled) {
			div.className='PopupEntryDivDisabled font-color-disabled';
		} else {
			addDOMEvent(div,'click',modifiedCallBack);
		}
		this.entries.push(entryobject);
		entryobject.indx = this.entries.length - 1;		
		this.div.appendChild(div);
		return this.entries.length - 1;
	},
	
	clear: function() {
		for (var i in this.entries) {
			var entry = this.entries[i];
			if (entry.callback)
				removeDOMEvent(entry.div, "click", entry.callback);
		}
		this.entries = [];
		this.div.innerHTML = "";
	},

	remove: function(index) {
		this.div.removeChild(this.entries[i]);
		this.entries.splice(i, 1);
	},
	
	disableEntry: function (nEntry)
	{		
		var entry = this.entries[nEntry];
		removeDOMEvent(entry.div, "click", entry.callback);
		entry.div.className = 'PopupEntryDivDisabled font-color-disabled';
		entry.disabled = true;
	}
	,
	
	enableEntry: function (nEntry)
	{
		var entry = this.entries[nEntry];
		addDOMEvent(entry.div, "click", entry.callback);
		entry.div.className = '';
		entry.disabled = false;
	}
};



function ContextMenu() {
	this.entries = [];
	this.context;
	this.div = document.createElement("div");
	this.fillin;	
	this.div.style.display="none";
	this.div.className="PopupMenuDiv background-color-popup-menu border-color-popup-menu font-size-small";
	this.div.style.position="absolute";
	this.div.style.zIndex=1000;
}

ContextMenu.makeDiv = function(entry) {
	return typeof(entry) == "string" ? newnode('div',0,0,[addTranslated(entry)])
	                                 : entry();
}
ContextMenu.makeLine = function () {
	return function() {
		return newnode('hr',0,0,[]);     	
	}
}

ContextMenu.prototype = {
	append: function(object,optparam) {
				
		var Self = this;
		var entryobject=new Object();				
		var myentry=ContextMenu.makeDiv(object.entry);
		if(object.status) {
			if(object.conditionvisible(entryobject,optparam)) {
				this.fillin.appendChild(myentry);	
			}
					
			return;
		}
		object.disabled(myentry);
		
		function fn_mouseover(e) {
			object.mouseover(e,entryobject,optparam);	
		}
		function fn_mouseout(e) {
			object.mouseout(e,entryobject,optparam);
		}
		function fn_callback(e) {
			if(object.conditionactive(entryobject,optparam)) {
				popupHide();
				object.callback(e,entryobject,optparam);
			} else if (object.callback_disabled) {
			    popupHide();
                object.callback_disabled(e,entryobject,optparam);
			}
		}

		entryobject.fn_mouseover=fn_mouseover;
		entryobject.fn_mouseout=fn_mouseout;
		entryobject.fn_callback=fn_callback;
		entryobject.disabled=object.disabled;
		entryobject.enabled=object.enabled
		entryobject.div=myentry;
		entryobject.conditionvisible=object.conditionvisible;
		entryobject.conditionactive=object.conditionactive;
		entryobject.optionalParam=object.optionalParam;
		this.entries.push(entryobject);
		object.loadingFunction(entryobject,optparam);
		this.fillin.appendChild(myentry);				
	},
	clear: function() {
		for (var i in this.entries) {
			var entryobject = this.entries[i];
			if (entryobject.fn_mouseover) { removeDOMEvent(entryobject.div, "mouseover", entryobject.fn_mouseover); }
			if (entryobject.fn_mouseout) { removeDOMEvent(entryobject.div, "mouseout", entryobject.fn_mouseout); }
			if (entryobject.fn_callback) { removeDOMEvent(entryobject.div, "click", entryobject.fn_callback); }
		}
		this.entries = new Array();
		removeChildNodes(this.div);
		this.div.appendChild(newnode("table",{ width: "160px" },{ cellPadding: 0, cellSpacing : 0, border : 0} , [
			newnode("tbody",null,null,[
				newnode("tr",null,null,[
					newnode("td",null,null,[])
				])
			])
		])
		);
		this.fillin=this.div.getElementsByTagName("td")[0];
	}	
};

var registerContext;
var unregisterContext;
var addContextNode;
var addContextLine;
var createContextMenu;
(function() {
    var contexts=new Object();
    var contextMenu = new ContextMenu();
    createContextMenu = function(type,optparam,css){
    	contextMenu.clear();
		contextMenu.div.className= (css) ? css : "PopupMenuDiv background-color-popup-menu border-color-popup-menu font-size-small";
    	if(contexts[type] && contexts[type].length>0) {
	    	for(var i=0;i<contexts[type].length;i++) {
    			var myobject=contexts[type][i];
    			contextMenu.append(myobject,optparam);
    		}
    	}
    	return contextMenu.div;
    }
	clearContext = function(type) {
		if(contexts[type]) { delete contexts[type]; }	
	}
	getContext = function(type) {
		if(type) { return contexts[type]; }
		return contexts;
	}
	registerContext = function (node,type,callback,optparam,fn_onhide,event,posObj,leave_open,cssContext,startbefore) {
		function showContentMenu(e,mynode,optparam,fn_onhide) {
			if(document.getElementById("default_context")) {
				document.getElementById("default_context").parentNode.removeChild(document.getElementById("default_context")); 
			}
			popup(mynode,null,null,function() { 
				if(fn_onhide) { fn_onhide(optparam); }
				if(window.setHoverActive) { setHoverActive(true); }
			},"contextmenu",leave_open);
			if(window.setHoverActive) {	
				setHoverActive(false);
			}
			var mychild=$("everything");
			if(!mychild) mychild=$("loading_data_complete");
			mychild.appendChild(mynode);			
			mynode.id="default_context";		
			if(posObj) {
				mynode.style.top=getAbsolutePositionTop(posObj)+posObj.offsetHeight +"px";
				mynode.style.left=getAbsolutePositionLeft(posObj)+"px";
				mynode.getElementsByTagName("table")[0].style.width=(posObj.offsetWidth-5)+"px";
			} else {
				var coorX = e.clientX;	
				var coorY = e.clientY;
				var tmpnode=mynode.cloneNode(true);
				tmpnode.style.zIndex=-1;
				tmpnode.style.display="block";
				body.appendChild(tmpnode);
				var contextheight=tmpnode.offsetHeight
				var contextwidth=tmpnode.offsetWidth;
				body.removeChild(tmpnode);
				if(parseInt(coorY + contextheight + 10) < parseInt($("body").offsetHeight)) mynode.style.top = (coorY + 10) +'px';
				else if(coorY - contextheight -10 < 0) mynode.style.top = 0 + 'px';
				else mynode.style.top = ((coorY -10 )- contextheight) + 'px';
				if((coorX + contextwidth + 10) < $("body").offsetWidth) mynode.style.left = (coorX + 10) +'px';
				else if(coorX - contextwidth - 10 < 0) mynode.style.left = 0 + 'px';
				else mynode.style.left = (coorX - contextwidth- 10) + 'px';				
			}

		}
		function myfunc() {
			return function(e) {
				if(startbefore) {
					startbefore();
				}
				//Hover not defined in Mail Detail 10365
				try {
					if(Hover.current) { Hover.current.hide(); }
				} catch (exc) {}
				var contextdiv=createContextMenu(type,optparam,cssContext);
				if(callback) {
					callback(e,contextdiv,optparam);			
				} else {
					showContentMenu(e,contextdiv,optparam,fn_onhide);
				}
				stopEvent(e);
			}
		}
		if(!event) {
			addDOMEvent(node,"contextmenu",myfunc());
		} else {
			addDOMEvent(node,event,myfunc());
		}
		return myfunc();
	}
	unregisterContext = function (node,func) {
		removeDOMEvent(node,"contextmenu",func);
	}
	addContextLine = function(entry, typearray,conditionvisible) {
		if(!entry) {
			entry= ContextMenu.makeLine();
		}
		var retobj=new Array();
		for(var i=0;i<typearray.length;i++) {
			var type=typearray[i];
			if(!contexts[type]) contexts[type]=new Array();
			var myobject=new Object();
				
			myobject.entry=entry;
			myobject.type=type;
			myobject.status="line";
			myobject.conditionvisible= (conditionvisible) ? conditionvisible : function () { return true };
			contexts[type].push(myobject);
			retobj.push(myobject);
		}
		return retobj;	
	}
	addContextNode = function(entry,typearray,callback,conditionactive,conditionvisible,setDisabled,optionalMouseOver,optionalMouseOut,loadingFunction,setEnabled,optionalParam,callback_disabled) {
		if(typearray && typearray.length>0) {
			var retobj=new Array();
			for(var i=0;i<typearray.length;i++) {
				var type=typearray[i];
				if(!contexts[type]) contexts[type]=new Array();
				var myobject=new Object();
				function defaultMouseOver(e,entrycomplete,optparam) {
					if(myobject.conditionactive(entrycomplete,optparam)) {
						entrycomplete.div.className = 'PopupEntryDivOver border-color-PMG-selection-elements';	
					}
				}
				function defaultMouseOut(e,entrycomplete,optparam) {
					if(myobject.conditionactive(entrycomplete,optparam)) {
						entrycomplete.div.className = 'PopupEntryDiv';	
					}
				}
				function defaultSetDisabled(myentry) {
					myentry.className = 'PopupEntryDivDisabled font-color-disabled';
				}
				function defaultSetEnabled(myentry) {
					myentry.className = '';
					myentry.style.cursor="pointer";	
				}
				function defaultloading(entrycomplete,optparam) {	
					entrycomplete.params=null;		
					
					if(myobject.conditionvisible(entrycomplete,optparam,true)) {	
						addDOMEvent(entrycomplete.div,'mouseover',entrycomplete.fn_mouseover);
						addDOMEvent(entrycomplete.div,'mouseout',entrycomplete.fn_mouseout);				
						addDOMEvent(entrycomplete.div,'click',entrycomplete.fn_callback);
						if(!myobject.conditionactive(entrycomplete,optparam,true)) {
							myobject.disabled(entrycomplete.div);
						} else {
							myobject.enabled(entrycomplete.div);
						}
					} else {
						entrycomplete.div.style.display="none";
					}
				}
				myobject.optionalParam=optionalParam;
				myobject.entry=entry;
				myobject.type=type;
				myobject.callback=callback || function() {};
				myobject.callback_disabled=callback_disabled;
				myobject.loadingFunction= (loadingFunction) ? loadingFunction : defaultloading;
				myobject.conditionactive=  (conditionactive) ? conditionactive : function () { return true };
				myobject.conditionvisible= (conditionvisible) ? conditionvisible : function () { return true };
				myobject.disabled=  (setDisabled) ? setDisabled   : defaultSetDisabled;
				myobject.enabled=   (setEnabled) ? setEnabled : defaultSetEnabled;
				myobject.mouseover= (optionalMouseOver) ? optionalMouseOver : defaultMouseOver;
				myobject.mouseout= (optionalMouseOut) ? optionalMouseOut : defaultMouseOut;
				contexts[type].push(myobject);
				retobj.push(myobject);
			}
			return retobj;	
		}
	}
	
})();
function contextmenu_createInputDiv(text) {
	return function() {
		var mynode = newnode("table",{ verticalAlign : "middle" , width: "100%" },{ className: "PopupEntryDiv", cellPadding : "0" , cellSpacing : "0" , border : "0"},[ 	
			newnode("tbody",null,null,[
 				newnode("tr",null,null,[
 					newnode("td",{ width : "20px" },null,[
						newnode("input",null,{ type : "checkbox" ,className: "noborder"},[])
					]),
					newnode("td",null, { className: "height16 padding7px"},[
						newnode("div",null,null, [addTranslated(text)])	 
					])
				])
	 		])
		]);
		addDOMEvent(mynode.getElementsByTagName("td")[1],"click",function() {
			mynode.getElementsByTagName("input")[0].checked=(!mynode.getElementsByTagName("input")[0].checked);
		});
	 	return mynode;	
	}
		
}

function contextmenu_createImgDiv(text,image,image_d,image_sub,image_sub_d) {
	return function() {
		var tablenode = newnode("table",{ verticalAlign : "middle" , width: "100%" },{ className: "PopupEntryDiv", cellPadding : "0" , cellSpacing : "0" , border : "0"}); 	
		var imageparentnode = newnode("div",{ height: "16px" },{});
		var image1node =newnode("img",{display:"none" , height: "16px" , width: "16px" },{ src : image , alt : ""})
 	 	imageparentnode.appendChild(image1node);
 	 	if(image_d) { 
 	 		var image2node = newnode("img", {display:"none", height: "16px" , width: "16px" }, { src : image_d , alt : "" }); 
 	 		imageparentnode.appendChild(image2node);
 	 	}
 	 	 	 	
 	 	var imgSubParent = newnode("div",null,null);
 	 	var imgSubNode = newnode("img",{display:"none"},{src: image_sub || getFullImgSrc("img/dummy.gif"), alt:"", align:"absmiddle" })
 	 	imgSubParent.appendChild(imgSubNode);
 	 	if (image_sub_d) {
 	 		var imgSubNode_d = newnode("img",{display:"none"},{src: image_sub_d, alt:"", align:"absmiddle"}); 
            imgSubParent.appendChild(imgSubNode_d);
 	 	}
 	 	
 	 	var tablebody = newnode("tbody",null,null,[
 	 		newnode("tr",null,null,[
	 		 	newnode("td",{width: "20px"},{},[imageparentnode]),
	 		 	newnode("td",null,null,[
					newnode("div",{whiteSpace: "nowrap"},{ className : "paddingleft7px"}, [addTranslated(text)])	 	 	 	
		 	 	]),
		 	 	newnode("td",{width: "20px"},{align:"right"},[imgSubParent]),
 		 	])
 		 ]);
	 	 tablenode.appendChild(tablebody); 
 		 return tablenode;
	}
}
function contextmenu_createOnlyImgDiv(image,image_d) {
	return function() {
		var tablenode = newnode("table",{ verticalAlign : "middle" , width: "100%" },{ className: "PopupEntryDiv", cellPadding : "0" , cellSpacing : "0" , border : "0"}); 	
		var imageparentnode = newnode("div",{textAlign:"center" , height:"16px" },{});
		var image1node =newnode("img",{display:"none" },{ src : image , alt : ""})
 	 	imageparentnode.appendChild(image1node);
 	 	if(image_d) { 
 	 		var image2node = newnode("img", {display:"none" , height: "16px" , width: "16px" }, { src : image_d , alt : "" }); 
 	 		imageparentnode.appendChild(image2node);
 	 	}
 	 	var tablebody = newnode("tbody",null,null,[
 	 		newnode("tr",null,null,[
	 		 	newnode("td",{ textAlign : "center" },{},[imageparentnode])
	 	 	])
 		 ]);
	 	 tablenode.appendChild(tablebody); 
 		 return tablenode;
	}
}
function contextmenu_createOnlyDiv(text) {
	return function() {
		var tablenode = newnode("table",{ verticalAlign : "middle" , width: "100%" },{ className: "PopupEntryDiv", cellPadding : "0" , cellSpacing : "0" , border : "0"}); 	
		 var tablebody = newnode("tbody",null,null,[
 	 		newnode("tr",null,null,[
	 		 	newnode("td",null,null,[
					newnode("div",{ whiteSpace : "nowrap"},null, [addTranslated(text)])	 	 	 	
		 	 	])
	 	 	])
 		 ]);
	 	 tablenode.appendChild(tablebody); 
 		 return tablenode;
	}
}

function contextmenu_inputenabled(entryobject,optparam,first) {
	if(first) {
		var path=currentpath2.join("/");
		if(dynamiccontents[currentpath2[0]]) {
			for(var i=0;i<dynamiccontents[currentpath2[0]].length;i++) {
				var el=dynamiccontents[currentpath2[0]][i];
				if(path.indexOf(el.view)==0) {
					if(el.display!="none") {
						if(!entryobject.div.getElementsByTagName("input")[0].checked) {
							entryobject.div.getElementsByTagName("input")[0].checked= entryobject.div.getElementsByTagName("input")[0].defaultChecked = true;
						}
					} else {
						if(entryobject.div.getElementsByTagName("input")[0].checked) {
							entryobject.div.getElementsByTagName("input")[0].checked= entryobject.div.getElementsByTagName("input")[0].defaultChecked = false;
						}
					}
					break;
				}
			}
		}
	}
	return true;
}
function contextmenu_setDisabled(myentry) {
	myentry.className = 'PopupEntryDivDisabled font-color-disabled';
	var enadiv=myentry.getElementsByTagName("img")[0];
	var disdiv=myentry.getElementsByTagName("img")[1];
	if(enadiv) { if(enadiv.style.display!="none") { enadiv.style.display="none"; } }
	if(disdiv) { if(disdiv.style.display!="inline") { disdiv.style.display="inline"; }}
	
    var enadiv_sub=myentry.getElementsByTagName("img")[2];
    var disdiv_sub=myentry.getElementsByTagName("img")[3];
    if(enadiv_sub) { if(enadiv_sub.style.display!="none") { enadiv_sub.style.display="none"; } }
    if(disdiv_sub) { if(disdiv_sub.style.display!="inline") { disdiv_sub.style.display="inline"; }}
}
function contextmenu_setActive(myentry) {
	myentry.className = 'PopupEntryDivActive border-color-PMG-selection-elements';
	var enadiv=myentry.getElementsByTagName("img")[0];
	var disdiv=myentry.getElementsByTagName("img")[1];
	if(enadiv) { if(enadiv.style.display!="none") { enadiv.style.display="none"; } }
	if(disdiv) { if(disdiv.style.display!="inline") { disdiv.style.display="inline"; }}
	
    var enadiv_sub=myentry.getElementsByTagName("img")[2];
    var disdiv_sub=myentry.getElementsByTagName("img")[3];
    if(enadiv_sub) { if(enadiv_sub.style.display!="none") { enadiv_sub.style.display="none"; } }
    if(disdiv_sub) { if(disdiv_sub.style.display!="inline") { disdiv_sub.style.display="inline"; }}	
} 
function contextmenu_setEnabled(myentry) {
	myentry.className = 'PopupEntryDiv';
	myentry.style.cursor="pointer";	
	var enadiv=myentry.getElementsByTagName("img")[0];
	var disdiv=myentry.getElementsByTagName("img")[1];
	if(enadiv) { if(enadiv.style.display!="inline") { enadiv.style.display="inline"; } }
	if(disdiv) { if(disdiv.style.display!="none") { disdiv.style.display="none"; }}

    var enadiv_sub=myentry.getElementsByTagName("img")[2];
    var disdiv_sub=myentry.getElementsByTagName("img")[3];
    if(enadiv_sub) { if(enadiv_sub.style.display!="inline") { enadiv_sub.style.display="inline"; } }
    if(disdiv_sub) { if(disdiv_sub.style.display!="none") { disdiv_sub.style.display="none"; }}
}
fileloaded();