/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Markus Wagner <markus.wagner@open-xchange.com>
 * 
 */

  ////////////////////
 //  Participants  //
////////////////////

/**
 * Constructor for the participants dialog
 * 
 * @param {String} attachpoint The id of the div where the big livegrid should be inserted
 * @param {function} cbFunction A callback function which is called when you close the participants search window
 * @param {boolean} showUser show or don't show users in the participants search window
 * @param {boolean} showGroup show or don't show groups in the participants search window
 * @param {boolean} showResource show or don't show resources in the participants search window
 * @param {boolean} showFolder enable od disable the possibility to switch the folder. When false is given, only internal user are shown
 * @param {String} title The title of the participants search window
 * @param {Number} id The id of the user which should be initial be inserted into participants
 */
 
function Participants(attachpoint, cbFunction, showUser, showGroup, showResource, showFolder, title, id, singleFolderSearch){
	/**
	 * @private
	 */
	this.attachpoint = attachpoint;
	/**
	 * @private
	 */
	this.setFullParticipants = true;
	/**
	 * @private
	 */
	this.selGroups = [];
	/**
	 * @private
	 */
	this.selContacts = [];
	/**
	 * @private
	 */
	this.selResources = [];
	/**
	 * @private
	 */
	this.internalStorage;
	/**
	 * @private
	 */
	this.showUser = showUser || true;
	/**
	* @private
	*/
	this.showGroup = showGroup || false;

	/**
	* @private
	*/
	this.showResource = showResource || false;
	/**
	* @private
	*/
	this.showFolder = showFolder || false;
	/**
	* @private
	*/
	this.cbFunction = cbFunction;
	/**
	* @private
	*/
	this.title = title || null;		
	/**
	* @private
	*/
	this.id = id || null;		
	/**
	 * @private
	 */
	this.internalStorage2 = new Storage(0, [], "", 0, 0,  null, function(x){ return x[0] + "." + x[1];});
	/**
	 * @private
	 */
	this.selectedParticipants = new Array();
	/**
	 * @private
	 */
	this.selectionObject = new Selection();	
	/**
	 * @private
	 */
	this.selectedResource = new Array();
	/**
	 * @private
	 */
	this.participantsGridBig;
	/**
	 * @private
	 */
	this.enabled = false;
	/**
	 * @private
	 */
	this.userData;
	/**
	 * @private
	 */
	this.changedParticipants;	
	/**
	 * @private
	 */
	this.initalFilled;		
	/**
	 * @private
	 */

	this.selPartsStorage  = null;
	this.selRessStorage = null;
	this.groupMemberLiveGrid = null;
	this.groupResolution = new Object();
	
	this.bUserHead = false;
	this.participantsGridSmall;
	this.smallParticipantsInit = false;
	this.singleFolderSearch = singleFolderSearch || false;
	
	this.getHTML();
	this.emptySearchText = _("Please enter your search");
	this.searchField=$("searchpattern_participants");
    this.searchpattern="";
    this.blurTimer;
	var Self = this;		
	register("OX_Object_Add_Participant", function(){ Self.openAddParticipantsWindow(); });
	register("OX_Object_Add_Ressource", function(){ Self.openAddParticipantsWindow(); });	
	register("closeParticipantsWindowOK", function(){ if(Self.enabled) Self.closeParticipantsWindowOK(); });
	register("closeParticipantsWindowCancel", function(){ if(Self.enabled) Self.closeParticipantsWindowCancel(); });
	register("addToParticipantsList", function(){ if(Self.enabled) Self.addToParticipantsList(); });
	register("addToResourceList", function(){ if(Self.enabled) Self.addToResourceList(); });
	register("searchParticipants", function(){ if(Self.enabled) Self.searchParticipants(); });
	register("OX_Object_Participant_Delete", function(){ Self.deleteParticipants(); });
	
	register("delParticipantsList", function(){ Self.delSelParticipants(); });	
	register("delResourceList", function(){ Self.delSelRessources(); });		
	
	addOnClose($("floatingdivParticipants"), function() { 
		  if (Self.enabled) Self.closeParticipantsWindowCancel(); 
		});
	
	if(!this.showResource){
		$("selectedResourceTr").style.display = "none";
	}
	
    // remove dom events first
    if (Participants.inE) {
        removeDOMEvent(Self.searchField, "keypress", Participants.inE);
        removeDOMEvent(Self.searchField, "click", Participants.inE);
    }
    if (Participants.inB) {
        removeDOMEvent(Self.searchField, "blur", Participants.inB);
    }
	// wrapper functions for key and click events on search field
	Participants.inE = function(e) {
		if (Self.blurTimer != undefined) {
			clearTimeout(Self.blurTimer);
			delete(Self.blurTimer);
		}
		Self.searchParticipantsEnter(e, Self);
	}
    Participants.inB = function(e) {
        Self.blurTimer = setTimeout(function() { Self.searchParticipantsBlur(e, Self); },100);
    }
    // re-add dom events
	addDOMEvent(Self.searchField, "keypress", Participants.inE); 
    addDOMEvent(Self.searchField, "click", Participants.inE);
    addDOMEvent(Self.searchField, "blur", Participants.inB); 
}

function ParticipantsSmall(attachpoint, cbFunction, showUser, showGroup, showResource, showFolder, 
											title,id,bUserHead,bUserMember, singleFolderSearch){
	/**
	 * @private
	 */
	this.showUser = showUser || false;
	/**
	* @private
	*/
	this.showGroup = showGroup || false;
	/**
	* @private
	*/
	this.showResource = showResource || false;
	/**
	* @private
	*/
	this.showFolder = showFolder || false;
	/**
	 * @private
	 */
	this.attachpoint = attachpoint;
	/**
	 * @private
	 */
	this.setFullParticipants = false;
	/**
	 * @private
	 */
	this.selGroups = [];
	/**
	 * @private
	 */
	this.selContacts = [];
	/**
	 * @private
	 */
	this.selResources = [];
	/**
	 * @private
	 */
	this.internalStorage;
	/**
	 * @private
	 */
	this.internalStorage2 = new Storage(0, [], "", 0, 0,  null, function(x){ return x[0] + "." + x[1];});
	/**
	 * @private
	 */
	this.selectedParticipants = new Array();
	/**
	 * @private
	 */
	this.selectedResource = new Array();	
	/**
	 * @private
	 */
	this.cbFunction = cbFunction;
	/**
	* @private
	*/
	this.title = title || null;	
	/**
	 * @private
	 */
	this.enabled = false;	
	/**
	 * @private
	 */
	this.changedParticipants;
	/**
	 * @private
	 */
	this.initalFilled;				
	/**
	 * @private
	 */
	this.bUserHead = bUserHead;
	this.bUserMember = bUserMember;
	
	this.groupResolution = new Object();
	this.groupMemberLiveGrid = null;
	this.selectedParticipantsGrid = null;
	this.selectedRessourcesGrid = null;
	this.singleFolderSearch = singleFolderSearch || false;

	this.selPartsStorage  = null;
	this.selRessStorage = null;
	this.participantsGridSmall;
	this.smallParticipantsInit = false;
	this.emptySearchText = _("Please enter your search");
	this.searchField=$("searchpattern_participants");
	this.searchpattern="";
	this.blurTimer;
	this.getHTML(); 
	var Self = this;	
	register("closeParticipantsWindowOK", function(){ if(Self.enabled) Self.closeParticipantsWindowOK(); });
	register("closeParticipantsWindowCancel", function(){ if(Self.enabled) Self.closeParticipantsWindowCancel(); });
	register("addToParticipantsList", function(){ if(Self.enabled) Self.addToParticipantsList(); });
	register("addToResourceList", function(){ if(Self.enabled) Self.addToResourceList(); });
	
	register("delParticipantsList", function(){ if(Self.enabled) Self.delSelParticipants(); });	
	register("delResourceList", function(){if(Self.enabled) Self.delSelRessources(); });			
	
	register("searchParticipants", function(){ if(Self.enabled) Self.searchParticipants(); });
	if (!this.showResource) $("selectedResourceTr").style.display = "none";
	
	addOnClose($("floatingdivParticipants"), function(){ if(Self.enabled) Self.closeParticipantsWindowCancel(); });
	
    // remove dom events first
    if (Participants.inE) {
        removeDOMEvent(Self.searchField, "keypress", Participants.inE);
        removeDOMEvent(Self.searchField, "click", Participants.inE);
    }
    if (Participants.inB) {
        removeDOMEvent(Self.searchField, "blur", Participants.inB);
    }
    // wrapper functions for key and click events on search field
    Participants.inE = function(e) {
        if (Self.blurTimer != undefined) {
            clearTimeout(Self.blurTimer);
            delete(Self.blurTimer);
        }
        Self.searchParticipantsEnter(e, Self);
    }
    Participants.inB = function(e) {
        Self.blurTimer = setTimeout(function() { Self.searchParticipantsBlur(e, Self); },100);
    }
    // re-add dom events
    addDOMEvent(Self.searchField, "keypress", Participants.inE); 
    addDOMEvent(Self.searchField, "click", Participants.inE);
    addDOMEvent(Self.searchField, "blur", Participants.inB); 
}



Participants.prototype = {
	getHTML: function() {
//		$("tableContainerAddParticipants").style.display = "block";
		var Self=this;
		if(this.setFullParticipants){
			var sel = this.selectionObject;

			sel.toggle2 = sel.toggle;
			sel.select2 = sel.select;
			
			sel.toggle = function(index){
				if(this.storage.groups[index]){
					return this.select2(index - this.storage.groups[index].before,  index + this.storage.groups[index].after + 1);
				} else {
					return this.toggle2(index);
				}
			}
			
			sel.select = function(from, to){
				for(var i = from; i < to; i++){
					if(this.storage.groups[i]){
						this.select2(i - this.storage.groups[i].before,  i + this.storage.groups[i].after + 1);
						i += this.storage.groups[i].after;
					} else {
						this.toggle2(i);
					}
				}
			}
			
			sel.changed_cb2 = sel.changed_cb;
			sel.changed_cb = function(from, to) {
				if (sel.storage.groups)
					filterArray(sel.storage.groups,
						function(group, i) { return !sel.get(1); }, from);
				sel.changed_cb2(from, to);
			};

			this.participantsGridBig = new LiveGrid([
			  {	
					text: "",
					sortable: true,
					width: "16px",
					style: {padding: 0},
					set: function(div,text) {
						switch (text[6]) {
							case "contact":
								var userImgSrc = (text[7]) ? getFullImgSrc("img/calendar/user.gif") : getFullImgSrc("img/calendar/user_extern.gif");
								if(div.firstChild.src)
									div.firstChild.src = userImgSrc;
								else{
									removeChildNodes(div);
									div.appendChild(newnode("img", 0, {src: userImgSrc, alt: "User", align: "absmiddle"}));
								}
								break;
							case "group":
								if(div.firstChild.src)
									div.firstChild.src = getFullImgSrc("img/calendar/group.gif");
								else{
									removeChildNodes(div);
									div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/calendar/group.gif"), alt: "Group", align: "absmiddle"}));
								}
								break;
							case "resource":
								if(div.firstChild.src)
									div.firstChild.src = getFullImgSrc("img/calendar/ressourcen.gif");
								else{
									removeChildNodes(div);
									div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/calendar/ressourcen.gif"), alt: "Resource", align: "absmiddle"}));
								}
								break;								
							default:
								if(div.firstChild.src)
									div.firstChild.src = getFullImgSrc("img/empty16x16.gif");
								else{
									removeChildNodes(div);
									div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/empty16x16.gif"), alt: "Group Member", align: "absmiddle"}));
								}
								break;
						}
					},
					clear: LiveGrid.makeClear("...")
				},	{	
					text: ((this.showUser || this.showGroup) && this.showResource)? "Participants/Resources":/*i18n*/
																				    "Participants", /*i18n*/
					i18n: true,
					sortable: true,
					width: "30%",
					set: function(div, text){
						removeChildNodes(div);
						var dn = text[2] || text[5] || _("unknown"); /*i18n*/
						if(text[6] == "groupMember"){
							div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/calendar/user.gif"), alt: "Group Member", align: "absmiddle"}));
							div.appendChild(document.createTextNode("\u00a0" + dn));
						} else {
							div.appendChild(document.createTextNode(dn));
						}
					},
					clear: LiveGrid.makeClear("...")
				}, {
					text: "Status", /*i18n*/
					i18n: true,
					sortable: true,
					width: "20%",
					set: function(div, text){
						if(text[6] == "groupMember"){
							removeChildNodes(div);
							div.appendChild(document.createTextNode("\u00a0\u00a0\u00a0\u00a0" + text[3]));
						} else {
							removeChildNodes(div);
							div.appendChild(document.createTextNode(text[3]));
						}
					},
					clear: LiveGrid.makeClear("...")
				}, {
					text: "Comment", /*i18n*/
					i18n: true,
					sortable: true,
					set: function(div, text){
						if(text[6] == "groupMember"){
							removeChildNodes(div);
							div.appendChild(document.createTextNode("\u00a0\u00a0\u00a0\u00a0" + text[4]));
						} else {
							removeChildNodes(div);
							div.appendChild(document.createTextNode(text[4]));
						}
					},
					clear: LiveGrid.makeClear("...")
				}
			], this.selectionObject);
			$(this.attachpoint + "Header").appendChild(this.participantsGridBig.getHeader());
			this.participantsGridBig.getTable($(this.attachpoint));
			
			this.participantsGridBig.events.register("Selected", function(ids){
				triggerEvent("SubSelected", Self.participantsGridBig.selection.count);
			});
			this.participantsGridBig.events.register("Activated", function(ids){
				if(ids[0] && ids[0].split('_')[0]=="group")
				{
					if(Self.groupResolution[ids[0].split('.')[0]])
						Self.openGroupMembersPopup(Self.groupResolution[ids[0].split('.')[0]],ids[0]);	
				}
			});
				
		}
		
		if(!this.smallParticipantsInit) {
			var sel_ = new Selection();
			sel_.oldToggle = sel_.toggle;
			function getTyp(id){ return id.substring(0, id.indexOf("_")); }
			sel_.selectable = function(index) {
				var data = this.storage.data.get(this.storage.getSID(index));
				if(getTyp(data[0]) == "group")
					return Boolean(data[4] != "m_mail")
				else
					return Boolean(data[3] || getTyp(data[0]) != "contact");
			}
			sel_.toggle = function(index) {
				return this.selectable(index) && this.oldToggle(index);
			};
			sel_.select = function(from, to) {
				for (var i = from; i < to; i++)
					if (!this.get(i) && this.selectable(i)) this.oldToggle(i);
			}
			this.participantsGridSmall = new LiveGrid([
				{	
					text: "&#160;",
					sortable: true,
					width: "20px",
					style: {padding: 0},
					set: function(div,text) {
							if(text[4] && text[4] > 0)
								img = "user.gif";
							else
								img = "user_extern.gif";
								
							var color = "";
							switch (getTyp(text[0])) {
								case "contact":
								if (!text[3]) {
									color = "silver"; 
									img = "user_d.gif";
								}
								if(div.firstChild.src)
									div.firstChild.src = getFullImgSrc("img/calendar/" + img);
								else{
									removeChildNodes(div);
									div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/calendar/" + img), alt: "User", align: "absmiddle"}));
								}
								break;
							case "group":
								color = (Self.bDisableG== -1 || text[4] == "m_mail")?"silver":""; 
								if(div.firstChild.src)								
									div.firstChild.src = (Self.bDisableG!= -1)?getFullImgSrc("img/calendar/group.gif"):getFullImgSrc("img/calendar/user_d.gif");
								else{
									removeChildNodes(div);
									div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/calendar/group.gif"), alt: "User"}));
								}
								break;
							case "resource":
								if(div.firstChild.src)
									div.firstChild.src = getFullImgSrc("img/calendar/ressourcen.gif");
								else{
									removeChildNodes(div);
									div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/calendar/ressourcen.gif"), alt: "User"}));
								}
								break;								
							default:
								if(div.firstChild)
									div.firstChild.src = getFullImgSrc("img/empty16x16.gif");
								else
									div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/empty16x16.gif"), alt: ""}));
								break;
							}
							div.parentNode.style.color = color;
						},
					clear: LiveGrid.makeClear("...")
				}, {	
					text: "Name", /*i18n*/
					sortable: true,
					width: "40%",
					//set: LiveGrid.defaultSet,
					//index:2
					set: function(div, data) {
						removeChildNodes(div);
						div.appendChild(document.createTextNode(data[2] || data[3] || _("unknown")));
					},
					clear: LiveGrid.makeClear("...")
				}, {
					text: "E-Mail", /*i18n*/
					sortable: true,
					set: LiveGrid.defaultSet,
					clear: LiveGrid.makeClear("..."),
					index:3
				}
			], sel_);

			this.participantsGridSmall.events.register("Activated", function(ids){
				//participantsGridSmall.selection.click(participantsGridSmall.selection.getSelected());
				if((Self.bDisableG == -1) && (ids[0].split('_')[0] == 'group')) {return;}
				if(ids[0] == undefined) return;
				Self.participantsGridSmall.selection.select(ids[0]);
								
				if(ids[0].split('_')[0] == 'resource')
					triggerEvent('addToResourceList');				
				else	
					triggerEvent('addToParticipantsList');				

			});					
			this.attach_lg_header = newnode("div", { display: "none" },
                { className: "innerTableContainerAddAddresseesHeader" });
            this.attach_lg = newnode("div", { display: "none" },
                { className: "innerTableContainerAddAddressees" });
            $("tableContainerAddParticipants").appendChild(this.attach_lg_header);
            $("tableContainerAddParticipants").appendChild(this.attach_lg);
            this.attach_lg_header.appendChild(this.temp_storage_head = this.participantsGridSmall.getHeader());
			this.participantsGridSmall.getTable(this.attach_lg);
			this.smallParticipantsInit = true;
		}
		if(this.showFolder){
			$("newParticipant_folder").style.display = ""; 
		}
		else{
			$("newParticipant_folder").style.display = "none";		
		}
        
        if (!configGetKey("modules.contacts.singleFolderSearch") && !this.singleFolderSearch) {
            var setDisabled = classNameSetter("font-color-disabled");
            var checkbox = $("participants-search-all-folders");
            checkbox.parentNode.parentNode.parentNode.style.display = "";
            checkbox.checked = true;
            setDisabled($("participants-folder-button"), true);
            checkbox.onclick = function() {
                setDisabled($("participants-folder-button"), checkbox.checked);
            };
        }
	},
	openGroupMembersPopup: function (memberArray,group_id) {
		var sGroupIdSplitDot = group_id.split(".")[0];
		internalCache.getGroups([sGroupIdSplitDot.split('_')[1]],function (res){
							$('memberPopup-h-c').innerHTML = format(_("Members of %s"), /*i18n*/
												res[sGroupIdSplitDot.split('_')[1]].display_name);			
																	});

		var Self = this;
		if(typeof memberArray != "object")
			return;
		centerPopupWindow($("memberPopup"));
		$("memberPopup").style.display = "block";
		internalCache.getUsers(memberArray, function(cbObj){
			if(Self.groupMemberLiveGrid == null)
			{	
				Self.groupMemberLiveGrid = new LiveGrid([ 
					{
						text:"",
						index: 1,
						width: "20px",	
						set: function (div, content){
							if (!div.firstChild)
								div.appendChild(newnode("img", null, {src: getFullImgSrc("img/mail/noattachment.gif"), align: "absmiddle", width: "16", height: "16"}));
							switch(content)
							{
								 case "contact": 	
								 		div.firstChild.src = getFullImgSrc("img/calendar/user.gif")
								 		break;
								 case "group": 	
								 		div.firstChild.src = getFullImgSrc("img/calendar/group.gif")
								 		break;							 					
								 case "resource": 
								 		div.firstChild.src = getFullImgSrc("img/calendar/ressourcen.gif")
								 		break;							 												 					
							}
						},
						clear: function(div) {
							if (!div.firstChild)
								div.appendChild(newnode("img", null, {src: getFullImgSrc("img/mail/noattachment.gif"), align: "absmiddle", width: "16", height: "16"}));
						}
					}, {
						text:_("Group Members"),				
						index: 2,	
						set: LiveGrid.defaultSet,					
						clear: LiveGrid.makeClear("...")
					}
				],new Selection());

				Self.groupMemberLiveGrid.emptylivegridtext =_("No Members");
				Self.groupMemberLiveGrid.getHeader();		
				Self.groupMemberLiveGrid.getTable($("member_lg"));
			}					
			var showMember = new Array();

			for(var nId in cbObj)
			{
				showMember.push(["contact_" + cbObj[nId].id,"contact",cbObj[nId].display_name]);
			}	
			var memberStorage = new Storage(0, []);		
			showMember.sort(function(a,b){
				if (a[2] && b[2])
					return a[2].toUpperCase() < b[2].toUpperCase() ? -1 : 1;
				else
					return -1;
			});			
			memberStorage.append(showMember);
			Self.groupMemberLiveGrid.enable(memberStorage);
		});
	},
	openAddParticipantsWindow: function(bDisableG) {
		if(this.opened)		
			return;
		$("tableContainerAddParticipants").style.display = "block";
		this.attach_lg_header.style.display = "block";
		this.attach_lg.style.display = "block";		
		this.opened = true;
		//clear search
		this.bDisableG = bDisableG;
		$("searchpattern_participants").value = "";
		if(this.bUserMember) {
			$("headerSelPartAndRes").style.display ="none";
			$("headerSelUser").style.display ="none";						
			$("headerSelPart").style.display ="none";		
			$("headerSelPart2").style.display ="none";	
			$("headerSelUser2").style.display ="none";
			$("headerSelMember").style.display ="";
			$("headerSelMember2").style.display ="";
		}
		else if((this.showUser || this.showGroup) && this.showResource)
		{
			$("headerSelPartAndRes").style.display ="";
			$("headerSelUser").style.display ="none";						
			$("headerSelPart").style.display ="none";		
			$("headerSelPart2").style.display ="";	
			$("headerSelUser2").style.display ="none";	
			$("headerSelMember").style.display ="none";
			$("headerSelMember2").style.display ="none";
		}
		else if((this.showUser || this.showGroup) && this.bUserHead)
		{
			$("headerSelUser").style.display =""			
			$("headerSelPartAndRes").style.display ="none";						
			$("headerSelPart").style.display ="none";			
			$("headerSelPart2").style.display ="none";	
			$("headerSelUser2").style.display ="";
			$("headerSelMember").style.display ="none";
			$("headerSelMember2").style.display ="none";							
		}
		else if(this.showUser || this.showGroup)
		{
			$("headerSelPart").style.display =""			
			$("headerSelPartAndRes").style.display ="none";						
			$("headerSelUser").style.display ="none";			
			$("headerSelPart2").style.display ="";	
			$("headerSelUser2").style.display ="none";
			$("headerSelMember").style.display ="none";
			$("headerSelMember2").style.display ="none";										
		}
        if ($("disable_background_window")) {
            showNode("disable_background_window");
            $("disable_background_window").style.display = "block";
        }
		showNode("floatingdivParticipants");
		centerPopupWindow($("floatingdivParticipants"));
		$("floatingdivParticipants").style.display = "block";	
		if(this.internalStorage){
			this.enable_small_grid(this.internalStorage);
		}
		if(this.title)
			$("floatingdivParticipants-h-c").firstChild.data = _(this.title);
		this.selectedParticipants = new Array();
		this.selectedResource = new Array();
		/*
		if(this.selectedParticipantsGrid != null)
		{			
			this.selectedParticipantsGrid.enable(new Storage(0, []));
		}
		if(this.selectedRessourcesGrid != null)
		{			
			this.selectedRessourcesGrid.enable(new Storage(0, []));
		}*/
		this.enabled = true;
		this.changedParticipants = new Array();
        this.changedResources = [];
		if(!this.internalStorage2.groups)
			this.internalStorage2.groups = new Array();
//		if(!this.setFullParticipants)
//			triggerEvent('searchParticipants');
		removeChildNodes($("selectedParticipants"));
		removeChildNodes($("selectedResource"));
		triggerEvent("searchParticipants");
		this.selPartsStorage = new Storage(0, []);		
		this.selRessStorage = new Storage(0, []);		
		this.selectedParticipantsGrid = null;		
		this.selectedRessourcesGrid = null;		
	},
	
	attachpoint: function() {
		
	},
	
	getParticipants: function(onlyInternal) {
		if(!onlyInternal)
			onlyInternal = false;

		var parts = [];
		if(this.internalStorage2.data.data){
			for(i in this.internalStorage2.data.data){
				if(this.internalStorage2.data.data[i][4] != null){
					var tmpObj = {id : getID(this.internalStorage2.data.data[i][0]), display_name : this.internalStorage2.data.data[i][2]};
					switch (getTyp(this.internalStorage2.data.data[i][0])) {
						case "contact":
							if(this.internalStorage2.data.data[i][1] == 6){
								tmpObj.type = 1;
								tmpObj.id = this.internalStorage2.data.data[i][7];
							}
							else {
								tmpObj.type = 5;
								tmpObj.mail = this.internalStorage2.data.data[i][5];
							}
							break;
						case "group":
							tmpObj.type = 2;
							break;
						case "resource":
							tmpObj.type = 3;
							break;
						default:
							break;
					}
					if(!parts[0])
						parts.push(tmpObj);
					else if(tmpObj.id != parts[0].id && tmpObj.type){
						if(tmpObj.type == 5){
							tmpObj.id = 0;
							parts.push(tmpObj);
						} else
							parts.push(tmpObj);
					}
				}
			}
		}
		//we need empty participants array!!!
		//if(parts.length > 0) 
		return parts;
		
		function getID(id){ return id = id.substring(id.indexOf("_")+1); }
		function getTyp(id){ return id = id.substring(0, id.indexOf("_")); }
	},
	
	getChangedParticipants: function() {
		
		var parts = [];
		for(var i in this.changedParticipants)
            addParticipant(
                this.internalStorage2.data.data[this.changedParticipants[i]]);
        for (var i in this.changedResources)
            addParticipant(
                this.internalStorage2.data.data[this.changedResources[i]]);
        return parts;

        function addParticipant(storageObj) {
			if (!storageObj) return;
			var tmpObj = {id : getID(storageObj[0]), display_name : storageObj[2]};
			switch (getTyp(storageObj[0])) {
				case "contact":
					if(storageObj[1] == 6){
						tmpObj.type = 1;
						tmpObj.id = storageObj[7];
					}
					else {
						tmpObj.type = 5;
						tmpObj.mail = storageObj[5];
					}
					break;
				case "group":
					tmpObj.type = 2;
					break;
				case "resource":
					tmpObj.type = 3;
					break;
				default:
					break;
			}
			if(!parts[0])
				parts.push(tmpObj);
			else if(tmpObj.id != parts[0].id){
				parts.push(tmpObj);
			}
		}
		function getID(id){ return id = id.substring(id.indexOf("_")+1); }
		function getTyp(id){ return id = id.substring(0, id.indexOf("_")); }
	},
	
	containsParticipants: function() {
		if(this.userData)
			return true;
		if(this.internalStorage2 && this.internalStorage2.data.data) {
			for (i in this.internalStorage2.data.data) {
				return true;
			} 
		}
		return false;
	},
    searchParticipantsBlur : function(event, Self) {
        if (trimStr(Self.searchField.value).length == 0) {
            Self.searchField.value=Self.emptySearchText;
            Self.searchField.style.color="silver";
        }
    },
    searchParticipantsEnter: function (event, Self){
        if (Self.searchField.value == Self.emptySearchText) {
            Self.searchField.value="";
            Self.searchField.style.color="";
        } else if (event.keyCode == 13) {
            Self.searchpattern = Self.searchField.value;            
            triggerEvent("searchParticipants");
            //$(liveGridDivResult).focus();
        }
    },
    displayError: function(msg) {
    	$("participantsSearchError").style.display="";
    	$("participantsSearchError").getElementsByTagName("DIV")[0].firstChild.data=msg;
    },
	
	/**
	 * @private
	 */	
	searchParticipants: function() {
		var Self = this;
		
		this.searchpattern="";
        var inVal=this.searchField.value;
        if (trimStr(inVal).length == 0 ||
            inVal == this.emptySearchText) {
            this.searchField.value=this.emptySearchText;
            setTimeout(function() {
                Self.searchField.style.color="silver";
            },0);
            if (configContainsKey("participants.autoSearch") &&
                configGetKey("participants.autoSearch") == false) {
                this.searchpattern = "";
                //if(this.enabled) this.resetGrid();
                return; 
            } else if (configContainsKey("minimumSearchCharacters") &&
                configGetKey("minimumSearchCharacters") != 0) {
            	this.displayError(
            	   format(_("The search pattern requires at least %s characters."), 
            	       configGetKey("minimumSearchCharacters")));
            	return;
            } else {
                this.searchstring="";
            }
        } else if (configContainsKey("minimumSearchCharacters") &&
            trimStr(inVal).length < configGetKey("minimumSearchCharacters")) {
            this.displayError(
                format(_("The search pattern requires at least %s characters."), 
                    configGetKey("minimumSearchCharacters")));
            return;
        } else {
            this.searchField.style.color="";
            this.searchpattern=inVal;
        }
        
        //if no folder set, use the default
        if(clickedItemParticipant == null || clickedItemParticipant == "") {
            clickedItemParticipant = defaultParticipantFolder;
        }
        var pattern = trimStr(this.searchpattern) ? this.searchpattern : "*";
        var patternObj = { pattern: pattern };
        var userPatternObj = { display_name: pattern, email1: pattern,
            email2: pattern, email3: pattern, last_name: pattern,
            first_name: pattern, orSearch: true };
        if (!$("participants-search-all-folders").checked) {
            patternObj.folder = clickedItemParticipant;
            userPatternObj.folder = clickedItemParticipant;
        }
		
		this.internalStorage = new Storage(0, [], "", 0, 0,  null, function(x){ return x[0] + "." + x[1];});		
		
		var oObj;
		var aRequests = new Array();
		
		var oRequestObj = new Object();

		if(this.showUser){
			oRequestObj['module'] = "contacts";
			oRequestObj['action'] = "search";	
			oRequestObj['columns'] = "1,20,500,555,602,524,556,557";	
			oRequestObj['sort'] = "500";
			oRequestObj['order'] = "asc";
			oRequestObj['data'] = userPatternObj;
			aRequests.push(oRequestObj);
		}
		if (this.showGroup && clickedItemParticipant == defaultParticipantFolder){		
			var oRequestObj = new Object();		
			oRequestObj['module'] = "group";
			oRequestObj['action'] = "search";		
			oRequestObj['data'] = patternObj;
	
			aRequests.push(oRequestObj);
		}
		if (this.showResource  && clickedItemParticipant == defaultParticipantFolder){
			var oRequestObj = new Object();		
			oRequestObj['module'] = "resource";
			oRequestObj['action'] = "search";		
			oRequestObj['data'] = patternObj;
			
			aRequests.push(oRequestObj);		
		}
		
		json.put(AjaxRoot + "/multiple?" + "session=" + session,aRequests,null,function (arg){
			for(var indx=0;indx<aRequests.length;indx++)
			{
				switch (aRequests[indx].module){
					case "contacts": 
							var tmpArray = new Array();
							for(var i = 0; i< arg[indx].data.length; i++){
								var cb = arg[indx];
								// Add a user only when it is not a Distributionlist
								// and either the user has a mail address or admin enabled
								// displaying of participants without email.
								var mailaddr = cb.data[i][3] || cb.data[i][6] || cb.data[i][7];
								if(!cb.data[i][4] && (mailaddr || configGetKey("participants.showWithoutEmail")))
									tmpArray.push(["contact_" + cb.data[i][0], cb.data[i][1], cb.data[i][2], mailaddr, cb.data[i][5]]);
							}							
							Self.internalStorage.append(tmpArray);					
							break;
					case "group": 
							var tmpArray = new Array();		
							for(var i = 0; i< arg[indx].data.length; i++){
								var cb = arg[indx];		
								var foldertype = (("comboboxProps" in window) && comboboxProps && (comboboxProps.getKey() == "m_mail")) ?	"m_mail" : "";									
								tmpArray[i] = ["group_" + cb.data[i].id, 0, cb.data[i].display_name, "", foldertype];
							}
							tmpArray.sort(function(a,b){
								if (a[2] && b[2]) 
									return a[2].toUpperCase() < b[2].toUpperCase() ? -1 : 1;
								else
									return -1;
							});				
							Self.internalStorage.append(tmpArray);					
							break;							
					case "resource": 
							var tmpArray = new Array();							
							for(var i = 0; i< arg[indx].data.length; i++){
								var cb = arg[indx];			
								tmpArray[i] = ["resource_" + cb.data[i].id, 0, cb.data[i].display_name, ""];
							}
							tmpArray.sort(function(a,b){
								if (a[2] && b[2])
									return a[2].toUpperCase() < b[2].toUpperCase() ? -1 : 1;
								else
									return -1;
							});
							Self.internalStorage.append(tmpArray);								
							break;														
				}
			}
			//removeChildNodes($("addParticipantsTableHeader"));
			Self.enable_small_grid(Self.internalStorage);
		});
	},
	enable_small_grid : function (storage){
		//$("addParticipantsTableHeader").appendChild(this.temp_storage_head);
//		if(this.temp_storage && this.temp_storage_parent)
//			this.temp_storage_parent.appendChild(this.temp_storage);			
		this.participantsGridSmall.enable(storage);		
		if(this.participantsGridSmall && this.participantsGridSmall.selection)
			this.participantsGridSmall.selection.reset();
	},
	disable_small_grid : function (){
//		this.temp_storage = this.participantsGridSmall.heightDiv;
//		this.temp_storage_parent = 	this.participantsGridSmall.heightDiv.parentNode;		
	//	removeChildNodes($("addParticipantsTableHeader"));
//		this.participantsGridSmall.heightDiv.parentNode.removeChild(this.participantsGridSmall.heightDiv);
		this.participantsGridSmall.disable();		
	},
	/**
	 * @private
	 */	
	closeParticipantsWindowOK: function() {
		this.opened = false;
        if ($("disable_background_window")) {
        	var childs = $("disable_background_window").childNodes;
        	var closeall=true;
		    for(var i=0;i<childs.length;i++) {
		        if(childs[i].tagName && childs[i].tagName == "DIV") {
		            if(childs[i].style.display && childs[i].style.display != "none") {
		                closeall=false;
		            }
		        }
		    }
		    if (closeall) {
                hideNode("disable_background_window");
                $("disable_background_window").style.display = "none";
		    }
        }
		hideNode("floatingdivParticipants");
		$("floatingdivParticipants").style.display = "none";
		this.attach_lg_header.style.display = "none";
		this.attach_lg.style.display = "none";		
		this.disable_small_grid();
		if(this.selectedParticipantsGrid)
			this.selectedParticipantsGrid.disable();
		if(this.selectedRessourcesGrid)
			this.selectedRessourcesGrid.disable();			
		this.selGroups = []; this.selContacts = []; this.selResources = [];
		var tmpSelContacts = new Array();
		
		if(this.selectedParticipants && this.selectedParticipants.length > 0){
			for(var i = 0; i < this.selectedParticipants.length; i++){
				switch (getTyp(this.selectedParticipants[i])) {
					case "contact":
						this.selContacts.push({ id : getID(this.selectedParticipants[i]), folder : getFolder(this.selectedParticipants[i]) })
						tmpSelContacts[getID(this.selectedParticipants[i])] = "2";
						break;
					case "group":
						this.selGroups.push({ id : getID(this.selectedParticipants[i])});
						break;
					default:
						break;
				}
			}
			var Self = this;
			if(!(this.selectedResource && this.selectedResource.length > 0)){
				fillBigGrid();
			}
		}
		
		if(this.selectedResource && this.selectedResource.length > 0){
			for(var i = 0; i < this.selectedResource.length; i++){
				switch (getTyp(this.selectedResource[i])) {
					case "contact":
						if(!tmpSelContacts[getID(this.selectedResource[i])])
							this.selResources.push({ id : this.internalStorage.data.data[this.selectedResource[i]][4], folder : getFolder(this.selectedResource[i]) })
						break;
					case "resource":
						this.selResources.push({id : getID(this.selectedResource[i])});	
						break;
					default:
						break;
				}
			}
			var Self = this;
			fillBigGrid();
		}
		
		function getTyp(id){ return id.substring(0, id.indexOf("_")); }
		function getID(id){ return id.substring(id.indexOf("_")+1, id.indexOf(".")); }
		function getFolder(id){ return id.substr(id.indexOf(".") +1); }
		

		
		function fillBigGrid() {

			if(!Self.internalStorage2)
				Self.internalStorage2 = new Storage(0, [], "", 0, 0,  null, function(x){ return x[0] + "." + x[1];});
			
			//TODO Try to get the data out of the other storage so that no server request is needed!!!!!
			//get data in multiple request for first step...
			
			var aRequests = new Array();
		
			if(Self.selContacts.length > 0){
				var oRequestObj = new Object();				
				oRequestObj['module'] = "contacts";
				oRequestObj['action'] = "list";		
				oRequestObj['columns'] = "1,20,500,555,524,556,557";		
				oRequestObj['data'] = Self.selContacts;
				
				aRequests.push(oRequestObj);
			}
			if(Self.selGroups.length > 0){
				var oRequestObj = new Object();				
				oRequestObj['module'] = "group";
				oRequestObj['action'] = "list";		

				oRequestObj['data'] = Self.selGroups;
				
				aRequests.push(oRequestObj);
			}			
			if(Self.selResources.length > 0){
				var oRequestObj = new Object();				
				oRequestObj['module'] = "resource";
				oRequestObj['action'] = "list";		

				oRequestObj['data'] = Self.selResources;
				
				aRequests.push(oRequestObj);
			}
			json.put(AjaxRoot + "/multiple?" + "session=" + session,aRequests,null,function (arg){
							for(var indx=0;indx<aRequests.length;indx++)
							{
								switch (aRequests[indx].module){
									case "contacts":
									        var tmpArray = new Array();
											for(var i = 0; i< arg[indx].data.length; i++){
												var cb = arg[indx];
												if(!Self.internalStorage2.data.data["contact_" + cb.data[i][0] + "." + cb.data[i][1]]){
													var mailaddr = cb.data[i][3] || cb.data[i][5] || cb.data[i][6];
													tmpArray.push(["contact_" + cb.data[i][0], cb.data[i][1], 
															cb.data[i][2], _("not sent"), /*i18n*/
															"", mailaddr, "contact", cb.data[i][4]]);
													Self.internalStorage2.groups.push(null);
												}												
											}
											Self.internalStorage2.append(tmpArray);
											if(Self.setFullParticipants){
												Self.participantsGridBig.enable(Self.internalStorage2);
											}
											if(Self.selGroups.length == 0 && Self.selResources.length == 0 && Self.cbFunction)
											{
												var aChangedPartc = Self.getChangedParticipants();
												Self.cbFunction(aChangedPartc);
											}	
											break;
							case "group": 			
											var tmpArray = new Array();
											var toGetTmp = new Array();
											for(var i = 0; i < arg[indx].data.length; i++){
											    var cb = arg[indx];
												for(k in cb.data[i].members){
													toGetTmp[cb.data[i].members[k]] = cb.data[i].members[k];
												}												
											}
											var toGet = new Array();
											for(var ho = 0; ho < toGetTmp.length; ho++){
												if(toGetTmp[ho])
													toGet.push({id : toGetTmp[ho], type : 1});
											}
											internalCache.getObjects(toGet, (function(indx) { return function(cbObj){
											    for(var t = 0; t < arg[indx].data.length; t++){
													var cb = arg[indx];													
													if(!Self.internalStorage2.data.data["group_" + cb.data[t].id + "." + 0]){
														tmpArray.push(["group_" + cb.data[t].id, 0, cb.data[t].display_name, _("not sent"), "", "", "group"]);
														Self.groupResolution["group_" + cb.data[t].id] = cb.data[t].members;
													}
												}	
												Self.internalStorage2.append(tmpArray);
												if(Self.setFullParticipants){
													Self.participantsGridBig.enable(Self.internalStorage2);
												}
												if(Self.selResources.length == 0 && Self.cbFunction)
													Self.cbFunction(Self.getChangedParticipants());												
											}; })(indx));
											break;
							case "resource": 			
													var tmpArray = new Array();
													for(var i = 0; i< arg[indx].data.length; i++){
														var cb = arg[indx];																	
														tmpArray[i] = ["resource_" + cb.data[i].id, 0, cb.data[i].display_name, _("not sent"), "", "", "resource"];
														Self.internalStorage2.groups.push(null);						
													}
													
													var tempVarTD = Self.internalStorage2.data.data;
													var newArrayClean = new Array();
													for(var indx2=0;indx2<tmpArray.length;indx2++)
													{												
														var isAlreadyInside = false;						
														for(var sKey12 in tempVarTD)
														{
															if(sKey12.split(".")[0] == tmpArray[indx2][0])
															{
																isAlreadyInside = true;
																true;
															}							
														}
														if(!isAlreadyInside)
															newArrayClean.push(tmpArray[indx2]);				
													}
													Self.internalStorage2.append(newArrayClean);
													if(Self.setFullParticipants){
														Self.participantsGridBig.enable(Self.internalStorage2);
													}
													if(Self.cbFunction)
														Self.cbFunction(Self.getChangedParticipants());										
													break;			
								}
							}
																});						
			}		
		this.enabled = false;
	},
	
	initalFillBigGrid: function(obj) {

		if(this.initalFilled)
			this.internalStorage2 = new Storage(0, [], "", 0, 0,  null, function(x){ return x[0] + "." + x[1];});
		if(!this.internalStorage2.groups)
			this.internalStorage2.groups = new Array();
			
		this.part = obj.participants;
		if(obj.users)
			this.users = obj.users;
		else
			this.users = [];
		this.stati = ["waiting"/*i18n*/, "accepted"/*i18n*/,
		              "declined"/*i18n*/, "tentative"/*i18n*/];

		var Self = this;
		
		this.userToReq = new Array();
		this.groupToReq = new Array();
		this.resourceToReq = new Array();
		var externalUser = new Array();
		
		this.tmpArrayContact = new Array();
		this.tmpArrayGroup = new Array();
		this.tmpArrayResource = new Array();			
		
		for(var k = 0; k < this.part.length; k++){
			switch(this.part[k].type){
				case 1:
					this.userToReq.push({id : this.part[k].id, type : 1});
					break;
				case 2:
					this.groupToReq.push({id : this.part[k].id, type : 2});
					break;
				case 3:
					this.resourceToReq.push({id : this.part[k].id, type : 3});
					break;
				case 5:
					externalUser.push({id : this.part[k].mail, type : 5, display_name : this.part[k].display_name, mail:this.part[k].mail})
					break;
				default:
					break;
			}
		}
		
		if(Self.userToReq.length > 0 ){
			internalCache.getObjects(Self.userToReq, function(cb){
				var count = 0;
				for(i in cb){
					var userstatus = "";
					var message = ""
					var folder = 0;
					for(var j = 0; j < Self.users.length; j++){
						if(Self.users[j].id == i){
							folder = 6;
							if(Self.users[j].confirmation > -1 && Self.users[j].confirmation < 4)
								userstatus = _(Self.stati[Self.users[j].confirmation]);
							if(Self.users[j].confirmmessage)
								message = Self.users[j].confirmmessage;
							break;
						}
					}
					Self.tmpArrayContact[count++] = ["contact_" + cb[i].user_id, folder, cb[i].display_name, userstatus, message, "", "contact", i];
					Self.internalStorage2.groups.push(false);
				}
				Self.tmpArrayContact.sort(function(a,b){
					if (a[2] && b[2])
						return a[2] < b[2] ? -1 : 1;
					else
						return -1;
				});
				Self.internalStorage2.append(Self.tmpArrayContact);
			});
		} 

		if(Self.groupToReq.length > 0){

			internalCache.getObjects(Self.groupToReq, function(cb){

					var count = 0;
					var tmpArray = new Array();
					var toGetTmp = new Array();
					for(i in cb){
						for(k in cb[i].members){
							toGetTmp[cb[i].members[k]] = cb[i].members[k];
						}
					}
					var toGet = new Array();
					for(var ho = 0; ho < toGetTmp.length; ho++){
						if(toGetTmp[ho])
							toGet.push({id : toGetTmp[ho], type : 1});
					}
					
					internalCache.getObjects(toGet, function(cbObj){
						for(t in cb){
							Self.tmpArrayGroup.push(["group_" + cb[t].id, 6, cb[t].display_name, "", "", "", "group"]);
//	   							      tmpArray.push(["group_" + cb.data[t].id, 0, cb.data[t].display_name, _("not sent"), "", "", "group"]);
						//	Self.internalStorage2.groups.push({before: 0, after: cb[t].members.length});
							Self.groupResolution["group_" + cb[t].id] = cb[t].members;
							/*var countMember = 1;
							for(bt in cb[t].members){							
								var userstatus = "";
								var message = "";
								var btt = cb[t].members[bt]; 
								for(var j = 0; j < Self.users.length; j++){
									if(Self.users[j].id == btt){
										if(Self.users[j].confirmation > -1 && Self.users[j].confirmation < 4)
											userstatus = _(Self.stati[Self.users[j].confirmation]);
										if(Self.users[j].confirmmessage)
											message = Self.users[j].confirmmessage;
									}
								}
								Self.tmpArrayGroup.push(["groupMember_" + btt, 0, cbObj[btt].display_name, userstatus, message, "", "groupMember", [count, cb[t].members.length-count++]]);
								Self.internalStorage2.groups.push({before: countMember, after: cb[t].members.length-countMember});
								countMember++;
							}*/
						}

						Self.internalStorage2.append(Self.tmpArrayGroup);
					});
			});
		}
		
		if(Self.resourceToReq.length > 0){
			internalCache.getObjects(Self.resourceToReq, function(cb){
				var count = 0;
				for(i in cb){
					Self.tmpArrayResource[count++] = ["resource_" + i, 6, cb[i].display_name, "", "", "", "resource"];
					Self.internalStorage2.groups.push(false);
				}
				Self.internalStorage2.append(Self.tmpArrayResource);
			});
		}
		
		
		if(externalUser.length > 0){
			var tmpArrayExternal = new Array();
			var count = 0;
			for(i in externalUser){
				tmpArrayExternal[count++] = ["contact_" + externalUser[i].id, 0, externalUser[i].display_name, "", "", externalUser[i].mail, "contact"];
				Self.internalStorage2.groups.push(false);
			}
			Self.internalStorage2.append(tmpArrayExternal);
		}
		this.initalFilled = true;
	},
	
	enableTheGrid: function(){
		this.participantsGridBig.enable(this.internalStorage2);		
	},
	
	disableTheGrid: function(){
		this.participantsGridBig.disable();
	},
	
	/**
	 * @private
	 */	
	closeParticipantsWindowCancel: function() {	
		this.opened = false;
		var Self = this;
        if ($("disable_background_window")) {
            var childs = $("disable_background_window").childNodes;
            var closeall=true;
            for(var i=0;i<childs.length;i++) {
                if(childs[i].tagName && childs[i].tagName == "DIV") {
                    if(childs[i].style.display && childs[i].style.display != "none") {
                        closeall=false;
                    }
                }
            }
            if (closeall) {
                hideNode("disable_background_window");
                $("disable_background_window").style.display = "none";
            }
        }
		hideNode("floatingdivParticipants");
		$("floatingdivParticipants").style.display = "none";
		this.attach_lg_header.style.display = "none";
		this.attach_lg.style.display = "none";		
		$("selectedParticipants").value = "";
		Self.enabled = false;
		Self.disable_small_grid();
		if(Self.selectedParticipantsGrid)
			Self.selectedParticipantsGrid.disable();
		if(Self.selectedRessourcesGrid)
			Self.selectedRessourcesGrid.disable();			
	},
	
	/**
	 * @private
	 */		
	addToParticipantsList: function() {
		var tmpSelected = this.participantsGridSmall.selection.getSelected();
		var currAdded = new Array();
		
		for(var i = 0; i < tmpSelected.length; i++){
			var drin = false;
			if(this.selectedParticipants){
				for(var j = 0; j < this.selectedParticipants.length; j++){
					if(tmpSelected[i] == this.selectedParticipants[j]){
						drin = true;
						break;
					}
				}
			}
			if(!drin && this.selectedParticipants){
				currAdded.push(tmpSelected[i]);
				this.selectedParticipants.push(tmpSelected[i]);
				this.changedParticipants.push(tmpSelected[i]);			
			}
		}
	
		var selPartData = new Array();
		if(this.selectedParticipantsGrid == null)
		{

			this.selectedParticipantsGrid = new LiveGrid([ 
				{
					text: "",
					width: "20px",
					set: function (div, content){
						if (!div.firstChild)
							div.appendChild(newnode("img",null,{src: getFullImgSrc("img/mail/noattachment.gif"), align: "absmiddle", width: "16", height: "16" }));
							
						switch(content[1])
						{
							 case "contact":
							 		div.firstChild.src = (content[4] && content[4] > 0 ) ? getFullImgSrc("img/calendar/user.gif") : getFullImgSrc("img/calendar/user_extern.gif");
							 		break;
							 case "group": 		
							 		div.firstChild.src = getFullImgSrc("img/calendar/group.gif")
							 		break;							 					
							 case "resource": 	
							 		div.firstChild.src = getFullImgSrc("img/calendar/ressourcen.gif")
							 		break;							 												 					
						}
					},
					clear: function(div) {
						if (!div.firstChild)
							div.appendChild(newnode("img",null,{src: getFullImgSrc("img/mail/noattachment.gif"), align: "absmiddle", width: "16", height: "16" }));
					}
				}, {
					text:"",				
					//index: 2,	
					//set: LiveGrid.defaultSet,
					set: function(div,data) {
						removeChildNodes(div);
						div.appendChild(document.createTextNode(data[2] || data[3] || _("unknown")));
					},
					clear: LiveGrid.makeClear("")
				}
			],new Selection());			
			var select = $("selectedParticipants");			
			this.selectedParticipantsGrid.emptylivegridtext ="";
			this.selectedParticipantsGrid.getHeader();		
			this.selectedParticipantsGrid.getTable(select);
			this.selectedParticipantsGrid.enable(this.selPartsStorage);	
		}
		var tmpSel = new Array();
		for(var i = 0; i< currAdded.length; i++){
			var typ = currAdded[i].substring(0, currAdded[i].indexOf("_"));			
			tmpSel.push(this.selectedParticipantsGrid.storage.ids.length+i);
			if(typ == "group"){
					selPartData.push([currAdded[i],typ,
							this.internalStorage.data.data[currAdded[i]][2]]);
			} else if(typ == "contact"){
					selPartData.push([currAdded[i],typ,
							this.internalStorage.data.data[currAdded[i]][2],
							this.internalStorage.data.data[currAdded[i]][3],
							this.internalStorage.data.data[currAdded[i]][4]]);
			}
		}
		this.selPartsStorage.append(selPartData);						
		this.selectIDs(this.selectedParticipantsGrid, tmpSel);
		
	},
		
	deleteParticipants: function(){
		with (this.participantsGridBig) deleteIDs(selection.getSelected());
		if ($("countParticipantsNewAppointment"))
			$("countParticipantsNewAppointment").firstChild.data = this.getParticipants().length;
		if ($("partCounterTasksNew"))
			$("partCounterTasksNew").firstChild.data = this.getParticipants().length;			
	},
	
	 /**
	 * @private
	 */		
	addToResourceList: function() {
		var tmpSelected = this.participantsGridSmall.selection.getSelected();
		var currAdded = new Array();
		for(var i = 0; i < tmpSelected.length; i++){
			var drin = false;
			if(this.selectedResource){
				for(var j = 0; j < this.selectedResource.length; j++){
					if(tmpSelected[i] == this.selectedResource[j]){
						drin = true;
						break;
					}
				}
			}
			if(!drin && this.selectedResource){
				currAdded.push(tmpSelected[i]);
				this.selectedResource.push(tmpSelected[i]);
                this.changedResources.push(tmpSelected[i]);          
			}
		}


		var selRessData = new Array();
		if(this.selectedRessourcesGrid == null)
		{	
			this.selectedRessourcesGrid = new LiveGrid([ 
				{
                    text: "",
					index: 1,
					width: "20px",						
					set: function (div, content){						
						if (!div.firstChild)
							div.appendChild(newnode("img",null,{src: getFullImgSrc("img/mail/noattachment.gif"), align: "absmiddle", width: "16", height: "16" }));
						switch(content)
						{
							 case "contact": 	
							 		div.firstChild.src = getFullImgSrc("img/calendar/user.gif")
							 		break;
							 case "group": 		
									div.firstChild.src = getFullImgSrc("img/calendar/group.gif")
							 		break;							 					
							 case "resource": 	
							 		div.firstChild.src = getFullImgSrc("img/calendar/ressourcen.gif")
							 		break;							 												 					
						}
					},
					clear: function(div) {
						if (!div.firstChild)
							div.appendChild(newnode("img",null,{src: getFullImgSrc("img/mail/noattachment.gif"), align: "absmiddle", width: "16", height: "16" }));
					}
				}, {			
					text: "",
                    //index: 2,	
					//set: LiveGrid.defaultSet,		
					set: function(div,data) {
						removeChildNodes(div);
						div.appendChild(document.createTextNode(data[2] || data[3] || _("unknown")));
					},			
					clear: LiveGrid.makeClear("")					
				}
			],new Selection());			
			var select = $("selectedResource");			
			this.selectedRessourcesGrid.emptylivegridtext ="";
			this.selectedRessourcesGrid.getHeader();		
			this.selectedRessourcesGrid.getTable(select);
			this.selectedRessourcesGrid.enable(this.selRessStorage);	
		}
		var tmpSel = new Array();
		for(var i = 0; i< currAdded.length; i++){
			var typ = currAdded[i].substring(0, currAdded[i].indexOf("_"));
			tmpSel.push(this.selectedRessourcesGrid.storage.ids.length+i);
			if(typ == "contact" || typ == "resource"){
				selRessData.push([currAdded[i],typ,
						this.internalStorage.data.data[currAdded[i]][2],
						this.internalStorage.data.data[currAdded[i]][3]]);
			}
		}
		this.selRessStorage.append(selRessData);		
		this.selectIDs(this.selectedRessourcesGrid, tmpSel);	
		
	},
	delSelParticipants: function (){
		//if nothing selected
		if(this.selectedParticipantsGrid == null)
			return;
		var aItemsToDelete = this.selectedParticipantsGrid.selection.getSelected();
		var aNewPartArr = new Array();		
		var aNewChPartArr = new Array();			
		for(var j = 0; j < this.selectedParticipants.length; j++){
			var bFound = false;
			for( var indx in aItemsToDelete)
			{
				if(this.selectedParticipants[j] == aItemsToDelete[indx])
				{
					var bFound = true;					
					break;
				}				
			}
			if(!bFound){
				aNewPartArr.push(this.selectedParticipants[j]);			
				aNewChPartArr.push(this.selectedParticipants[j]);			
			}			
		}
//		this.selectedParticipantsGrid.selection.removeSelected();
		this.selectedParticipantsGrid.selection.storage.removeIDs(this.selectedParticipantsGrid.selection.getSelected());

		this.changedParticipants = aNewChPartArr;
		this.selectedParticipants = aNewPartArr;		
	},
	delSelRessources: function (){
		//if nothing selected
		if(this.selectedRessourcesGrid == null)
			return;		
		var aItemsToDelete = this.selectedRessourcesGrid.selection.getSelected();
		var aNewRessArr = new Array();
        var aNewChRessArr = [];
		for(var j = 0; j < this.selectedResource.length; j++){
			var bFound = false;
			for( var indx in aItemsToDelete)
			{
				if(this.selectedResource[j] == aItemsToDelete[indx])
				{
					var bFound = true;					
					break;
				}				
			}
			if(!bFound){
				aNewRessArr.push(this.selectedResource[j]);
                aNewChRessArr.push(this.selectedResource[j]);
			}			
		}
		
		this.selectedResource = aNewRessArr;
        this.changedResources = aNewChRessArr;
//		this.selectedRessourcesGrid.selection.removeSelected();
		this.selectedRessourcesGrid.selection.storage.removeIDs(this.selectedRessourcesGrid.selection.getSelected());
	},
	selectIDs: function(grid, sids) {
		grid.selection.reset();
		for (var ia = 0; ia < sids.length; ia++) {
			grid.selection.toggle(sids[ia]);
			if (ia == sids.length-1) {
				grid.focus = sids[ia];
				grid.showFocus();
			}
		}
	}	
}

ParticipantsSmall.prototype = Participants.prototype;

/*
 * 
 * Search in Addressbook (Recources, Groups)
 * Participant
 * 
 */

var contactAddressbookTreeParticipantLoaded = false;
var currentDivIdForAddressbook = "";
var defaultParticipantFolder = corewindow.defaultParticipantFolder || 6;
var clickedItemParticipant = corewindow.clickedItemParticipant;
register("OX_Configuration_Loaded_Complete", function() {
    corewindow.oMainFolderTree.checkGAL(function(GAL) {
        defaultParticipantFolder = GAL ? 6 : configGetKey("folder.contacts");
        if (clickedItemParticipant === undefined) {
            clickedItemParticipant = defaultParticipantFolder;
        }
    });
});

//register("Loaded",initParticipantContent);


function initParticipantContent() {
	setTimeout('participantsFolderPath()',100);
}


function hideAddressbookParticipantsTree(divId){
	$(divId).style.display = "none";
}

function toggleAddressbookParticipantsTree(divId){
	currentDivIdForAddressbook = divId;
	if($(divId).style.display == "none"){
		$(divId).style.display = "block";
	} else{
		$(divId).style.display = "none";
	}
}

function participantsFolderPath() {
	var folderViewSettingsNewContact = new Object();
	var folderViewSettingsNewContactById = new Object();
	//Disable Email... 
	folderViewSettingsNewContactById["default"] = 4;
	folderViewSettingsNewContact["contacts"] = 8;
	folderViewSettingsNewContact["calendar"] = 4;
	folderViewSettingsNewContact["tasks"] = 4;
	folderViewSettingsNewContact["infostore"] = 4;
	if(window.opener)
		var oLocalState = window.opener.optFolderState.getState('folderAddressbookParticipant_tree_info');
	else
		var oLocalState = new Object();
	newAddressbookFolderTree = new cFolderTree(	$('folderAddressbookParticipant_tree_info'),
									folderParticipantAction,
									false,
									window.opener.oMainFolderTree.cache,
									window.opener.optFolderState.getState('folderAddressbookParticipant_tree_info'))
	newAddressbookFolderTree.enabled_modules = {contacts:true};			
	if(window.opener)									
		newAddressbookFolderTree.setSaveConfiguration(window.opener.optFolderState);		
	if(!contactAddressbookTreeParticipantLoaded)
	{
		newAddressbookFolderTree.load();
		contactAddressbookTreeParticipantLoaded = true;	
	}
	newAddressbookFolderTree.get_folder_path(clickedItemParticipant, cb_AddressbookGetpath);	
}

function cb_AddressbookGetpath(sPath)
{
	var tmpSlash = sPath.substr(sPath.length-1);
	
	if(tmpSlash == "/")
		sPath = sPath.substr(0, sPath.length-1);
	
	var tmpIndex = sPath.lastIndexOf("/") + 1;
	var finalFolderName = sPath.substr(tmpIndex);
	
	$('newParticipant_folderText').value = finalFolderName;
}

function folderParticipantAction(ofolder) {
	hideAddressbookParticipantTree(currentDivIdForAddressbook);
	clickedItemParticipant = ofolder.oxfolder.data.id;
	newAddressbookFolderTree.get_folder_path(clickedItemParticipant, cb_AddressbookGetpath);
	triggerEvent("searchParticipants");
}
/*
function cb_AddressbookGetpath(sPath)
{
	var tmpSlash = sPath.substr(sPath.length-1);
	
	if(tmpSlash == "/")
		sPath = sPath.substr(0, sPath.length-1);
	
	var tmpIndex = sPath.lastIndexOf("/") + 1;
	var finalFolderName = sPath.substr(tmpIndex);
	
	document.getElementsByName('newParticipant_folder')[0].value = finalFolderName;
}
*/
function hideAddressbookParticipantTree(divId){
	$(divId).style.display = "none";	
	treeAddressbookVisible = false;
}
fileloaded();