/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

registerView("configuration/mail/preferences",
	function () { 
		showNode("config_mail"); 
		$("config_mail").style.display="block";
	},
	function() {
		register("OX_SAVE_OBJECT",cm_saveConfiguration);
		register("OX_Cancel_Object",cm_cancelConfiguration);
		cm_enter();
        changeTab('contentMailConfigCommon', 'tabMailConfigCommon');
        $("tabMailConfigCommon").className="tabPanelFirstHi tabPanelHiColor background-color-content font-style-lable border-color-content-default";        
	},
	function() { 
		//configuration_askforSave();	
		unregister("OX_SAVE_OBJECT",cm_saveConfiguration);
		unregister("OX_Cancel_Object",cm_cancelConfiguration);
		cm_leave(); 
	},
	function () { 
		hideNode("config_mail"); 
		$("config_mail").style.display="none";
		$("tabMailConfigCommon").className="tabPanelFirst tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default";		 
	},
	function () { 
		cm_enter(); 
	}
);

function cm_saveConfiguration() {
	if (configuration_changed_fields["gui"]) {
		configSetKey("gui.mail.view", cm_default_level1.getKey());
		configSetKey("gui.mail.view_spam", cm_default_level2.getKey());
		configSetKey("gui.mail.notifyacknoledge",getBoolofInt(getValueofRadioBox("cm_notifyacknoledge")));		
		configSetKey("gui.mail.formatmessage",getStringofRadioBox("cm_formatmessage"));
		configSetKey("gui.mail.autocomplete",getBoolofInt(getValueofRadioBox("cm_autocomplete")));		
		configSetKey("gui.mail.auto_save_drafts", cm_auto_save_mail_drafts.getKey());
		configSetKey("gui.effects.hover.mail",getBoolofInt(getValueofRadioBox("cm_enablehovermail")));
		configSetKey("gui.mail.select_first_message",getBoolofInt(getValueofRadioBox("cm_emailSelectFirstMessage")));
	}
	if (configuration_changed_fields["mail"]) {
		configSetKey("mail.vcard",getBoolofInt(getValueofRadioBox("cm_appendvcard")));		
		configSetKey("mail.deletemail",getBoolofInt(getValueofRadioBox("cm_deletemail")));
		configSetKey("mail.appendmailtext",getBoolofInt(getValueofRadioBox("cm_appendmailtext")));
		configSetKey("mail.inlineattachments",getBoolofInt(getValueofRadioBox("cm_inlineattachments")));
		configSetKey("mail.colorquoted",getBoolofInt(getValueofRadioBox("cm_colorquoted")));
		configSetKey("mail.emoticons",getBoolofInt(getValueofRadioBox("cm_emoticons")));
		configSetKey("mail.forwardmessage",getStringofRadioBox("cm_forwardmessage"));
		configSetKey("mail.linewrap",$("cm_linewrap").value);
		configSetKey("mail.sendaddress", cm_default_sendaddress.getKey());	
	}
	if (configuration_changed_fields["modules"]) {
		configSetKey("modules.mail.allowhtmlimages", getBoolofInt(getValueofRadioBox("cm_preloadimages")));
		configSetKey("modules.mail.contactCollectEnabled", getBoolofInt(getValueofRadioBox("cm_emailCollection")));
		configSetKey("modules.mail.replyallcc", getBoolofInt(getValueofRadioBox("cm_replyallcc")));
	}
	
	triggerEvent("OX_Save_Configuration",false,false);
}

function cm_cancelConfiguration() {
	configuration_changed_fields["gui"]=false;
	configuration_changed_fields["mail"]=false;
	configuration_changed_fields["modules"]=false;
	cm_enter();	
}

var cm_default_level1, cm_default_level2;
var cm_default_sendaddress, cm_auto_save_mail_drafts;
var cm_init_bool=false;

register("OX_Configuration_Loaded",cm_onconfigload);
function cm_onconfigload() {
	addDefaultView("mail/list/unthreaded","List view");/*i18n*/
	addDefaultView("mail/hsplit/unthreaded","H-split view");/*i18n*/
	addDefaultView("mail/vsplit/unthreaded","V-split view");/*i18n*/
}

function cm_leave() { }

function cm_enter() {
	if(!cm_init_bool) {
		cm_init();
		cm_init_bool=true;
	}
	if(configContainsKey("gui.mail.view")) {
		cm_default_level1.setKey(configGetKey("gui.mail.view"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.mail.view_spam")) {
		cm_default_level2.setKey(configGetKey("gui.mail.view_spam"));
		configuration_changed_fields["gui"]=false;
	}	
	if(configContainsKey("gui.mail.select_first_message")) {
        setValueofRadioBox("cm_emailSelectFirstMessage",configGetKey("gui.mail.select_first_message"));
        configuration_changed_fields["gui"]=false;
    }
	if(configContainsKey("mail.deletemail")) {
		setValueofRadioBox("cm_deletemail",configGetKey("mail.deletemail"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("gui.mail.notifyacknoledge")) {
		setValueofRadioBox("cm_notifyacknoledge",configGetKey("gui.mail.notifyacknoledge"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("mail.appendmailtext")) {
		setValueofRadioBox("cm_appendmailtext",configGetKey("mail.appendmailtext"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("mail.inlineattachments")) {
		setValueofRadioBox("cm_inlineattachments",configGetKey("mail.inlineattachments"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("mail.vcard")) {
		setValueofRadioBox("cm_appendvcard",configGetKey("mail.vcard"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("gui.mail.autocomplete")) {
		setValueofRadioBox("cm_autocomplete",configGetKey("gui.mail.autocomplete"));
		configuration_changed_fields["gui"]=false;
	}	
	if(configContainsKey("mail.colorquoted")) {
		setValueofRadioBox("cm_colorquoted",configGetKey("mail.colorquoted"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("mail.emoticons")) {
		setValueofRadioBox("cm_emoticons",configGetKey("mail.emoticons"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("gui.mail.formatmessage")) {
		setStringofRadioBox("cm_formatmessage",configGetKey("gui.mail.formatmessage"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.mail.auto_save_drafts")) {
		cm_auto_save_mail_drafts.setKey(configGetKey("gui.mail.auto_save_drafts"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("mail.forwardmessage")) {
		setStringofRadioBox("cm_forwardmessage",configGetKey("mail.forwardmessage"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("mail.linewrap")) {
		$("cm_linewrap").value=configGetKey("mail.linewrap");
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("mail.sendaddress")) {
		cm_default_sendaddress.setKey(configGetKey("mail.sendaddress"));
		configuration_changed_fields["mail"]=false;
	}	
	if(configContainsKey("gui.effects.hover.mail")) {
		setIntofRadioBox("cm_enablehovermail",configGetKey("gui.effects.hover.mail"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("modules.mail.allowhtmlimages")) {
		setIntofRadioBox("cm_preloadimages",configGetKey("modules.mail.allowhtmlimages"));
		configuration_changed_fields["modules"]=false;
	}
	if (configContainsKey("modules.mail.contactCollectEnabled") && configContainsKey("modules.mail.contactCollectFolder")) {
        setIntofRadioBox("cm_emailCollection", configGetKey("modules.mail.contactCollectEnabled"));
        configuration_changed_fields["modules"]=false;        
        oMainFolderTree.cache.get_folder(configGetKey("modules.mail.contactCollectFolder"), function(folder) { 
            $("cm_emailCollection_text").firstChild.nodeValue = format(_("Automatically save E-Mail addresses to folder %s?"), [folder.oxfolder.data.title]);
        });
        $("cm_emailCollectionContent").style.display="";
    } else {
    	$("cm_emailCollectionContent").style.display="none";
    }
    if(configContainsKey("modules.mail.replyallcc")) {
        setIntofRadioBox("cm_replyallcc",configGetKey("modules.mail.replyallcc"));
        configuration_changed_fields["gui"]=false;
    }
	$("cm_header").firstChild.nodeValue=getconfigPathSelected().substring(1);	
	
	// register tabs
	setTabLists(new Array('contentMailConfigCommon','contentMailConfigCompose','contentMailConfigDisplay'),
		new Array('tabMailConfigCommon','tabMailConfigCompose','tabMailConfigDisplay'), null);	
}

function cm_init() {
	cm_default_level1= new ComboBox3(window, "cm_default_level1", "20em", 0, true,"OX_Configuration_Settings_Changed_GUI", 3);
	var mailviews=getDefaultSubviews("mail");
	for (var i in mailviews) {
		cm_default_level1.addElement(mailviews[i],i);
	}
	cm_default_level1.getDomNode();
	
	cm_default_level2= new ComboBox3(window, "cm_default_level2", "20em", 0, true,"OX_Configuration_Settings_Changed_GUI", 3);
	for (var i in mailviews) {
		cm_default_level2.addElement(mailviews[i],i);
	}
	cm_default_level2.getDomNode();	
	$("cm_default_level2_parent").style.display = configGetKey("mail.folder.spam") ? "" : "none";
	
	cm_default_sendaddress= new ComboBox3(window, "cm_default_sendaddress", "30em", 0, true,"OX_Configuration_Settings_Changed_Mail", 3);
	var aliases = configContainsKey("mail.addresses") ? configGetKey("mail.addresses") : new Array();
	for (a=0; a < aliases.length; a++) {
		cm_default_sendaddress.addElement(aliases[a],aliases[a]);
	}
	cm_default_sendaddress.getDomNode();
	
	// pre-fill with default parameter if not set in config
	if (!configContainsKey("gui.mail.auto_save_drafts"))
		configSetKey("gui.mail.auto_save_drafts",5);
	
	var myarray=[60000,180000,300000,600000,900000,1800000];
	cm_auto_save_mail_drafts = new ComboBox3(window, "cm_auto_save_mail_drafts", "15em", 0, true,"OX_Configuration_Settings_Changed_GUI", 3);
	cm_auto_save_mail_drafts.addElement(_("Disabled"),0); /*i18n*/
	var m = function(n) { return function() { return getInterval(n); }; }; 
	for(var i=0;i<myarray.length;i++) {
		if(!myarray[i]== 0) {
			cm_auto_save_mail_drafts.addElement("",(myarray[i]/60000),m((myarray[i])));
		}
	}
	cm_auto_save_mail_drafts.getDomNode();
}

function cm_linewrap_changed() {
	var newvalue=trimStr($("cm_linewrap").value);
	if (newvalue == "")
		newvalue=0;
	newvalue=parseInt(newvalue, 10);
	if(isNaN(newvalue) || newvalue < 0) {
		newvalue=configGetKey("mail.linewrap");
	}
	$("cm_linewrap").value=newvalue;
	configuration_changed_fields["mail"]=true;
}
fileloaded();