/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;

public final class Calendars {
    private Calendars() {
    }

    public static Calendar load(String filename) throws IOException, ParserException {
        FileInputStream fin = new FileInputStream(filename);
        CalendarBuilder builder = new CalendarBuilder();
        return builder.build(fin);
    }

    public static Calendar merge(Calendar c1, Calendar c2) {
        Calendar result = new Calendar();
        result.getProperties().addAll(c1.getProperties());
        Iterator i = c2.getProperties().iterator();
        while (i.hasNext()) {
            Property p = (Property)i.next();
            if (result.getProperties().contains(p)) continue;
            result.getProperties().add(p);
        }
        result.getComponents().addAll(c1.getComponents());
        i = c2.getComponents().iterator();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            if (result.getComponents().contains(c)) continue;
            result.getComponents().add(c);
        }
        return result;
    }

    public static Calendar wrap(Component component) {
        ComponentList components = new ComponentList();
        components.add(component);
        return new Calendar(components);
    }
}

