/**
 * 
 */
package com.openexchange.custom.parallels.osgi;

import javax.servlet.ServletException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

import com.openexchange.config.ConfigurationService;
import com.openexchange.server.ServiceException;

/**
 * @author Manuel Kraft
 *
 */
public class ServletRegisterer {

	private static final Log LOG = LogFactory.getLog(ServletRegisterer.class);
	
	public ServletRegisterer (){
		super();	
	}
	
	
	public void registerServlet() {
		final HttpService http_service;
		try {
			http_service = ParallelsServiceRegistry.getServiceRegistry().getService(HttpService.class, true);
		} catch (ServiceException e) {
			LOG.error("Error registering parallels servlet!", e);
			return;
		}
		try {
			
			http_service.registerServlet(getFromConfig("com.openexchange.custom.parallels.sso_info_servlet"), new com.openexchange.custom.parallels.impl.ParallelsInfoServlet(), null, null);
			http_service.registerServlet(getFromConfig("com.openexchange.custom.parallels.openapi_servlet"), new com.openexchange.custom.parallels.impl.ParallelsOpenApiServlet(), null, null);
			
		} catch (ServletException e) {
			LOG.error("Error registering parallels servlet!", e);
		} catch (NamespaceException e) {
			LOG.error("Error registering parallels servlet!", e);
		} catch (ServiceException e) {
			LOG.error("Error registering parallels servlet cause of missing property!", e);
		}catch (NullPointerException e) {
			LOG.error("Error registering parallels servlet cause of missing property!", e);
		}
	}
	
	private String getFromConfig(String key) throws ServiceException{
		ConfigurationService configservice = ParallelsServiceRegistry.getServiceRegistry().getService(ConfigurationService.class,true);
		return configservice.getProperty(key);
	}

	
	public void unregisterServlet() {
		final HttpService http_service;
		try {
			http_service = ParallelsServiceRegistry.getServiceRegistry().getService(HttpService.class, true);
		} catch (ServiceException e) {
			LOG.error("Error unregistering parallels servlet!", e);
			return;
		}
		try {
			http_service.unregister(getFromConfig("com.openexchange.custom.parallels.sso_info_servlet"));
			http_service.unregister(getFromConfig("com.openexchange.custom.parallels.openapi_servlet"));
		} catch (ServiceException e) {
			LOG.error("Error unregistering config parallels cause of missing property!", e);
		}catch (NullPointerException e) {
			LOG.error("Error unregistering config parallels cause of missing property!", e);
		}
	}

}
