/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.verifier.Base64;
import org.eclipse.osgi.internal.verifier.DNChainMatching;
import org.eclipse.osgi.internal.verifier.DefaultTrustAuthority;
import org.eclipse.osgi.internal.verifier.DigestedInputStream;
import org.eclipse.osgi.internal.verifier.JarVerifierConstant;
import org.eclipse.osgi.internal.verifier.JarVerifierMessages;
import org.eclipse.osgi.internal.verifier.PKCS7Processor;
import org.eclipse.osgi.internal.verifier.SignedBundleHook;
import org.eclipse.osgi.util.NLS;

public class SignedBundleFile
extends BundleFile
implements CertificateVerifier,
JarVerifierConstant {
    private static DefaultTrustAuthority trustAllAuthority = new DefaultTrustAuthority(0);
    private BundleFile bundleFile;
    CertificateChain[] chains;
    Hashtable digests4entries;
    Hashtable results4entries;
    String manifestSHAResult = null;
    String manifestMD5Result = null;
    boolean certsInitialized = false;

    SignedBundleFile() {
    }

    SignedBundleFile(CertificateChain[] chains, Hashtable digests4entries, Hashtable results4entries, String manifestMD5Result, String manifestSHAResult) {
        this.chains = chains;
        this.digests4entries = digests4entries;
        this.results4entries = results4entries;
        this.manifestMD5Result = manifestMD5Result;
        this.manifestSHAResult = manifestSHAResult;
        this.certsInitialized = true;
    }

    private void verifyManifestAndSingatureFile(byte[] manifestBytes, byte[] sfBytes) {
        String sf = new String(sfBytes);
        int off = (sf = this.stripContinuations(sf)).indexOf("-Digest-Manifest: ");
        if (off != -1) {
            int start = sf.lastIndexOf(10, off);
            String manfiestDigest = null;
            if (start != -1) {
                String digestName = sf.substring(start + 1, off);
                if (digestName.equalsIgnoreCase("MD5")) {
                    if (this.manifestMD5Result == null) {
                        this.manifestMD5Result = this.calculateDigest(SignedBundleFile.getMessageDigest("MD5"), manifestBytes);
                    }
                    manfiestDigest = this.manifestMD5Result;
                } else if (digestName.equalsIgnoreCase("SHA1")) {
                    if (this.manifestSHAResult == null) {
                        this.manifestSHAResult = this.calculateDigest(SignedBundleFile.getMessageDigest("SHA1"), manifestBytes);
                    }
                    manfiestDigest = this.manifestSHAResult;
                }
                int nIndex = sf.indexOf(10, off += digestManifestSearchLen);
                String digestValue = sf.substring(off, nIndex - 1);
                if (!manfiestDigest.equals(digestValue)) {
                    SecurityException e = new SecurityException(NLS.bind(JarVerifierMessages.Security_File_Is_Tampered, new String[]{this.bundleFile.getBaseFile().toString()}));
                    SignedBundleHook.log(e.getMessage(), 4, e);
                    throw e;
                }
            }
        }
    }

    private String getDigAlgFromSF(byte[] SFBuf) {
        String rtvValue = null;
        String mfStr = new String(SFBuf);
        String entryStr = null;
        int entryStartOffset = mfStr.indexOf("\nName: ");
        int length = mfStr.length();
        if (entryStartOffset != -1 && entryStartOffset < length) {
            int entryEndOffset = mfStr.indexOf("\nName: ", entryStartOffset + 1);
            if (entryEndOffset == -1) {
                entryEndOffset = mfStr.length();
            }
            entryStr = mfStr.substring(entryStartOffset + 1, entryEndOffset);
            entryStr = this.stripContinuations(entryStr);
        }
        if (entryStr != null) {
            String digestLine = this.getDigestLine(entryStr, null);
            rtvValue = this.getMessageDigestName(digestLine);
        }
        return rtvValue;
    }

    private void populateManifest(byte[] mfBuf, String digAlg) {
        String mfStr = new String(mfBuf);
        int entryStartOffset = mfStr.indexOf("\nName: ");
        int length = mfStr.length();
        while (entryStartOffset != -1 && entryStartOffset < length) {
            String aDigestLine;
            int entryEndOffset = mfStr.indexOf("\nName: ", entryStartOffset + 1);
            if (entryEndOffset == -1) {
                entryEndOffset = mfStr.length();
            }
            String entryStr = mfStr.substring(entryStartOffset + 1, entryEndOffset);
            String entryName = this.getEntryFileName(entryStr = this.stripContinuations(entryStr));
            if (entryName != null && (aDigestLine = this.getDigestLine(entryStr, digAlg)) != null) {
                String msgDigestAlgorithm = this.getDigestAlgorithmFromString(aDigestLine);
                byte[] digestResultsList = this.getDigestResultsList(aDigestLine);
                if (this.digests4entries == null) {
                    this.digests4entries = new Hashtable(10);
                    this.results4entries = new Hashtable(10);
                }
                if (!this.digests4entries.contains(entryName)) {
                    this.digests4entries.put(entryName, msgDigestAlgorithm);
                    this.results4entries.put(entryName, digestResultsList);
                }
            }
            entryStartOffset = entryEndOffset;
        }
    }

    private String stripContinuations(String entry) {
        if (entry.indexOf("\n ") < 0) {
            return entry;
        }
        StringBuffer buffer = new StringBuffer(entry.length());
        int cont = entry.indexOf("\n ");
        int start = 0;
        while (cont >= 0) {
            buffer.append(entry.substring(start, cont - 1));
            start = cont + 2;
            int n = cont = cont + 2 < entry.length() ? entry.indexOf("\n ", cont + 2) : -1;
        }
        if (start < entry.length()) {
            buffer.append(entry.substring(start));
        }
        return buffer.toString();
    }

    private String getEntryFileName(String manifestEntry) {
        int nameStart = manifestEntry.indexOf("Name: ");
        if (nameStart == -1) {
            return null;
        }
        int nameEnd = manifestEntry.indexOf(10, nameStart);
        if (nameEnd == -1) {
            return null;
        }
        if (manifestEntry.charAt(nameEnd - 1) == '\r') {
            --nameEnd;
        }
        if ((nameStart += "Name: ".length()) >= nameEnd) {
            return null;
        }
        return manifestEntry.substring(nameStart, nameEnd);
    }

    /*
     * Unable to fully structure code
     */
    private String getDigestLine(String manifestEntry, String desireDigestAlg) {
        rtvValue = null;
        indexDigest = manifestEntry.indexOf("-Digest: ");
        if (indexDigest != -1) ** GOTO lbl23
        return null;
lbl-1000:
        // 1 sources

        {
            indexStart = manifestEntry.lastIndexOf(10, indexDigest);
            if (indexStart == -1) {
                return null;
            }
            indexEnd = manifestEntry.indexOf(10, indexDigest);
            if (indexEnd == -1) {
                return null;
            }
            indexEndToUse = indexEnd;
            if (manifestEntry.charAt(indexEndToUse - 1) == '\r') {
                --indexEndToUse;
            }
            if ((indexStartToUse = indexStart + 1) >= indexEndToUse) {
                return null;
            }
            digestLine = manifestEntry.substring(indexStartToUse, indexEndToUse);
            digAlg = this.getMessageDigestName(digestLine);
            if (desireDigestAlg != null && desireDigestAlg.equalsIgnoreCase(digAlg)) {
                rtvValue = digestLine;
                break;
            }
            rtvValue = digestLine;
            indexDigest = manifestEntry.indexOf("-Digest: ", indexEnd);
lbl23:
            // 2 sources

            ** while (indexDigest != -1)
        }
lbl24:
        // 2 sources

        return rtvValue;
    }

    private String getDigestAlgorithmFromString(String digestLines) {
        if (digestLines != null) {
            int indexDigest = digestLines.indexOf("-Digest: ");
            String sDigestAlgType = digestLines.substring(0, indexDigest);
            if (sDigestAlgType.equalsIgnoreCase("MD5")) {
                return "MD5";
            }
            if (sDigestAlgType.equalsIgnoreCase("SHA1")) {
                return "SHA1";
            }
            throw new SecurityException(NLS.bind(JarVerifierMessages.Algorithm_Not_Supported, sDigestAlgType));
        }
        return null;
    }

    private String getMessageDigestName(String digLine) {
        int indexDigest;
        String rtvValue = null;
        if (digLine != null && (indexDigest = digLine.indexOf("-Digest: ")) != -1) {
            rtvValue = digLine.substring(0, indexDigest);
        }
        return rtvValue;
    }

    private byte[] getDigestResultsList(String digestLines) {
        byte[] resultsList = null;
        if (digestLines != null) {
            String sDigestLine = digestLines;
            int indexDigest = sDigestLine.indexOf("-Digest: ");
            if ((indexDigest += "-Digest: ".length()) >= sDigestLine.length()) {
                resultsList = null;
            }
            String sResult = sDigestLine.substring(indexDigest);
            try {
                resultsList = Base64.decode(sResult.getBytes());
            }
            catch (Throwable throwable) {
                resultsList = null;
            }
        }
        return resultsList;
    }

    private static int readFully(InputStream is, byte[] b) throws IOException {
        int rc;
        int count = b.length;
        int offset = 0;
        while ((rc = is.read(b, offset, count)) > 0) {
            count -= rc;
            offset += rc;
        }
        return offset;
    }

    byte[] readIntoArray(BundleEntry be) throws IOException {
        byte[] b;
        int size = (int)be.getSize();
        InputStream is = be.getInputStream();
        int rc = SignedBundleFile.readFully(is, b = new byte[size]);
        if (rc != size) {
            throw new IOException("Couldn't read all of " + be.getName() + ": " + rc + " != " + size);
        }
        return b;
    }

    void setBundleFile(BundleFile bundleFile, int supportFlags) throws IOException {
        this.bundleFile = bundleFile;
        if (this.certsInitialized) {
            return;
        }
        BundleEntry be = bundleFile.getEntry("META-INF/MANIFEST.MF");
        if (be == null) {
            return;
        }
        Enumeration en = bundleFile.getEntryPaths("META-INF/");
        ArrayList<String> signers = new ArrayList<String>(2);
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!name.endsWith(".DSA") && !name.endsWith(".RSA") || name.indexOf(47) != name.lastIndexOf(47)) continue;
            signers.add(name);
        }
        if (signers.size() == 0) {
            return;
        }
        byte[] manifestBytes = this.readIntoArray(be);
        String latestSigner = this.findLatestSigner(bundleFile, signers);
        try {
            ArrayList<PKCS7Processor> processors = new ArrayList<PKCS7Processor>(signers.size());
            Iterator iSigners = signers.iterator();
            int i = 0;
            while (iSigners.hasNext()) {
                String signer = (String)iSigners.next();
                PKCS7Processor processor = this.processSigner(bundleFile, manifestBytes, signer, latestSigner, supportFlags);
                boolean error = false;
                try {
                    processor.validateCerts();
                    this.determineCertsTrust(processor, supportFlags);
                }
                catch (CertificateExpiredException certificateExpiredException) {
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                }
                catch (InvalidKeyException invalidKeyException) {
                    error = true;
                }
                if (!error) {
                    if (signer == latestSigner) {
                        processors.add(0, processor);
                    } else {
                        processors.add(processor);
                    }
                }
                ++i;
            }
            this.chains = processors.size() == 0 ? null : processors.toArray(new CertificateChain[processors.size()]);
        }
        catch (SignatureException signatureException) {
            throw new SecurityException(NLS.bind(JarVerifierMessages.Signature_Not_Verify_1, new String[]{latestSigner, bundleFile.toString()}));
        }
    }

    private void determineCertsTrust(PKCS7Processor signerPKCS7, int supportFlags) {
        CertificateTrustAuthority trustAuthority = (supportFlags & 2) != 0 ? SignedBundleHook.getTrustAuthority() : trustAllAuthority;
        if (trustAuthority != null) {
            signerPKCS7.determineTrust(trustAuthority);
        }
    }

    private PKCS7Processor processSigner(BundleFile bf, byte[] manifestBytes, String signer, String latestSigner, int supportFlags) throws IOException, SignatureException {
        BundleEntry be = bf.getEntry(signer);
        byte[] pkcs7Bytes = this.readIntoArray(be);
        int dotIndex = signer.lastIndexOf(46);
        be = bf.getEntry(String.valueOf(signer.substring(0, dotIndex)) + ".SF");
        byte[] sfBytes = this.readIntoArray(be);
        PKCS7Processor chain = null;
        try {
            chain = new PKCS7Processor(pkcs7Bytes, 0, pkcs7Bytes.length);
            chain.verifySFSignature(sfBytes, 0, sfBytes.length);
            String digAlg = this.getDigAlgFromSF(sfBytes);
            if (digAlg == null) {
                throw new SecurityException(NLS.bind(JarVerifierMessages.SF_File_Parsing_Error, new String[]{bf.toString()}));
            }
            if (latestSigner == signer) {
                this.verifyManifestAndSingatureFile(manifestBytes, sfBytes);
                if ((supportFlags & 4) != 0) {
                    this.populateManifest(manifestBytes, digAlg);
                }
            }
        }
        catch (InvalidKeyException e) {
            SignedBundleHook.log(e.getMessage(), 4, e);
            throw new SecurityException(NLS.bind(JarVerifierMessages.Invalid_Key_Exception, new String[]{bf.getBaseFile().toString(), e.getMessage()}));
        }
        catch (CertificateException e) {
            SignedBundleHook.log(e.getMessage(), 4, e);
            throw new SecurityException(NLS.bind(JarVerifierMessages.PKCS7_Cert_Excep, new String[]{bf.getBaseFile().toString(), e.getMessage()}));
        }
        catch (NoSuchAlgorithmException e) {
            SignedBundleHook.log(e.getMessage(), 4, e);
            throw new SecurityException(NLS.bind(JarVerifierMessages.PKCS7_No_Such_Algorithm, new String[]{bf.getBaseFile().toString(), e.getMessage()}));
        }
        return chain;
    }

    private String findLatestSigner(BundleFile bf, List names) {
        String result = null;
        long latestTime = Long.MIN_VALUE;
        Iterator iNames = names.iterator();
        while (iNames.hasNext()) {
            String name = (String)iNames.next();
            BundleEntry entry = bf.getEntry(name);
            if (entry.getTime() <= latestTime) continue;
            result = name;
            latestTime = entry.getTime();
        }
        return result;
    }

    private String calculateDigest(MessageDigest digest, byte[] bytes) {
        return new String(Base64.encode(digest.digest(bytes)));
    }

    public File getFile(String path, boolean nativeCode) {
        return this.bundleFile.getFile(path, nativeCode);
    }

    public BundleEntry getEntry(String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        BundleEntry be = this.bundleFile.getEntry(path);
        if (this.digests4entries == null) {
            return be;
        }
        if (be == null) {
            if (this.digests4entries.get(path) == null) {
                return null;
            }
            throw new SecurityException(NLS.bind(JarVerifierMessages.file_is_removed_from_jar, this.getBaseFile().toString(), path));
        }
        if (be.getName().startsWith("META-INF/")) {
            return be;
        }
        if (!this.isSigned()) {
            return be;
        }
        return new SignedBundleEntry(be);
    }

    public Enumeration getEntryPaths(String path) {
        return this.bundleFile.getEntryPaths(path);
    }

    public void close() throws IOException {
        this.bundleFile.close();
    }

    public void open() throws IOException {
        this.bundleFile.open();
    }

    public boolean containsDir(String dir) {
        return this.bundleFile.containsDir(dir);
    }

    boolean matchDNChain(String pattern) {
        CertificateChain[] matchChains = this.getChains();
        int i = 0;
        while (i < matchChains.length) {
            if (matchChains[i].isTrusted() && DNChainMatching.match(matchChains[i].getChain(), pattern)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public File getBaseFile() {
        return this.bundleFile.getBaseFile();
    }

    public void checkContent() throws CertificateException, CertificateExpiredException, SignatureException {
        if (!this.isSigned() || this.digests4entries == null) {
            return;
        }
        Enumeration entries = this.digests4entries.keys();
        while (entries.hasMoreElements()) {
            String name = (String)entries.nextElement();
            BundleEntry entry = this.getEntry(name);
            if (entry == null) {
                throw new SecurityException(NLS.bind(JarVerifierMessages.Jar_Is_Tampered, this.bundleFile.getBaseFile().getName()));
            }
            try {
                entry.getBytes();
            }
            catch (IOException e) {
                SignedBundleHook.log(e.getMessage(), 4, e);
                throw new SecurityException(NLS.bind(JarVerifierMessages.File_In_Jar_Is_Tampered, new String[]{name, this.bundleFile.getBaseFile().toString()}));
            }
        }
        int i = 0;
        while (i < this.chains.length) {
            PKCS7Processor signerPKCS7 = (PKCS7Processor)this.chains[i];
            try {
                signerPKCS7.validateCerts();
            }
            catch (InvalidKeyException e) {
                throw new CertificateException(e.getMessage());
            }
            this.determineCertsTrust(signerPKCS7, 7);
            ++i;
        }
    }

    public String[] verifyContent() {
        if (!this.isSigned() || this.digests4entries == null) {
            return EMPTY_STRING;
        }
        ArrayList<String> corrupted = new ArrayList<String>(0);
        Enumeration entries = this.digests4entries.keys();
        while (entries.hasMoreElements()) {
            String name = (String)entries.nextElement();
            BundleEntry entry = this.getEntry(name);
            if (entry == null) {
                corrupted.add(name);
                continue;
            }
            try {
                entry.getBytes();
            }
            catch (IOException iOException) {
                corrupted.add(name);
            }
        }
        return corrupted.size() == 0 ? EMPTY_STRING : corrupted.toArray(new String[corrupted.size()]);
    }

    public CertificateChain[] getChains() {
        if (!this.isSigned()) {
            return new CertificateChain[0];
        }
        return this.chains;
    }

    public boolean isSigned() {
        return this.chains != null;
    }

    static synchronized MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            SignedBundleHook.log(e.getMessage(), 4, e);
            return null;
        }
    }

    class SignedBundleEntry
    extends BundleEntry {
        BundleEntry nestedEntry;

        SignedBundleEntry(BundleEntry nestedEntry) {
            this.nestedEntry = nestedEntry;
        }

        public InputStream getInputStream() throws IOException {
            String digest;
            String name = this.getName();
            String string = digest = SignedBundleFile.this.digests4entries == null ? null : (String)SignedBundleFile.this.digests4entries.get(name);
            if (digest == null) {
                throw new IOException("Corrupted file: the digest does not exist for the file " + name);
            }
            byte[] results = (byte[])SignedBundleFile.this.results4entries.get(name);
            return new DigestedInputStream(this.nestedEntry.getInputStream(), digest, results, this.nestedEntry.getSize());
        }

        public long getSize() {
            return this.nestedEntry.getSize();
        }

        public String getName() {
            return this.nestedEntry.getName();
        }

        public long getTime() {
            return this.nestedEntry.getTime();
        }

        public URL getLocalURL() {
            return this.nestedEntry.getLocalURL();
        }

        public URL getFileURL() {
            return this.nestedEntry.getFileURL();
        }
    }
}

